/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles.domain;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.net.URI;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;

public class ContainerCDNMetadata
implements Comparable<ContainerCDNMetadata> {
    private String name;
    @Named(value="cdn_enabled")
    private boolean cdnEnabled;
    @Named(value="log_retention")
    private boolean logRetention;
    private long ttl;
    @Named(value="cdn_uri")
    private URI cdnUri;
    @Named(value="cdn_ssl_uri")
    private URI cdnSslUri;
    @Named(value="cdn_streaming_uri")
    private URI cdnStreamingUri;
    @Named(value="cdn_ios_uri")
    private URI cdnIosUri;

    @ConstructorProperties(value={"name", "cdn_enabled", "log_retention", "ttl", "cdn_uri", "cdn_ssl_uri", "cdn_streaming_uri", "cdn_ios_uri"})
    public ContainerCDNMetadata(String name, boolean cdnEnabled, boolean logRetention, long ttl, @Nullable URI cdnUri, @Nullable URI cdnSslUri, @Nullable URI cdnStreamingUri, @Nullable URI cdnIosUri) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.cdnEnabled = (Boolean)Preconditions.checkNotNull((Object)cdnEnabled);
        this.logRetention = (Boolean)Preconditions.checkNotNull((Object)logRetention);
        this.ttl = (Long)Preconditions.checkNotNull((Object)ttl);
        this.cdnUri = cdnUri;
        this.cdnSslUri = cdnSslUri;
        this.cdnStreamingUri = cdnStreamingUri;
        this.cdnIosUri = cdnIosUri;
    }

    public ContainerCDNMetadata() {
    }

    public String getName() {
        return this.name;
    }

    public boolean isCDNEnabled() {
        return this.cdnEnabled;
    }

    public boolean isLogRetention() {
        return this.logRetention;
    }

    public long getTTL() {
        return this.ttl;
    }

    public URI getCDNUri() {
        return this.cdnUri;
    }

    public URI getCDNSslUri() {
        return this.cdnSslUri;
    }

    public URI getCDNStreamingUri() {
        return this.cdnStreamingUri;
    }

    public URI getCDNIosUri() {
        return this.cdnIosUri;
    }

    @Override
    public int compareTo(ContainerCDNMetadata o) {
        if (this.getName() == null) {
            return -1;
        }
        return this == o ? 0 : this.getName().compareTo(o.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cdnUri == null ? 0 : this.cdnUri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerCDNMetadata other = (ContainerCDNMetadata)obj;
        return !(this.cdnUri == null ? other.cdnUri != null : !this.cdnUri.equals(other.cdnUri));
    }

    public String toString() {
        return String.format("[name=%s, cdnEnabled=%s, logRetention=%s, ttl=%s, cdnUri=%s, cdnSslUri=%s, cdnStreamingUri=%s, cdnIosUri=%s]", this.name, this.cdnEnabled, this.logRetention, this.ttl, this.cdnUri, this.cdnSslUri, this.cdnStreamingUri, this.cdnIosUri);
    }
}

