/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.domain.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.domain.Location;
import org.jclouds.domain.internal.ResourceMetadataImpl;
import org.jclouds.javax.annotation.Nullable;

public class StorageMetadataImpl
extends ResourceMetadataImpl<StorageType>
implements StorageMetadata {
    @Nullable
    private final String eTag;
    @Nullable
    private final Date creationDate;
    @Nullable
    private final Date lastModified;
    private final StorageType type;

    public StorageMetadataImpl(StorageType type, @Nullable String id, @Nullable String name, @Nullable Location location, @Nullable URI uri, @Nullable String eTag, @Nullable Date creationDate, @Nullable Date lastModified, Map<String, String> userMetadata) {
        super(id, name, location, uri, userMetadata);
        this.eTag = eTag;
        this.creationDate = creationDate;
        this.lastModified = lastModified;
        this.type = (StorageType)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
    }

    @Override
    public StorageType getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.eTag, this.creationDate, this.lastModified, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StorageMetadataImpl other = (StorageMetadataImpl)obj;
        if (!Objects.equal((Object)this.eTag, (Object)other.eTag)) {
            return false;
        }
        if (!Objects.equal((Object)this.creationDate, (Object)other.creationDate)) {
            return false;
        }
        if (!Objects.equal((Object)this.lastModified, (Object)other.lastModified)) {
            return false;
        }
        return Objects.equal((Object)((Object)this.type), (Object)((Object)other.type));
    }

    @Override
    public String getETag() {
        return this.eTag;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }
}

