/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.s3;

import com.google.auto.service.AutoService;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.aws.domain.Region;
import org.jclouds.aws.s3.AWSS3ApiMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.internal.BaseProviderMetadata;

@AutoService(value=ProviderMetadata.class)
public class AWSS3ProviderMetadata
extends BaseProviderMetadata {
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return AWSS3ProviderMetadata.builder().fromProviderMetadata((ProviderMetadata)this);
    }

    public AWSS3ProviderMetadata() {
        super((BaseProviderMetadata.Builder)AWSS3ProviderMetadata.builder());
    }

    public AWSS3ProviderMetadata(Builder builder) {
        super((BaseProviderMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)Region.regionPropertiesS3());
        properties.setProperty("jclouds.endpoint", "https://s3.amazonaws.com");
        properties.setProperty("jclouds.region.us-standard.endpoint", "https://s3.amazonaws.com");
        properties.setProperty("jclouds.region.us-west-1.endpoint", "https://s3-us-west-1.amazonaws.com");
        properties.setProperty("jclouds.region.us-west-2.endpoint", "https://s3-us-west-2.amazonaws.com");
        properties.setProperty("jclouds.region.sa-east-1.endpoint", "https://s3-sa-east-1.amazonaws.com");
        properties.setProperty("jclouds.region.eu-west-1.endpoint", "https://s3-eu-west-1.amazonaws.com");
        properties.setProperty("jclouds.region.ap-southeast-1.endpoint", "https://s3-ap-southeast-1.amazonaws.com");
        properties.setProperty("jclouds.region.ap-southeast-2.endpoint", "https://s3-ap-southeast-2.amazonaws.com");
        properties.setProperty("jclouds.region.ap-northeast-1.endpoint", "https://s3-ap-northeast-1.amazonaws.com");
        return properties;
    }

    public static class Builder
    extends BaseProviderMetadata.Builder {
        protected Builder() {
            this.id("aws-s3").name("Amazon Simple Storage Service (S3)").apiMetadata((ApiMetadata)new AWSS3ApiMetadata()).homepage(URI.create("http://aws.amazon.com/s3")).console(URI.create("https://console.aws.amazon.com/s3/home")).linkedServices(new String[]{"aws-ec2", "aws-elb", "aws-cloudwatch", "aws-s3", "aws-simpledb"}).iso3166Codes(new String[]{"US", "US-CA", "US-OR", "BR-SP", "IE", "SG", "AU-NSW", "JP-13"}).defaultProperties(AWSS3ProviderMetadata.defaultProperties());
        }

        public AWSS3ProviderMetadata build() {
            return new AWSS3ProviderMetadata(this);
        }

        public Builder fromProviderMetadata(ProviderMetadata in) {
            super.fromProviderMetadata(in);
            return this;
        }
    }
}

