/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.dynect.v3.domain.RecordSet;

public class GeoRegionGroup {
    private final Optional<String> serviceName;
    private final String name;
    private final List<String> countries;
    private final List<RecordSet> recordSets;

    private GeoRegionGroup(Optional<String> serviceName, String name, List<String> countries, List<RecordSet> recordSets) {
        this.serviceName = (Optional)Preconditions.checkNotNull(serviceName, (Object)"serviceName");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.countries = (List)Preconditions.checkNotNull(countries, (String)"countries of %s/%s", serviceName, (Object)name);
        this.recordSets = (List)Preconditions.checkNotNull(recordSets, (String)"recordSets of %s", (Object)name);
    }

    public Optional<String> getServiceName() {
        return this.serviceName;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getCountries() {
        return this.countries;
    }

    public List<RecordSet> getRecordSets() {
        return this.recordSets;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.serviceName, this.name, this.countries, this.recordSets});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof GeoRegionGroup)) {
            return false;
        }
        GeoRegionGroup that = (GeoRegionGroup)GeoRegionGroup.class.cast(obj);
        return Objects.equal(this.serviceName, that.serviceName) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.countries, that.countries) && Objects.equal(this.recordSets, that.recordSets);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("serviceName", this.serviceName.orNull()).add("name", (Object)this.name).add("countries", this.countries).add("recordSets", this.recordSets).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return GeoRegionGroup.builder().from(this);
    }

    public static class Builder {
        private Optional<String> serviceName = Optional.absent();
        private String name;
        private ImmutableList.Builder<String> countries = ImmutableList.builder();
        private ImmutableList.Builder<RecordSet> recordSets = ImmutableList.builder();

        public Builder serviceName(String serviceName) {
            this.serviceName = Optional.fromNullable((Object)serviceName);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addCountry(String country) {
            this.countries.add((Object)country);
            return this;
        }

        public Builder countries(Iterable<String> countries) {
            this.countries = ImmutableList.builder().addAll(countries);
            return this;
        }

        public Builder addAllCountries(Iterable<String> countries) {
            this.countries.addAll(countries);
            return this;
        }

        public Builder addRecordSet(RecordSet recordSet) {
            this.recordSets.add((Object)recordSet);
            return this;
        }

        public Builder recordSets(Iterable<RecordSet> recordSets) {
            this.recordSets = ImmutableList.builder().addAll(recordSets);
            return this;
        }

        public Builder addAllRecordSets(Iterable<RecordSet> recordSets) {
            this.recordSets.addAll(recordSets);
            return this;
        }

        public GeoRegionGroup build() {
            return new GeoRegionGroup(this.serviceName, this.name, (List)this.countries.build(), (List)this.recordSets.build());
        }

        public Builder from(GeoRegionGroup in) {
            return this.serviceName((String)in.serviceName.orNull()).name(in.name).countries(in.countries).recordSets(in.recordSets);
        }
    }
}

