/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.dynect.v3.domain.Node;

public class RecordId
extends Node {
    private final long id;
    private final String type;

    @ConstructorProperties(value={"zone", "fqdn", "record_type", "record_id"})
    RecordId(String zone, String fqdn, String type, long id) {
        super(zone, fqdn);
        this.id = id;
        this.type = (String)Preconditions.checkNotNull((Object)type, (String)"type of %s", (long)id);
    }

    public String getType() {
        return this.type;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getZone(), this.getFQDN(), this.type, this.id});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RecordId)) {
            return false;
        }
        RecordId that = (RecordId)RecordId.class.cast(obj);
        return super.equals(obj) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.id, (Object)that.id);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).add("zone", (Object)this.getZone()).add("fqdn", (Object)this.getFQDN()).add("type", (Object)this.type).add("id", this.id);
    }

    public static Builder<?> recordIdBuilder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().from(this);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<B extends Builder<B>> {
        protected String zone;
        protected String fqdn;
        protected String type;
        protected long id;

        protected abstract B self();

        public B zone(String zone) {
            this.zone = zone;
            return this.self();
        }

        public B fqdn(String fqdn) {
            this.fqdn = fqdn;
            return this.self();
        }

        public B type(String type) {
            this.type = type;
            return this.self();
        }

        public B id(long id) {
            this.id = id;
            return this.self();
        }

        public RecordId build() {
            return new RecordId(this.zone, this.fqdn, this.type, this.id);
        }

        public B from(RecordId in) {
            return ((Builder)((Builder)((Builder)this.zone(in.getZone())).fqdn(in.getFQDN())).type(in.type)).id(in.id);
        }
    }
}

