/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain.rdata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.Map;

public class SSHFPData
extends ForwardingMap<String, Object> {
    private final int algorithm;
    private final int fptype;
    private final String fingerprint;
    private final transient ImmutableMap<String, Object> delegate;

    public static SSHFPData createDSA(String fingerprint) {
        return SSHFPData.builder().algorithm(2).fptype(1).fingerprint(fingerprint).build();
    }

    public static SSHFPData createRSA(String fingerprint) {
        return SSHFPData.builder().algorithm(1).fptype(1).fingerprint(fingerprint).build();
    }

    @ConstructorProperties(value={"algorithm", "fptype", "fingerprint"})
    private SSHFPData(int algorithm, int fptype, String fingerprint) {
        Preconditions.checkArgument((algorithm >= 0 ? 1 : 0) != 0, (String)"algorithm of %s must be unsigned", (Object)fingerprint);
        this.algorithm = algorithm;
        Preconditions.checkArgument((fptype >= 0 ? 1 : 0) != 0, (String)"fptype of %s must be unsigned", (Object)fingerprint);
        this.fptype = fptype;
        this.fingerprint = (String)Preconditions.checkNotNull((Object)fingerprint, (Object)"fingerprint");
        this.delegate = ImmutableMap.builder().put((Object)"algorithm", (Object)algorithm).put((Object)"fptype", (Object)fptype).put((Object)"fingerprint", (Object)fingerprint).build();
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public int getType() {
        return this.fptype;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected Map<String, Object> delegate() {
        return this.delegate;
    }

    public static final class Builder {
        private int algorithm;
        private int fptype;
        private String fingerprint;

        public Builder algorithm(int algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder fptype(int fptype) {
            this.fptype = fptype;
            return this;
        }

        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            return this;
        }

        public SSHFPData build() {
            return new SSHFPData(this.algorithm, this.fptype, this.fingerprint);
        }
    }
}

