/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecloudstorage.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import org.jclouds.blobstore.domain.Tier;

public final class DomainResourceReferences {
    private DomainResourceReferences() {
    }

    public static enum DestinationPredefinedAcl {
        AUTHENTICATED_READ,
        BUCKET_OWNER_FULLCONTROL,
        BUCKET_OWNER_READ,
        PRIVATE,
        PROJECT_PRIVATE,
        PUBLIC_READ;


        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
        }

        public String toString() {
            return this.value();
        }

        public static DestinationPredefinedAcl fromValue(String destinationPredefinedAcl) {
            return DestinationPredefinedAcl.valueOf(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, destinationPredefinedAcl));
        }
    }

    public static enum PredefinedAcl {
        AUTHENTICATED_READ,
        PRIVATE,
        PROJEECT_PRIVATE,
        PUBLIC_READ,
        PUBLIC_READ_WRITE;


        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
        }

        public String toString() {
            return this.value();
        }

        public static PredefinedAcl fromValue(String predefinedAcl) {
            return PredefinedAcl.valueOf(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, predefinedAcl));
        }
    }

    public static enum Projection {
        NO_ACL,
        FULL;


        public String value() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
        }

        public String toString() {
            return this.value();
        }

        public static Projection fromValue(String projection) {
            return Projection.valueOf(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, projection));
        }
    }

    public static enum StorageClass {
        COLDLINE(Tier.ARCHIVE),
        DURABLE_REDUCED_AVAILABILITY(Tier.STANDARD),
        MULTI_REGIONAL(Tier.STANDARD),
        NEARLINE(Tier.INFREQUENT),
        STANDARD(Tier.STANDARD);

        private final Tier tier;

        private StorageClass(Tier tier) {
            this.tier = (Tier)Preconditions.checkNotNull((Object)tier, (Object)"tier");
        }

        public static StorageClass fromTier(Tier tier) {
            switch (tier) {
                case STANDARD: {
                    return STANDARD;
                }
                case INFREQUENT: {
                    return NEARLINE;
                }
                case ARCHIVE: {
                    return COLDLINE;
                }
            }
            throw new IllegalArgumentException("invalid tier: " + tier);
        }

        public Tier toTier() {
            return this.tier;
        }
    }

    public static enum Location {
        ASIA,
        EU,
        US,
        ASIA_EAST1,
        ASIA_NORTHEAST1,
        ASIA_SOUTH1,
        ASIA_SOUTHEAST1,
        NORTHAMERICA_NORTHEAST1,
        US_CENTRAL1,
        US_EAST1,
        US_EAST4,
        US_WEST1,
        SOUTHAMERICA_EAST1,
        EUROPE_WEST1,
        EUROPE_WEST2,
        EUROPE_WEST3,
        EUROPE_WEST4,
        AUSTRALIA_SOUTHEAST1,
        US_CENTRAL2;


        public String value() {
            return this.name().replace('_', '-');
        }

        public String toString() {
            return this.value();
        }

        public static Location fromValue(String location) {
            return Location.valueOf(location.replace('-', '_'));
        }
    }

    public static enum ObjectRole {
        READER,
        OWNER;

    }
}

