/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.graph;

import java.util.Iterator;
import org.apache.jena.atlas.data.DataBag;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.TripleStore;
import org.apache.jena.mem.GraphMemBase;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.WrappedIterator;

public abstract class GraphDataBag
extends GraphMemBase {
    private final ThresholdPolicy<Triple> thresholdPolicy;
    private DataBag<Triple> db;

    public GraphDataBag(ThresholdPolicy<Triple> thresholdPolicy) {
        this.thresholdPolicy = thresholdPolicy;
        this.capabilities = new Capabilities(){

            public boolean sizeAccurate() {
                return false;
            }

            public boolean addAllowed() {
                return this.addAllowed(false);
            }

            public boolean addAllowed(boolean every) {
                return true;
            }

            public boolean deleteAllowed() {
                return this.deleteAllowed(false);
            }

            public boolean deleteAllowed(boolean every) {
                return false;
            }

            public boolean canBeEmpty() {
                return true;
            }

            public boolean iteratorRemoveAllowed() {
                return false;
            }

            public boolean findContractSafe() {
                return true;
            }

            public boolean handlesLiteralTyping() {
                return true;
            }
        };
        this.db = this.createDataBag();
    }

    protected abstract DataBag<Triple> createDataBag();

    protected ThresholdPolicy<Triple> getThresholdPolicy() {
        return this.thresholdPolicy;
    }

    protected TripleStore createTripleStore() {
        return null;
    }

    public void performAdd(Triple t) {
        this.db.add(t);
    }

    public int graphBaseSize() {
        return (int)this.db.size();
    }

    protected void destroy() {
        this.db.close();
    }

    public void clear() {
        this.db.close();
        this.db = this.createDataBag();
    }

    protected ExtendedIterator<Triple> graphBaseFind(Triple m) {
        Iterator iter = Iter.filter((Iterator)this.db.iterator(), arg_0 -> ((Triple)m).matches(arg_0));
        return WrappedIterator.create((Iterator)iter);
    }
}

