/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Tuple;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.DatasetPrefixStorage;
import org.apache.jena.sparql.graph.GraphPrefixesProjection;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.apache.jena.tdb.store.nodetupletable.NodeTupleTable;

public class DatasetPrefixesTDB
implements DatasetPrefixStorage {
    static final RecordFactory factory = new RecordFactory(24, 0);
    static final String unamedGraphURI = "";
    private final NodeTupleTable nodeTupleTable;

    public DatasetPrefixesTDB(NodeTupleTable nodeTupleTable) {
        this.nodeTupleTable = nodeTupleTable;
    }

    public synchronized void insertPrefix(String graphName, String prefix, String uri) {
        Node g = NodeFactory.createURI((String)graphName);
        Node p = NodeFactory.createLiteral((String)prefix);
        Node u = NodeFactory.createURI((String)uri);
        this.nodeTupleTable.addRow(g, p, u);
    }

    public Set<String> graphNames() {
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(new Node[]{null, null, null});
        HashSet<String> x = new HashSet<String>();
        while (iter.hasNext()) {
            x.add(((Node)iter.next().get(0)).getURI());
        }
        Iter.close(iter);
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String readPrefix(String graphName, String prefix) {
        Node g = NodeFactory.createURI((String)graphName);
        Node p = NodeFactory.createLiteral((String)prefix);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, p, null);
        try {
            if (!iter.hasNext()) {
                String string = null;
                return string;
            }
            Tuple<Node> t = iter.next();
            Node uri = (Node)t.get(2);
            String string = uri.getURI();
            return string;
        }
        finally {
            Iter.close(iter);
        }
    }

    public synchronized String readByURI(String graphName, String uriStr) {
        Node g = NodeFactory.createURI((String)graphName);
        Node u = NodeFactory.createURI((String)uriStr);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, null, u);
        if (!iter.hasNext()) {
            return null;
        }
        Node prefix = (Node)iter.next().get(1);
        Iter.close(iter);
        return prefix.getLiteralLexicalForm();
    }

    public synchronized Map<String, String> readPrefixMap(String graphName) {
        HashMap<String, String> map = new HashMap<String, String>();
        Node g = NodeFactory.createURI((String)graphName);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, null, null);
        while (iter.hasNext()) {
            try {
                Tuple<Node> t = iter.next();
                String prefix = ((Node)t.get(1)).getLiteralLexicalForm();
                String uri = ((Node)t.get(2)).getURI();
                map.put(prefix, uri);
            }
            catch (Exception ex) {
                Log.warn((Object)this, (String)("Mangled prefix map: graph name=" + graphName), (Throwable)ex);
            }
        }
        Iter.close(iter);
        return map;
    }

    public synchronized void loadPrefixMapping(String graphName, PrefixMapping pmap) {
        Node g = NodeFactory.createURI((String)graphName);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, null, null);
        while (iter.hasNext()) {
            Tuple<Node> t = iter.next();
            String prefix = ((Node)t.get(1)).getLiteralLexicalForm();
            String uri = ((Node)t.get(2)).getURI();
            pmap.setNsPrefix(prefix, uri);
        }
        Iter.close(iter);
    }

    public synchronized void removeFromPrefixMap(String graphName, String prefix) {
        Node g = NodeFactory.createURI((String)graphName);
        Node p = NodeFactory.createLiteral((String)prefix);
        Iterator<Tuple<Node>> iter = this.nodeTupleTable.find(g, p, null);
        List list = Iter.toList(iter);
        Iter.close(iter);
        for (Tuple tuple : list) {
            this.nodeTupleTable.deleteRow(g, p, (Node)tuple.get(2));
        }
    }

    public NodeTupleTable getNodeTupleTable() {
        return this.nodeTupleTable;
    }

    public PrefixMapping getPrefixMapping() {
        return this.getPrefixMapping(unamedGraphURI);
    }

    public PrefixMapping getPrefixMapping(String graphName) {
        GraphPrefixesProjection pm = new GraphPrefixesProjection(graphName, (DatasetPrefixStorage)this);
        pm.getNsPrefixMap();
        return pm;
    }

    public void close() {
        this.nodeTupleTable.close();
    }

    public void sync() {
        this.nodeTupleTable.sync();
    }
}

