/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.transaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.sys.FileRef;
import org.apache.jena.tdb.sys.SystemTDB;
import org.apache.jena.tdb.transaction.BlockMgrJournal;
import org.apache.jena.tdb.transaction.DatasetGraphTxn;
import org.apache.jena.tdb.transaction.Journal;
import org.apache.jena.tdb.transaction.JournalEntryType;
import org.apache.jena.tdb.transaction.NodeTableTrans;
import org.apache.jena.tdb.transaction.TDBTransactionException;
import org.apache.jena.tdb.transaction.TransactionLifecycle;
import org.apache.jena.tdb.transaction.TransactionManager;
import org.apache.jena.tdb.transaction.TxnState;

public class Transaction {
    private final long id;
    private final String label;
    private final TransactionManager txnMgr;
    private final Journal journal;
    private final ReadWrite mode;
    private final List<NodeTableTrans> nodeTableTrans = new ArrayList<NodeTableTrans>();
    private final List<BlockMgrJournal> blkMgrs = new ArrayList<BlockMgrJournal>();
    private final DatasetGraphTDB basedsg;
    private final List<Iterator<?>> iterators;
    private DatasetGraphTxn activedsg;
    private TxnState state;
    private TxnOutcome outcome;
    private boolean changesPending;
    private int count = 0;
    private int peekCount = 0;

    public Transaction(DatasetGraphTDB dsg, ReadWrite mode, long id, String label, TransactionManager txnMgr) {
        this.id = id;
        if (label == null) {
            label = "Txn";
        }
        label = label + "[" + id + "]";
        switch (mode) {
            case READ: {
                label = label + "/R";
                break;
            }
            case WRITE: {
                label = label + "/W";
            }
        }
        this.label = label;
        this.txnMgr = txnMgr;
        this.basedsg = dsg;
        this.mode = mode;
        this.journal = txnMgr == null ? null : txnMgr.getJournal();
        this.activedsg = null;
        this.iterators = null;
        this.state = TxnState.ACTIVE;
        this.outcome = TxnOutcome.UNFINISHED;
        this.changesPending = mode == ReadWrite.WRITE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Transaction transaction = this;
        synchronized (transaction) {
            switch (this.mode) {
                case READ: {
                    this.outcome = TxnOutcome.R_COMMITED;
                    break;
                }
                case WRITE: {
                    if (this.state != TxnState.ACTIVE) {
                        throw new TDBTransactionException("Transaction has already committed or aborted");
                    }
                    try {
                        this.prepare();
                    }
                    catch (RuntimeException ex) {
                        if (this.isIOException(ex)) {
                            SystemTDB.errlog.warn("IOException during 'prepare' : attempting transaction abort: " + ex.getMessage());
                        } else {
                            SystemTDB.errlog.warn("Exception during 'prepare' : attempting transaction abort", (Throwable)ex);
                        }
                        this.state = TxnState.ACTIVE;
                        try {
                            this.abort();
                        }
                        catch (RuntimeException ex2) {
                            SystemTDB.errlog.warn("Exception during 'abort' after 'prepare'", (Throwable)ex2);
                        }
                        throw new TDBTransactionException("Abort during prepare - transaction did not commit", ex);
                    }
                    try {
                        this.journal.write(JournalEntryType.Commit, FileRef.Journal, null);
                        this.journal.sync();
                    }
                    catch (RuntimeException ex) {
                        if (this.isIOException(ex)) {
                            SystemTDB.errlog.warn("IOException during 'commit' : transaction status not known (but not a partial commit): " + ex.getMessage());
                        } else {
                            SystemTDB.errlog.warn("Exception during 'commit' : transaction status not known (but not a partial commit): ", (Throwable)ex);
                        }
                        throw new TDBTransactionException("Exception at commit point", ex);
                    }
                    this.outcome = TxnOutcome.W_COMMITED;
                }
            }
            this.state = TxnState.COMMITED;
        }
        try {
            this.txnMgr.notifyCommit(this);
        }
        catch (RuntimeException ex) {
            if (this.isIOException(ex)) {
                SystemTDB.errlog.warn("IOException after commit point : transaction commited but internal status not recorded properly : " + ex.getMessage());
            } else {
                SystemTDB.errlog.warn("Exception after commit point : transaction commited but internal status not recorded properly", (Throwable)ex);
            }
            throw new TDBTransactionException("Exception after commit point - transaction did commit", ex);
        }
    }

    private boolean isIOException(Throwable ex) {
        while (ex != null) {
            if (ex instanceof IOException) {
                return true;
            }
            ex = ex.getCause();
        }
        return false;
    }

    private void prepare() {
        this.state = TxnState.PREPARING;
        for (BlockMgrJournal blockMgrJournal : this.blkMgrs) {
            blockMgrJournal.commitPrepare(this);
        }
        for (NodeTableTrans nodeTableTrans : this.nodeTableTrans) {
            nodeTableTrans.commitPrepare(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        Transaction transaction = this;
        synchronized (transaction) {
            switch (this.mode) {
                case READ: {
                    this.state = TxnState.ABORTED;
                    this.outcome = TxnOutcome.R_ABORTED;
                    break;
                }
                case WRITE: {
                    if (this.state != TxnState.ACTIVE) {
                        throw new TDBTransactionException("Transaction has already committed or aborted");
                    }
                    try {
                        for (BlockMgrJournal blockMgrJournal : this.blkMgrs) {
                            blockMgrJournal.abort(this);
                        }
                        for (NodeTableTrans nodeTableTrans : this.nodeTableTrans) {
                            nodeTableTrans.abort(this);
                        }
                    }
                    catch (RuntimeException ex) {
                        if (this.isIOException(ex)) {
                            SystemTDB.errlog.warn("IOException during 'abort' : " + ex.getMessage());
                        } else {
                            SystemTDB.errlog.warn("Exception during 'abort'", (Throwable)ex);
                        }
                        throw new TDBTransactionException("Exception during abort - transaction did abort", ex);
                    }
                    this.state = TxnState.ABORTED;
                    this.outcome = TxnOutcome.W_ABORTED;
                }
            }
        }
        try {
            this.txnMgr.notifyAbort(this);
        }
        catch (RuntimeException ex) {
            if (this.isIOException(ex)) {
                SystemTDB.errlog.warn("IOException during post-abort (transaction did abort): " + ex.getMessage());
            } else {
                SystemTDB.errlog.warn("Exception during post-abort (transaction did abort)", (Throwable)ex);
            }
            throw new TDBTransactionException("Exception after abort point - transaction did abort", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Transaction transaction = this;
        synchronized (transaction) {
            switch (this.state) {
                case CLOSED: {
                    return;
                }
                case ACTIVE: {
                    if (this.mode == ReadWrite.READ) {
                        this.commit();
                        this.outcome = TxnOutcome.R_CLOSED;
                        break;
                    }
                    SystemTDB.errlog.warn("Transaction not commited or aborted: " + this);
                    this.abort();
                    break;
                }
            }
            this.state = TxnState.CLOSED;
            if (this.iterators != null) {
                this.iterators.clear();
            }
        }
        this.txnMgr.notifyClose(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalEnacted() {
        Transaction transaction = this;
        synchronized (transaction) {
            if (!this.changesPending) {
                Log.warn((Object)this, (String)"Transaction was a read transaction or a write transaction that has already been flushed");
            }
            this.changesPending = false;
        }
    }

    public ReadWrite getMode() {
        return this.mode;
    }

    public boolean isRead() {
        return this.mode == ReadWrite.READ;
    }

    public TxnState getState() {
        return this.state;
    }

    public long getTxnId() {
        return this.id;
    }

    public TransactionManager getTxnMgr() {
        return this.txnMgr;
    }

    public DatasetGraphTxn getActiveDataset() {
        return this.activedsg;
    }

    public void setActiveDataset(DatasetGraphTxn activedsg) {
        this.activedsg = activedsg;
        if (activedsg.getTransaction() != this) {
            Log.warn((Object)this, (String)("Active DSG does not point to this transaction; " + this));
        }
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void addIterator(Iterator<?> iter) {
        ++this.count;
        this.peekCount = Math.max(this.peekCount, this.count);
        if (this.iterators != null) {
            this.iterators.add(iter);
        }
    }

    public void removeIterator(Iterator<?> iter) {
        --this.count;
        if (this.iterators != null) {
            this.iterators.remove(iter);
        }
        if (this.count == 0) {
            this.peekCount = 0;
        }
    }

    public List<TransactionLifecycle> lifecycleComponents() {
        ArrayList<TransactionLifecycle> x = new ArrayList<TransactionLifecycle>();
        x.addAll(this.nodeTableTrans);
        x.addAll(this.blkMgrs);
        return x;
    }

    public void addComponent(NodeTableTrans ntt) {
        this.nodeTableTrans.add(ntt);
    }

    public void addComponent(BlockMgrJournal blkMgr) {
        this.blkMgrs.add(blkMgr);
    }

    public DatasetGraphTDB getBaseDataset() {
        return this.basedsg;
    }

    public String toString() {
        return "Transaction: " + this.id + " : Mode=" + this.mode + " : State=" + (Object)((Object)this.state) + " : " + this.basedsg.getLocation().getDirectoryPath();
    }

    public String getLabel() {
        return this.label;
    }

    static enum TxnOutcome {
        UNFINISHED,
        W_ABORTED,
        W_COMMITED,
        R_CLOSED,
        R_ABORTED,
        R_COMMITED;

    }
}

