/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import java.util.function.Function;
import org.apache.jena.graph.Node;
import org.apache.jena.query.text.TextHit;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.util.NodeFactoryExtra;

public class TextHitConverter
implements Function<TextHit, Binding> {
    private Binding binding;
    private Var match;
    private Var score;
    private Var literal;

    public TextHitConverter(Binding binding, Var match, Var score, Var literal) {
        this.binding = binding;
        this.match = match;
        this.score = score;
        this.literal = literal;
    }

    @Override
    public Binding apply(TextHit hit) {
        if (this.score == null && this.literal == null) {
            return BindingFactory.binding((Binding)this.binding, (Var)this.match, (Node)hit.getNode());
        }
        BindingMap bmap = BindingFactory.create((Binding)this.binding);
        bmap.add(this.match, hit.getNode());
        if (this.score != null) {
            bmap.add(this.score, NodeFactoryExtra.floatToNode((float)hit.getScore()));
        }
        if (this.literal != null) {
            bmap.add(this.literal, hit.getLiteral());
        }
        return bmap;
    }
}

