/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.text.Entity;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextHit;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexConfig;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextIndexParseException;
import org.apache.jena.query.text.TextQueryFuncs;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextIndexLucene
implements TextIndex {
    private static Logger log = LoggerFactory.getLogger(TextIndexLucene.class);
    private static int MAX_N = 10000;
    public static final Version VER = Version.LUCENE_4_9;
    private static final String DATATYPE_PREFIX = "^^";
    public static final FieldType ftIRI = new FieldType();
    public static final FieldType ftString;
    private final EntityDefinition docDef;
    private final Directory directory;
    private final Analyzer analyzer;
    private final Analyzer queryAnalyzer;
    private final FieldType ftText;
    private volatile IndexWriter indexWriter;

    public TextIndexLucene(Directory directory, TextIndexConfig config) {
        this.directory = directory;
        this.docDef = config.getEntDef();
        HashMap<String, Object> analyzerPerField = new HashMap<String, Object>();
        analyzerPerField.put(this.docDef.getEntityField(), new KeywordAnalyzer());
        if (this.docDef.getGraphField() != null) {
            analyzerPerField.put(this.docDef.getGraphField(), new KeywordAnalyzer());
        }
        for (String field : this.docDef.fields()) {
            Analyzer _analyzer = this.docDef.getAnalyzer(field);
            if (_analyzer == null) continue;
            analyzerPerField.put(field, _analyzer);
        }
        this.analyzer = new PerFieldAnalyzerWrapper((Analyzer)(null != config.getAnalyzer() ? config.getAnalyzer() : new StandardAnalyzer(VER)), analyzerPerField);
        this.queryAnalyzer = null != config.getQueryAnalyzer() ? config.getQueryAnalyzer() : this.analyzer;
        FieldType fieldType = this.ftText = config.isValueStored() ? TextField.TYPE_STORED : TextField.TYPE_NOT_STORED;
        if (config.isValueStored() && this.docDef.getLangField() == null) {
            log.warn("Values stored but langField not set. Returned values will not have language tag or datatype.");
        }
        this.openIndexWriter();
    }

    private void openIndexWriter() {
        IndexWriterConfig wConfig = new IndexWriterConfig(VER, this.analyzer);
        try {
            this.indexWriter = new IndexWriter(this.directory, wConfig);
            this.indexWriter.commit();
        }
        catch (IOException e) {
            throw new TextIndexException(e);
        }
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Analyzer getQueryAnalyzer() {
        return this.queryAnalyzer;
    }

    public IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    @Override
    public void prepareCommit() {
        try {
            this.indexWriter.prepareCommit();
        }
        catch (IOException e) {
            throw new TextIndexException(e);
        }
    }

    @Override
    public void commit() {
        try {
            this.indexWriter.commit();
        }
        catch (IOException e) {
            throw new TextIndexException(e);
        }
    }

    @Override
    public void rollback() {
        IndexWriter idx = this.indexWriter;
        this.indexWriter = null;
        try {
            idx.rollback();
        }
        catch (IOException e) {
            throw new TextIndexException(e);
        }
        this.openIndexWriter();
    }

    public void close() {
        try {
            this.indexWriter.close();
        }
        catch (IOException ex) {
            throw new TextIndexException(ex);
        }
    }

    @Override
    public void updateEntity(Entity entity) {
        if (log.isDebugEnabled()) {
            log.debug("Update entity: " + entity);
        }
        try {
            this.updateDocument(entity);
        }
        catch (IOException e) {
            throw new TextIndexException(e);
        }
    }

    protected void updateDocument(Entity entity) throws IOException {
        Document doc = this.doc(entity);
        Term term = new Term(this.docDef.getEntityField(), entity.getId());
        this.indexWriter.updateDocument(term, (Iterable)doc);
    }

    @Override
    public void addEntity(Entity entity) {
        if (log.isDebugEnabled()) {
            log.debug("Add entity: " + entity);
        }
        try {
            this.addDocument(entity);
        }
        catch (IOException e) {
            throw new TextIndexException(e);
        }
    }

    protected void addDocument(Entity entity) throws IOException {
        Document doc = this.doc(entity);
        this.indexWriter.addDocument((Iterable)doc);
    }

    @Override
    public void deleteEntity(Entity entity) {
        if (this.docDef.getUidField() == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Delete entity: " + entity);
        }
        try {
            Map<String, Object> map = entity.getMap();
            String property = map.keySet().iterator().next();
            String value = (String)map.get(property);
            String hash = entity.getChecksum(property, value);
            Term uid = new Term(this.docDef.getUidField(), hash);
            this.indexWriter.deleteDocuments(new Term[]{uid});
        }
        catch (Exception e) {
            throw new TextIndexException(e);
        }
    }

    protected Document doc(Entity entity) {
        Document doc = new Document();
        Field entField = new Field(this.docDef.getEntityField(), entity.getId(), ftIRI);
        doc.add((IndexableField)entField);
        String graphField = this.docDef.getGraphField();
        if (graphField != null) {
            Field gField = new Field(graphField, entity.getGraph(), ftString);
            doc.add((IndexableField)gField);
        }
        String langField = this.docDef.getLangField();
        String uidField = this.docDef.getUidField();
        for (Map.Entry<String, Object> e : entity.getMap().entrySet()) {
            doc.add((IndexableField)new Field(e.getKey(), (String)e.getValue(), this.ftText));
            if (langField != null) {
                String lang = entity.getLanguage();
                RDFDatatype datatype = entity.getDatatype();
                if (lang != null && !"".equals(lang)) {
                    doc.add((IndexableField)new Field(langField, lang, StringField.TYPE_STORED));
                } else if (datatype != null && !datatype.equals(XSDDatatype.XSDstring)) {
                    doc.add((IndexableField)new Field(langField, DATATYPE_PREFIX + datatype.getURI(), StringField.TYPE_STORED));
                }
            }
            if (uidField == null) continue;
            String hash = entity.getChecksum(e.getKey(), (String)e.getValue());
            doc.add((IndexableField)new Field(uidField, hash, StringField.TYPE_STORED));
        }
        return doc;
    }

    @Override
    public Map<String, Node> get(String uri) {
        try {
            DirectoryReader indexReader = DirectoryReader.open((Directory)this.directory);
            List<Map<String, Node>> x = this.get$((IndexReader)indexReader, uri);
            if (x.size() == 0) {
                return null;
            }
            return x.get(0);
        }
        catch (Exception ex) {
            throw new TextIndexException(ex);
        }
    }

    private static Query parseQuery(String queryString, String primaryField, Analyzer analyzer) throws ParseException {
        QueryParser queryParser = new QueryParser(VER, primaryField, analyzer);
        queryParser.setAllowLeadingWildcard(true);
        Query query = queryParser.parse(queryString);
        return query;
    }

    protected Query preParseQuery(String queryString, String primaryField, Analyzer analyzer) throws ParseException {
        return TextIndexLucene.parseQuery(queryString, primaryField, analyzer);
    }

    private List<Map<String, Node>> get$(IndexReader indexReader, String uri) throws ParseException, IOException {
        String escaped = QueryParserBase.escape((String)uri);
        String qs = this.docDef.getEntityField() + ":" + escaped;
        Query query = this.preParseQuery(qs, this.docDef.getPrimaryField(), this.queryAnalyzer);
        IndexSearcher indexSearcher = new IndexSearcher(indexReader);
        ScoreDoc[] sDocs = indexSearcher.search((Query)query, (int)1).scoreDocs;
        ArrayList<Map<String, Node>> records = new ArrayList<Map<String, Node>>();
        for (ScoreDoc sd : sDocs) {
            Document doc = indexSearcher.doc(sd.doc);
            String[] x = doc.getValues(this.docDef.getEntityField());
            if (x.length != 1) {
                // empty if block
            }
            String uriStr = x[0];
            HashMap<String, Node> record = new HashMap<String, Node>();
            Node entity = NodeFactory.createURI((String)uriStr);
            record.put(this.docDef.getEntityField(), entity);
            for (String f : this.docDef.fields()) {
                String[] values;
                for (String v : values = doc.getValues(f)) {
                    Node n = this.entryToNode(v);
                    record.put(f, n);
                }
                records.add(record);
            }
        }
        return records;
    }

    @Override
    public List<TextHit> query(Node property, String qs) {
        return this.query(property, qs, MAX_N);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<TextHit> query(Node property, String qs, int limit) {
        try (DirectoryReader indexReader = DirectoryReader.open((Directory)this.directory);){
            List<TextHit> list = this.query$((IndexReader)indexReader, property, qs, limit);
            return list;
        }
        catch (ParseException ex) {
            throw new TextIndexParseException(qs, ex.getMessage());
        }
        catch (Exception ex) {
            throw new TextIndexException(ex);
        }
    }

    private List<TextHit> query$(IndexReader indexReader, Node property, String qs, int limit) throws ParseException, IOException {
        IndexSearcher indexSearcher = new IndexSearcher(indexReader);
        Query query = this.preParseQuery(qs, this.docDef.getPrimaryField(), this.queryAnalyzer);
        if (limit <= 0) {
            limit = MAX_N;
        }
        ScoreDoc[] sDocs = indexSearcher.search((Query)query, (int)limit).scoreDocs;
        ArrayList<TextHit> results = new ArrayList<TextHit>();
        for (ScoreDoc sd : sDocs) {
            Document doc = indexSearcher.doc(sd.doc);
            String[] values = doc.getValues(this.docDef.getEntityField());
            Node literal = null;
            String field = property != null ? this.docDef.getField(property) : this.docDef.getPrimaryField();
            String[] lexicals = doc.getValues(field);
            if (lexicals.length > 0) {
                String lexical = lexicals[0];
                String[] langs = doc.getValues(this.docDef.getLangField());
                if (langs.length > 0) {
                    String lang = langs[0];
                    if (lang.startsWith(DATATYPE_PREFIX)) {
                        String datatype = lang.substring(DATATYPE_PREFIX.length());
                        TypeMapper tmap = TypeMapper.getInstance();
                        literal = NodeFactory.createLiteral((String)lexical, (RDFDatatype)tmap.getSafeTypeByName(datatype));
                    } else {
                        literal = NodeFactory.createLiteral((String)lexical, (String)lang);
                    }
                } else {
                    literal = NodeFactory.createLiteral((String)lexical);
                }
            }
            for (String v : values) {
                Node n = TextQueryFuncs.stringToNode(v);
                TextHit hit = new TextHit(n, sd.score, literal);
                results.add(hit);
            }
        }
        return results;
    }

    @Override
    public EntityDefinition getDocDef() {
        return this.docDef;
    }

    private Node entryToNode(String v) {
        return NodeFactoryExtra.createLiteralNode((String)v, null, null);
    }

    static {
        ftIRI.setTokenized(false);
        ftIRI.setStored(true);
        ftIRI.setIndexed(true);
        ftIRI.freeze();
        ftString = StringField.TYPE_NOT_STORED;
    }
}

