/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryBuildException;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.query.text.DatasetGraphText;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextHit;
import org.apache.jena.query.text.TextHitConverter;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.TextQuery;
import org.apache.jena.query.text.TextQueryFuncs;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.engine.iterator.QueryIterSlice;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropFuncArgType;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.FmtUtils;
import org.apache.jena.sparql.util.IterLib;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.sparql.util.Symbol;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextQueryPF
implements PropertyFunction {
    private static Logger log = LoggerFactory.getLogger(TextQueryPF.class);
    private TextIndex textIndex = null;
    private boolean warningIssued = false;
    private String langArg = null;
    private static final Symbol cacheSymbol = Symbol.create((String)"TextQueryPF.cache");

    public void build(PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        int size;
        if (PropFuncArgType.PF_ARG_EITHER.equals((Object)PropFuncArgType.PF_ARG_SINGLE) && argSubject.isList()) {
            throw new QueryBuildException("List arguments (subject) to " + predicate.getURI());
        }
        if (PropFuncArgType.PF_ARG_EITHER.equals((Object)PropFuncArgType.PF_ARG_LIST) && !argSubject.isList()) {
            throw new QueryBuildException("Single argument, list expected (subject) to " + predicate.getURI());
        }
        if (PropFuncArgType.PF_ARG_EITHER.equals((Object)PropFuncArgType.PF_ARG_SINGLE) && argObject.isList() && !argObject.isNode()) {
            throw new QueryBuildException("List arguments (object) to " + predicate.getURI());
        }
        if (PropFuncArgType.PF_ARG_EITHER.equals((Object)PropFuncArgType.PF_ARG_LIST) && !argObject.isList()) {
            throw new QueryBuildException("Single argument, list expected (object) to " + predicate.getURI());
        }
        DatasetGraph dsg = execCxt.getDataset();
        this.textIndex = TextQueryPF.chooseTextIndex(dsg);
        if (argSubject.isList() && (size = argSubject.getArgListSize()) != 2 && size != 3) {
            throw new QueryBuildException("Subject has " + argSubject.getArgList().size() + " elements, not 2 or 3: " + argSubject);
        }
        if (argObject.isList()) {
            List list = argObject.getArgList();
            if (list.size() == 0) {
                throw new QueryBuildException("Zero-length argument list");
            }
            if (list.size() > 4) {
                throw new QueryBuildException("Too many arguments in list : " + list);
            }
            this.langArg = this.extractArg("lang", list);
            if (this.langArg != null && this.textIndex.getDocDef().getLangField() == null) {
                log.warn("lang argument is ignored if langField not set in the index configuration");
            }
        }
    }

    private static TextIndex chooseTextIndex(DatasetGraph dsg) {
        Context c = dsg.getContext();
        Object obj = dsg.getContext().get(TextQuery.textIndex);
        if (obj != null) {
            try {
                return (TextIndex)obj;
            }
            catch (ClassCastException ex) {
                log.warn("Context setting '" + TextQuery.textIndex + "'is not a TextIndex");
            }
        }
        if (dsg instanceof DatasetGraphText) {
            DatasetGraphText x = (DatasetGraphText)dsg;
            return x.getTextIndex();
        }
        log.warn("Failed to find the text index : tried context and as a text-enabled dataset");
        return null;
    }

    private String extractArg(String prefix, List<Node> objArgs) {
        String value = null;
        int pos = 0;
        for (Node node : objArgs) {
            String arg;
            if (node.isLiteral() && (arg = node.getLiteral().toString()).startsWith(prefix + ":")) {
                value = arg.split(":")[1];
                break;
            }
            ++pos;
        }
        if (value != null) {
            objArgs.remove(pos);
        }
        return value;
    }

    public QueryIterator exec(QueryIterator input, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt) {
        if (this.textIndex == null) {
            if (!this.warningIssued) {
                log.warn("No text index - no text search performed");
                this.warningIssued = true;
            }
            return input;
        }
        LinkedHashMap<String, TextHit> textResults = null;
        StrMatch match = this.objectToStruct(argObject, execCxt, false);
        if (null != match) {
            List<TextHit> hits = this.query(match.getProperty(), match.getQueryString(), match.getLimit(), execCxt);
            textResults = new LinkedHashMap<String, TextHit>();
            for (TextHit hit : hits) {
                textResults.putIfAbsent(hit.getNode().getURI(), hit);
            }
        }
        return new RepeatApplyIteratorTextQuery(input, argSubject, predicate, argObject, execCxt, textResults);
    }

    private QueryIterator exec(Binding binding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt, Map<String, TextHit> textResults) {
        QueryIterator qIter;
        DatasetGraph dsg = execCxt.getDataset();
        argSubject = Substitute.substitute((PropFuncArg)argSubject, (Binding)binding);
        argObject = Substitute.substitute((PropFuncArg)argObject, (Binding)binding);
        Node s = null;
        Node score = null;
        Node literal = null;
        if (argSubject.isList()) {
            s = argSubject.getArg(0);
            score = argSubject.getArg(1);
            if (!score.isVariable()) {
                throw new QueryExecException("Hit score is not a variable: " + argSubject);
            }
            if (argSubject.getArgListSize() > 2 && !(literal = argSubject.getArg(2)).isVariable()) {
                throw new QueryExecException("Hit literal is not a variable: " + argSubject);
            }
        } else {
            s = argSubject.getArg();
        }
        if (s.isLiteral()) {
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        StrMatch match = this.objectToStruct(argObject, execCxt, true);
        if (match == null) {
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        QueryIterator queryIterator = qIter = Var.isVar((Node)s) ? this.variableSubject(binding, s, score, literal, match, execCxt, textResults) : this.concreteSubject(binding, s, score, literal, match, execCxt, textResults);
        if (match.getLimit() >= 0) {
            qIter = new QueryIterSlice(qIter, 0L, (long)match.getLimit(), execCxt);
        }
        return qIter;
    }

    private QueryIterator variableSubject(Binding binding, Node s, Node score, Node literal, StrMatch match, ExecutionContext execCxt, Map<String, TextHit> textResults) {
        Var sVar = Var.alloc((Node)s);
        Var scoreVar = score == null ? null : Var.alloc((Node)score);
        Var literalVar = literal == null ? null : Var.alloc((Node)literal);
        Collection<TextHit> r = null != textResults ? textResults.values() : this.query(match.getProperty(), match.getQueryString(), match.getLimit(), execCxt);
        TextHitConverter converter = new TextHitConverter(binding, sVar, scoreVar, literalVar);
        Iterator bIter = Iter.map(r.iterator(), (Function)converter);
        QueryIterPlainWrapper qIter = new QueryIterPlainWrapper(bIter, execCxt);
        return qIter;
    }

    private QueryIterator concreteSubject(Binding binding, Node s, Node score, Node literal, StrMatch match, ExecutionContext execCxt, Map<String, TextHit> textResults) {
        Var literalVar;
        if (!s.isURI()) {
            log.warn("Subject not a URI: " + s);
            return IterLib.noResults((ExecutionContext)execCxt);
        }
        Var scoreVar = score == null ? null : Var.alloc((Node)score);
        Var var = literalVar = literal == null ? null : Var.alloc((Node)literal);
        if (null != textResults) {
            TextHit hit = textResults.get(s.getURI());
            if (null != hit) {
                if (literalVar == null) {
                    return scoreVar == null ? IterLib.result((Binding)binding, (ExecutionContext)execCxt) : IterLib.oneResult((Binding)binding, (Var)scoreVar, (Node)NodeFactoryExtra.floatToNode((float)hit.getScore()), (ExecutionContext)execCxt);
                }
                BindingMap bmap = BindingFactory.create((Binding)binding);
                if (scoreVar != null) {
                    bmap.add(scoreVar, NodeFactoryExtra.floatToNode((float)hit.getScore()));
                }
                bmap.add(literalVar, hit.getLiteral());
                return IterLib.result((Binding)bmap, (ExecutionContext)execCxt);
            }
        } else {
            if (scoreVar == null) {
                String queryString = this.textIndex.getDocDef().getEntityField() + ":" + QueryParserUtil.escape((String)s.getURI()) + " AND (" + match.getQueryString() + ")";
                List<TextHit> x = this.query(match.getProperty(), queryString, -1, execCxt);
                if (x == null || x.size() == 0) {
                    return IterLib.noResults((ExecutionContext)execCxt);
                }
                TextHit hit = x.get(0);
                return literalVar == null ? IterLib.result((Binding)binding, (ExecutionContext)execCxt) : IterLib.oneResult((Binding)binding, (Var)literalVar, (Node)hit.getLiteral(), (ExecutionContext)execCxt);
            }
            List<TextHit> x = this.query(match.getProperty(), match.getQueryString(), -1, execCxt);
            if (x == null) {
                return IterLib.noResults((ExecutionContext)execCxt);
            }
            for (TextHit hit : x) {
                if (!hit.getNode().equals((Object)s)) continue;
                if (literalVar == null) {
                    return IterLib.oneResult((Binding)binding, (Var)scoreVar, (Node)NodeFactoryExtra.floatToNode((float)hit.getScore()), (ExecutionContext)execCxt);
                }
                BindingMap bmap = BindingFactory.create((Binding)binding);
                bmap.add(scoreVar, NodeFactoryExtra.floatToNode((float)hit.getScore()));
                bmap.add(literalVar, hit.getLiteral());
                return IterLib.result((Binding)bmap, (ExecutionContext)execCxt);
            }
        }
        return IterLib.noResults((ExecutionContext)execCxt);
    }

    private List<TextHit> query(Node property, String queryString, int limit, ExecutionContext execCxt) {
        Explain.explain((Context)execCxt.getContext(), (String)("Text query: " + queryString));
        if (log.isDebugEnabled()) {
            log.debug("Text query: {} ({})", (Object)queryString, (Object)limit);
        }
        return this.textIndex.query(property, queryString, limit);
    }

    private String buildQueryString(String queryString, ExecutionContext execCxt) {
        GraphView activeGraph;
        if (this.textIndex.getDocDef().getGraphField() != null && execCxt.getActiveGraph() instanceof GraphView && !Quad.isUnionGraph((Node)(activeGraph = (GraphView)execCxt.getActiveGraph()).getGraphName())) {
            String uri = activeGraph.getGraphName() != null ? TextQueryFuncs.graphNodeToString(activeGraph.getGraphName()) : Quad.defaultGraphNodeGenerated.getURI();
            String escaped = QueryParserUtil.escape((String)uri);
            String qs2 = this.textIndex.getDocDef().getGraphField() + ":" + escaped;
            queryString = "(" + queryString + ") AND " + qs2;
        }
        if (this.textIndex.getDocDef().getLangField() != null) {
            String field = this.textIndex.getDocDef().getLangField();
            if (this.langArg != null) {
                String qs2 = !"none".equals(this.langArg) ? field + ":" + this.langArg : "-" + field + ":*";
                queryString = "(" + queryString + ") AND " + qs2;
            }
        }
        return queryString;
    }

    private StrMatch objectToStruct(PropFuncArg argObject, ExecutionContext execCxt, boolean executionTime) {
        EntityDefinition docDef = this.textIndex.getDocDef();
        if (argObject.isNode()) {
            Node o = argObject.getArg();
            if (!o.isLiteral()) {
                if (executionTime) {
                    log.warn("Object to text query is not a literal");
                }
                return null;
            }
            RDFDatatype dt = o.getLiteralDatatype();
            if (dt != null && dt != XSDDatatype.XSDstring) {
                log.warn("Object to text query is not a string");
                return null;
            }
            String qs = o.getLiteralLexicalForm();
            qs = this.buildQueryString(qs, execCxt);
            return new StrMatch(null, qs, -1, 0.0f);
        }
        List list = argObject.getArgList();
        if (list.size() == 0 || list.size() > 3) {
            throw new TextIndexException("Change in object list size");
        }
        Node predicate = null;
        String field = null;
        int idx = 0;
        Node x = (Node)list.get(0);
        if (x.isURI()) {
            predicate = x;
            if (++idx >= list.size()) {
                throw new TextIndexException("Property specificed but no query string : " + list);
            }
            x = (Node)list.get(idx);
            field = docDef.getField(predicate);
            if (field == null) {
                log.warn("Predicate not indexed: " + predicate);
                return null;
            }
        }
        if (!x.isLiteral()) {
            if (executionTime) {
                log.warn("Text query string is not a literal " + list);
            }
            return null;
        }
        if (x.getLiteralDatatype() != null && !x.getLiteralDatatype().equals(XSDDatatype.XSDstring)) {
            log.warn("Text query is not a string " + list);
            return null;
        }
        String queryString = x.getLiteralLexicalForm();
        int limit = -1;
        float score = 0.0f;
        if (++idx < list.size()) {
            x = (Node)list.get(idx);
            ++idx;
            if (!x.isLiteral()) {
                if (executionTime) {
                    log.warn("Text query limit is not an integer " + x);
                }
                return null;
            }
            int v = NodeFactoryExtra.nodeToInt((Node)x);
            limit = v < 0 ? -1 : v;
        }
        String qs = queryString;
        if (field != null) {
            qs = field + ":" + qs;
        }
        qs = this.buildQueryString(qs, execCxt);
        return new StrMatch(predicate, qs, limit, score);
    }

    static class StrMatch {
        private final Node property;
        private final String queryString;
        private final int limit;
        private final float scoreLimit;

        public StrMatch(Node property, String queryString, int limit, float scoreLimit) {
            this.property = property;
            this.queryString = queryString;
            this.limit = limit;
            this.scoreLimit = scoreLimit;
        }

        public Node getProperty() {
            return this.property;
        }

        public String getQueryString() {
            return this.queryString;
        }

        public int getLimit() {
            return this.limit;
        }

        public float getScoreLimit() {
            return this.scoreLimit;
        }
    }

    class RepeatApplyIteratorTextQuery
    extends QueryIterRepeatApply {
        private final PropFuncArg argSubject;
        private final Node predicate;
        private final PropFuncArg argObject;
        private Map<String, TextHit> textResults;

        public RepeatApplyIteratorTextQuery(QueryIterator input, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext execCxt, Map<String, TextHit> textResults) {
            super(input, execCxt);
            this.argSubject = argSubject;
            this.predicate = predicate;
            this.argObject = argObject;
            this.textResults = textResults;
        }

        protected QueryIterator nextStage(Binding binding) {
            QueryIterator iter = TextQueryPF.this.exec(binding, this.argSubject, this.predicate, this.argObject, this.getExecContext(), this.textResults);
            if (iter == null) {
                iter = IterLib.noResults((ExecutionContext)this.getExecContext());
            }
            return iter;
        }

        protected void details(IndentedWriter out, SerializationContext sCxt) {
            out.print("PropertyFunction [" + FmtUtils.stringForNode((Node)this.predicate, (SerializationContext)sCxt) + "]");
            out.print("[");
            this.argSubject.output(out, sCxt);
            out.print("][");
            this.argObject.output(out, sCxt);
            out.print("]");
            out.println();
        }
    }
}

