/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.analyzer;

import java.io.Reader;
import java.util.List;
import org.apache.jena.query.text.TextIndexException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.LetterTokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

public class ConfigurableAnalyzer
extends Analyzer {
    private final Version version;
    private final String tokenizer;
    private final List<String> filters;

    private Tokenizer getTokenizer(String tokenizerName, Reader reader) {
        switch (tokenizerName) {
            case "KeywordTokenizer": {
                return new KeywordTokenizer(reader);
            }
            case "LetterTokenizer": {
                return new LetterTokenizer(this.version, reader);
            }
            case "StandardTokenizer": {
                return new StandardTokenizer(this.version, reader);
            }
            case "WhitespaceTokenizer": {
                return new WhitespaceTokenizer(this.version, reader);
            }
        }
        throw new TextIndexException("Unknown tokenizer : " + tokenizerName);
    }

    private TokenFilter getTokenFilter(String filterName, TokenStream source) {
        switch (filterName) {
            case "ASCIIFoldingFilter": {
                return new ASCIIFoldingFilter(source);
            }
            case "LowerCaseFilter": {
                return new LowerCaseFilter(this.version, source);
            }
            case "StandardFilter": {
                return new StandardFilter(this.version, source);
            }
        }
        throw new TextIndexException("Unknown filter : " + filterName);
    }

    public ConfigurableAnalyzer(Version ver, String tokenizer, List<String> filters) {
        this.version = ver;
        this.tokenizer = tokenizer;
        this.filters = filters;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        Tokenizer source;
        Tokenizer stream = source = this.getTokenizer(this.tokenizer, reader);
        for (String filter : this.filters) {
            stream = this.getTokenFilter(filter, (TokenStream)stream);
        }
        return new Analyzer.TokenStreamComponents(source, (TokenStream)stream);
    }
}

