/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.query.text.EntityDefinition;
import org.apache.jena.query.text.TextDatasetFactory;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.TextIndexException;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.util.graph.GraphUtils;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;

public class TextIndexSolrAssembler
extends AssemblerBase {
    public TextIndex open(Assembler a, Resource root, Mode mode) {
        String uri = GraphUtils.getResourceValue((Resource)root, (Property)TextVocab.pServer).getURI();
        if (uri.startsWith("embedded:")) {
            throw new TextIndexException("Embedded Solr server not supported (change code and dependencies to enable)");
        }
        if (!uri.startsWith("http://")) {
            throw new TextIndexException("URI for the server must begin 'http://'");
        }
        HttpSolrServer server = new HttpSolrServer(uri);
        Resource r = GraphUtils.getResourceValue((Resource)root, (Property)TextVocab.pEntityMap);
        EntityDefinition docDef = (EntityDefinition)a.open(r);
        return TextDatasetFactory.createSolrIndex((SolrServer)server, docDef);
    }
}

