/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.jmeter.extractor.RegexExtractorSchema;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.schema.BaseTestElementSchema;
import org.apache.jmeter.testelement.schema.PropertiesAccessor;
import org.apache.jmeter.testelement.schema.PropertyDescriptor;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.Document;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexExtractor
extends AbstractScopedTestElement
implements PostProcessor,
Serializable {
    private static final long serialVersionUID = 242L;
    private static final Logger log = LoggerFactory.getLogger(RegexExtractor.class);
    public static final String USE_HDRS = "true";
    public static final String USE_REQUEST_HDRS = "request_headers";
    public static final String USE_BODY = "false";
    public static final String USE_BODY_UNESCAPED = "unescaped";
    public static final String USE_BODY_AS_DOCUMENT = "as_document";
    public static final String USE_URL = "URL";
    public static final String USE_CODE = "code";
    public static final String USE_MESSAGE = "message";
    private static final String REF_MATCH_NR = "_matchNr";
    private static final String UNDERSCORE = "_";
    private static final boolean USE_JAVA_REGEX = !JMeterUtils.getPropDefault((String)"jmeter.regex.engine", (String)"oro").equalsIgnoreCase("oro");
    private transient List<Object> template;

    public RegexExtractorSchema getSchema() {
        return RegexExtractorSchema.INSTANCE;
    }

    public PropertiesAccessor<? extends RegexExtractor, ? extends RegexExtractorSchema> getProps() {
        return new PropertiesAccessor((TestElement)this, (BaseTestElementSchema)this.getSchema());
    }

    public void process() {
        this.initTemplate();
        JMeterContext context = this.getThreadContext();
        SampleResult previousResult = context.getPreviousResult();
        if (previousResult == null) {
            return;
        }
        log.debug("RegexExtractor processing result");
        JMeterVariables vars = context.getVariables();
        String refName = this.getRefName();
        int matchNumber = this.getMatchNumber();
        String defaultValue = this.getDefaultValue();
        if (!defaultValue.isEmpty() || this.isEmptyDefaultValue()) {
            vars.put(refName, defaultValue);
        }
        if (USE_JAVA_REGEX) {
            this.extractWithJavaRegex(previousResult, vars, refName, matchNumber);
        } else {
            this.extractWithOroRegex(previousResult, vars, refName, matchNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractWithOroRegex(SampleResult previousResult, JMeterVariables vars, String refName, int matchNumber) {
        Perl5Matcher matcher = JMeterUtils.getMatcher();
        String regex = this.getRegex();
        org.apache.oro.text.regex.Pattern pattern = null;
        try {
            pattern = JMeterUtils.getPatternCache().getPattern(regex, 32768);
            List<MatchResult> matches = this.processMatches(pattern, regex, previousResult, matchNumber, vars);
            int prevCount = 0;
            String prevString = vars.get(refName + REF_MATCH_NR);
            if (prevString != null) {
                vars.remove(refName + REF_MATCH_NR);
                try {
                    prevCount = Integer.parseInt(prevString);
                }
                catch (NumberFormatException nfe) {
                    log.warn("Could not parse number: '{}'", (Object)prevString);
                }
            }
            int matchCount = 0;
            try {
                String refName_n;
                int i;
                MatchResult match;
                if (matchNumber >= 0) {
                    match = RegexExtractor.getCorrectMatch(matches, matchNumber);
                    if (match != null) {
                        vars.put(refName, this.generateResult(match));
                        RegexExtractor.saveGroups(vars, refName, match);
                    } else {
                        RegexExtractor.removeGroups(vars, refName);
                    }
                } else {
                    RegexExtractor.removeGroups(vars, refName);
                    matchCount = matches.size();
                    vars.put(refName + REF_MATCH_NR, Integer.toString(matchCount));
                    for (i = 1; i <= matchCount; ++i) {
                        match = RegexExtractor.getCorrectMatch(matches, i);
                        if (match == null) continue;
                        refName_n = refName + UNDERSCORE + i;
                        vars.put(refName_n, this.generateResult(match));
                        RegexExtractor.saveGroups(vars, refName_n, match);
                    }
                }
                for (i = matchCount + 1; i <= prevCount; ++i) {
                    refName_n = refName + UNDERSCORE + i;
                    vars.remove(refName_n);
                    RegexExtractor.removeGroups(vars, refName_n);
                }
            }
            catch (RuntimeException e) {
                log.warn("Error while generating result");
            }
        }
        catch (MalformedCachePatternException e) {
            log.error("Error in pattern: '{}'", (Object)regex);
        }
        finally {
            JMeterUtils.clearMatcherMemory((Perl5Matcher)matcher, (org.apache.oro.text.regex.Pattern)pattern);
        }
    }

    private void extractWithJavaRegex(SampleResult previousResult, JMeterVariables vars, String refName, int matchNumber) {
        String regex = this.getRegex();
        Pattern pattern = null;
        try {
            pattern = JMeterUtils.compilePattern((String)regex);
            List<java.util.regex.MatchResult> matches = this.processMatches(pattern, previousResult, matchNumber, vars);
            int prevCount = 0;
            String prevString = vars.get(refName + REF_MATCH_NR);
            if (prevString != null) {
                vars.remove(refName + REF_MATCH_NR);
                try {
                    prevCount = Integer.parseInt(prevString);
                }
                catch (NumberFormatException nfe) {
                    log.warn("Could not parse number: '{}'", (Object)prevString);
                }
            }
            int matchCount = 0;
            try {
                String refName_n;
                int i;
                java.util.regex.MatchResult match;
                if (matchNumber >= 0) {
                    match = RegexExtractor.getCorrectMatchJavaRegex(matches, matchNumber);
                    if (match != null) {
                        vars.put(refName, this.generateResult(match));
                        RegexExtractor.saveGroups(vars, refName, match);
                    } else {
                        RegexExtractor.removeGroups(vars, refName);
                    }
                } else {
                    RegexExtractor.removeGroups(vars, refName);
                    matchCount = matches.size();
                    vars.put(refName + REF_MATCH_NR, Integer.toString(matchCount));
                    for (i = 1; i <= matchCount; ++i) {
                        match = RegexExtractor.getCorrectMatchJavaRegex(matches, i);
                        if (match == null) continue;
                        refName_n = refName + UNDERSCORE + i;
                        vars.put(refName_n, this.generateResult(match));
                        RegexExtractor.saveGroups(vars, refName_n, match);
                    }
                }
                for (i = matchCount + 1; i <= prevCount; ++i) {
                    refName_n = refName + UNDERSCORE + i;
                    vars.remove(refName_n);
                    RegexExtractor.removeGroups(vars, refName_n);
                }
            }
            catch (RuntimeException e) {
                log.warn("Error while generating result");
            }
        }
        catch (PatternSyntaxException e) {
            log.error("Error in pattern: '{}'", (Object)regex);
        }
    }

    private String getInputString(SampleResult result) {
        String inputString = this.useUrl() ? result.getUrlAsString() : (this.useHeaders() ? result.getResponseHeaders() : (this.useRequestHeaders() ? result.getRequestHeaders() : (this.useCode() ? result.getResponseCode() : (this.useMessage() ? result.getResponseMessage() : (this.useUnescapedBody() ? StringEscapeUtils.unescapeHtml4((String)result.getResponseDataAsString()) : (this.useBodyAsDocument() ? Document.getTextFromDocument((byte[])result.getResponseData()) : result.getResponseDataAsString()))))));
        log.debug("Input = '{}'", (Object)inputString);
        return inputString;
    }

    private List<MatchResult> processMatches(org.apache.oro.text.regex.Pattern pattern, String regex, SampleResult result, int matchNumber, JMeterVariables vars) {
        log.debug("Regex = '{}'", (Object)regex);
        Perl5Matcher matcher = JMeterUtils.getMatcher();
        ArrayList matches = new ArrayList();
        int found = 0;
        if (this.isScopeVariable()) {
            String inputString = vars.get(this.getVariableName());
            if (inputString == null) {
                if (log.isWarnEnabled()) {
                    log.warn("No variable '{}' found to process by RegexExtractor '{}', skipping processing", (Object)this.getVariableName(), (Object)this.getName());
                }
                return Collections.emptyList();
            }
            RegexExtractor.matchStrings(matchNumber, matcher, pattern, matches, found, inputString);
        } else {
            List sampleList = this.getSampleList(result);
            for (SampleResult sr : sampleList) {
                String inputString = this.getInputString(sr);
                found = RegexExtractor.matchStrings(matchNumber, matcher, pattern, matches, found, inputString);
                if (matchNumber <= 0 || found != matchNumber) continue;
                break;
            }
        }
        return Collections.unmodifiableList(matches);
    }

    private List<java.util.regex.MatchResult> processMatches(Pattern pattern, SampleResult result, int matchNumber, JMeterVariables vars) {
        log.debug("Regex = '{}'", (Object)pattern.pattern());
        ArrayList matches = new ArrayList();
        int found = 0;
        if (this.isScopeVariable()) {
            String inputString = vars.get(this.getVariableName());
            if (inputString == null) {
                if (log.isWarnEnabled()) {
                    log.warn("No variable '{}' found to process by RegexExtractor '{}', skipping processing", (Object)this.getVariableName(), (Object)this.getName());
                }
                return Collections.emptyList();
            }
            RegexExtractor.matchStrings(matchNumber, pattern, matches, found, inputString);
        } else {
            List sampleList = this.getSampleList(result);
            for (SampleResult sr : sampleList) {
                String inputString = this.getInputString(sr);
                found = RegexExtractor.matchStrings(matchNumber, pattern, matches, found, inputString);
                if (matchNumber <= 0 || found != matchNumber) continue;
                break;
            }
        }
        return Collections.unmodifiableList(matches);
    }

    private static int matchStrings(int matchNumber, Perl5Matcher matcher, org.apache.oro.text.regex.Pattern pattern, List<? super MatchResult> matches, int found, String inputString) {
        PatternMatcherInput input = new PatternMatcherInput(inputString);
        while ((matchNumber <= 0 || found != matchNumber) && matcher.contains(input, pattern)) {
            log.debug("RegexExtractor: Match found!");
            matches.add((MatchResult)matcher.getMatch());
            ++found;
        }
        return found;
    }

    private static int matchStrings(int matchNumber, Pattern pattern, List<? super java.util.regex.MatchResult> matches, int found, String inputString) {
        Matcher matcher = pattern.matcher(inputString);
        while ((matchNumber <= 0 || found != matchNumber) && matcher.find()) {
            log.debug("RegexExtractor: Match found!");
            matches.add(matcher.toMatchResult());
            ++found;
        }
        return found;
    }

    private static void saveGroups(JMeterVariables vars, String basename, MatchResult match) {
        StringBuilder buf = new StringBuilder();
        buf.append(basename);
        buf.append("_g");
        int pfxlen = buf.length();
        String prevString = vars.get(buf.toString());
        int previous = 0;
        if (prevString != null) {
            try {
                previous = Integer.parseInt(prevString);
            }
            catch (NumberFormatException nfe) {
                log.warn("Could not parse number: '{}'.", (Object)prevString);
            }
        }
        int groups = match.groups();
        for (int x = 0; x < groups; ++x) {
            buf.append(x);
            vars.put(buf.toString(), match.group(x));
            buf.setLength(pfxlen);
        }
        vars.put(buf.toString(), Integer.toString(groups - 1));
        for (int i = groups; i <= previous; ++i) {
            buf.append(i);
            vars.remove(buf.toString());
            buf.setLength(pfxlen);
        }
    }

    private static void saveGroups(JMeterVariables vars, String basename, java.util.regex.MatchResult match) {
        StringBuilder buf = new StringBuilder();
        buf.append(basename);
        buf.append("_g");
        int pfxlen = buf.length();
        String prevString = vars.get(buf.toString());
        int previous = 0;
        if (prevString != null) {
            try {
                previous = Integer.parseInt(prevString);
            }
            catch (NumberFormatException nfe) {
                log.warn("Could not parse number: '{}'.", (Object)prevString);
            }
        }
        int groups = match.groupCount() + 1;
        for (int x = 0; x < groups; ++x) {
            buf.append(x);
            vars.put(buf.toString(), match.group(x));
            buf.setLength(pfxlen);
        }
        vars.put(buf.toString(), Integer.toString(groups - 1));
        for (int i = groups; i <= previous; ++i) {
            buf.append(i);
            vars.remove(buf.toString());
            buf.setLength(pfxlen);
        }
    }

    private static void removeGroups(JMeterVariables vars, String basename) {
        int groups;
        StringBuilder buf = new StringBuilder();
        buf.append(basename);
        buf.append("_g");
        int pfxlen = buf.length();
        try {
            groups = Integer.parseInt(vars.get(buf.toString()));
        }
        catch (NumberFormatException e) {
            groups = 0;
        }
        vars.remove(buf.toString());
        for (int i = 0; i <= groups; ++i) {
            buf.append(i);
            vars.remove(buf.toString());
            buf.setLength(pfxlen);
        }
    }

    private String generateResult(MatchResult match) {
        StringBuilder result = new StringBuilder();
        for (Object obj : this.template) {
            if (log.isDebugEnabled()) {
                log.debug("RegexExtractor: Template piece {} ({})", obj, obj.getClass());
            }
            if (obj instanceof Integer) {
                result.append(match.group(((Integer)obj).intValue()));
                continue;
            }
            result.append(obj);
        }
        log.debug("Regex Extractor result = '{}'", (Object)result);
        return result.toString();
    }

    private String generateResult(java.util.regex.MatchResult match) {
        StringBuilder result = new StringBuilder();
        for (Object obj : this.template) {
            if (log.isDebugEnabled()) {
                log.debug("RegexExtractor: Template piece {} ({})", obj, obj.getClass());
            }
            if (obj instanceof Integer) {
                result.append(match.group((Integer)obj));
                continue;
            }
            result.append(obj);
        }
        log.debug("Regex Extractor result = '{}'", (Object)result);
        return result.toString();
    }

    private void initTemplate() {
        if (this.template != null) {
            return;
        }
        ArrayList<Object> combined = new ArrayList<Object>();
        String rawTemplate = this.getTemplate();
        Perl5Matcher matcher = JMeterUtils.getMatcher();
        org.apache.oro.text.regex.Pattern templatePattern = JMeterUtils.getPatternCache().getPattern("\\$(\\d+)\\$", 32784);
        if (log.isDebugEnabled()) {
            log.debug("Pattern = '{}', template = '{}'", (Object)templatePattern.getPattern(), (Object)rawTemplate);
        }
        int beginOffset = 0;
        PatternMatcherInput pinput = new PatternMatcherInput(rawTemplate);
        while (matcher.contains(pinput, templatePattern)) {
            MatchResult currentResult = matcher.getMatch();
            int beginMatch = currentResult.beginOffset(0);
            if (beginMatch > beginOffset) {
                combined.add(rawTemplate.substring(beginOffset, beginMatch));
            }
            combined.add(Integer.valueOf(currentResult.group(1)));
            beginOffset = currentResult.endOffset(0);
        }
        if (beginOffset < rawTemplate.length()) {
            combined.add(rawTemplate.substring(beginOffset));
        }
        if (log.isDebugEnabled()) {
            log.debug("Template item count: {}", (Object)combined.size());
            int i = 0;
            for (Object e : combined) {
                log.debug("Template item-{}: {} '{}'", new Object[]{i++, e.getClass(), e});
            }
        }
        this.template = combined;
    }

    private static MatchResult getCorrectMatch(List<? extends MatchResult> matches, int entry) {
        int matchSize = matches.size();
        if (matchSize <= 0 || entry > matchSize) {
            return null;
        }
        if (entry == 0) {
            return matches.get(JMeterUtils.getRandomInt((int)matchSize));
        }
        return matches.get(entry - 1);
    }

    private static java.util.regex.MatchResult getCorrectMatchJavaRegex(List<? extends java.util.regex.MatchResult> matches, int entry) {
        int matchSize = matches.size();
        if (matchSize <= 0 || entry > matchSize) {
            return null;
        }
        if (entry == 0) {
            return matches.get(JMeterUtils.getRandomInt((int)matchSize));
        }
        return matches.get(entry - 1);
    }

    public void setRegex(String regex) {
        this.set((PropertyDescriptor)this.getSchema().getRegularExpression(), regex);
    }

    public String getRegex() {
        return this.get(this.getSchema().getRegularExpression());
    }

    public void setRefName(String refName) {
        this.set((PropertyDescriptor)this.getSchema().getReferenceName(), refName);
    }

    public String getRefName() {
        return this.get(this.getSchema().getReferenceName());
    }

    public void setMatchNumber(int matchNumber) {
        this.set(this.getSchema().getMatchNumber(), matchNumber);
    }

    public void setMatchNumber(String matchNumber) {
        this.set((PropertyDescriptor)this.getSchema().getMatchNumber(), matchNumber);
    }

    public int getMatchNumber() {
        return this.get(this.getSchema().getMatchNumber());
    }

    public String getMatchNumberAsString() {
        return this.getString((PropertyDescriptor)this.getSchema().getMatchNumber());
    }

    public void setDefaultValue(String defaultValue) {
        this.set((PropertyDescriptor)this.getSchema().getDefault(), defaultValue);
    }

    public void setDefaultEmptyValue(boolean defaultEmptyValue) {
        this.set(this.getSchema().getDefaultIsEmpty(), defaultEmptyValue);
    }

    public String getDefaultValue() {
        return this.get(this.getSchema().getDefault());
    }

    public boolean isEmptyDefaultValue() {
        return this.get(this.getSchema().getDefaultIsEmpty());
    }

    public void setTemplate(String template) {
        this.set((PropertyDescriptor)this.getSchema().getTemplate(), template);
    }

    public String getTemplate() {
        return this.get(this.getSchema().getTemplate());
    }

    private String getMatchTarget() {
        return this.get(this.getSchema().getMatchTarget());
    }

    public boolean useHeaders() {
        return USE_HDRS.equalsIgnoreCase(this.getMatchTarget());
    }

    public boolean useRequestHeaders() {
        return USE_REQUEST_HDRS.equalsIgnoreCase(this.getMatchTarget());
    }

    public boolean useBody() {
        String prop = this.getMatchTarget();
        return prop.isEmpty() || USE_BODY.equalsIgnoreCase(prop);
    }

    public boolean useUnescapedBody() {
        String prop = this.getMatchTarget();
        return USE_BODY_UNESCAPED.equalsIgnoreCase(prop);
    }

    public boolean useBodyAsDocument() {
        String prop = this.getMatchTarget();
        return USE_BODY_AS_DOCUMENT.equalsIgnoreCase(prop);
    }

    public boolean useUrl() {
        String prop = this.getMatchTarget();
        return USE_URL.equalsIgnoreCase(prop);
    }

    public boolean useCode() {
        String prop = this.getMatchTarget();
        return USE_CODE.equalsIgnoreCase(prop);
    }

    public boolean useMessage() {
        String prop = this.getMatchTarget();
        return USE_MESSAGE.equalsIgnoreCase(prop);
    }

    public void setUseField(String actionCommand) {
        this.set((PropertyDescriptor)this.getSchema().getMatchTarget(), actionCommand);
    }
}

