/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui;

import java.util.Iterator;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.GuiUtils;
import org.apache.jorphan.gui.ObjectTableModel;
import org.apache.jorphan.reflect.Functor;

public class HTTPArgumentsPanel
extends ArgumentsPanel {
    private static final long serialVersionUID = 240L;
    private static final String ENCODE_OR_NOT = "encode?";
    private static final String INCLUDE_EQUALS = "include_equals";

    protected void initializeTableModel() {
        this.tableModel = new ObjectTableModel(new String[]{"name", "value", ENCODE_OR_NOT, INCLUDE_EQUALS}, HTTPArgument.class, new Functor[]{new Functor("getName"), new Functor("getValue"), new Functor("isAlwaysEncoded"), new Functor("isUseEquals")}, new Functor[]{new Functor("setName"), new Functor("setValue"), new Functor("setAlwaysEncoded"), new Functor("setUseEquals")}, new Class[]{String.class, String.class, Boolean.class, Boolean.class});
    }

    public static boolean testFunctors() {
        HTTPArgumentsPanel instance = new HTTPArgumentsPanel();
        instance.initializeTableModel();
        return instance.tableModel.checkFunctors(null, ((Object)((Object)instance)).getClass());
    }

    protected void sizeColumns(JTable table) {
        GuiUtils.fixSize((TableColumn)table.getColumn(INCLUDE_EQUALS), (JTable)table);
        GuiUtils.fixSize((TableColumn)table.getColumn(ENCODE_OR_NOT), (JTable)table);
    }

    protected HTTPArgument makeNewArgument() {
        HTTPArgument arg = new HTTPArgument("", "");
        arg.setAlwaysEncoded(false);
        arg.setUseEquals(true);
        return arg;
    }

    public HTTPArgumentsPanel() {
        super(JMeterUtils.getResString((String)"paramtable"));
    }

    public TestElement createTestElement() {
        Arguments args = this.getUnclonedParameters();
        this.configureTestElement((TestElement)args);
        return (TestElement)args.clone();
    }

    public Arguments getParameters() {
        Arguments args = this.getUnclonedParameters();
        return (Arguments)args.clone();
    }

    private Arguments getUnclonedParameters() {
        this.stopTableEditing();
        Iterator modelData = this.tableModel.iterator();
        Arguments args = new Arguments();
        while (modelData.hasNext()) {
            HTTPArgument arg = (HTTPArgument)modelData.next();
            args.addArgument((Argument)arg);
        }
        return args;
    }

    public void configure(TestElement el) {
        super.configure(el);
        if (el instanceof Arguments) {
            this.tableModel.clearData();
            HTTPArgument.convertArgumentsToHTTP((Arguments)el);
            PropertyIterator iter = ((Arguments)el).getArguments().iterator();
            while (iter.hasNext()) {
                HTTPArgument arg = (HTTPArgument)iter.next().getObjectValue();
                this.tableModel.addRow((Object)arg);
            }
        }
        this.checkDeleteStatus();
    }

    protected boolean isMetaDataNormal(HTTPArgument arg) {
        return arg.getMetaData() == null || arg.getMetaData().equals("=") || arg.getValue() != null && arg.getValue().length() > 0;
    }
}

