/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.http.parser.URLCollection;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerBase;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.apache.oro.text.PatternCacheLRU;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Matcher;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HtmlParsingUtils {
    private static final Logger log = LoggingManager.getLoggerForClass();

    private HtmlParsingUtils() {
    }

    public static boolean isAnchorMatched(HTTPSamplerBase newLink, HTTPSamplerBase config) {
        String query = null;
        try {
            query = URLDecoder.decode(newLink.getQueryString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("UTF-8 encoding not supported!");
            throw new Error("Should not happen: " + e.toString(), e);
        }
        Arguments arguments = config.getArguments();
        Perl5Matcher matcher = JMeterUtils.getMatcher();
        PatternCacheLRU patternCache = JMeterUtils.getPatternCache();
        if (!HtmlParsingUtils.isEqualOrMatches(newLink.getProtocol(), config.getProtocol(), matcher, patternCache)) {
            return false;
        }
        String domain = config.getDomain();
        if (domain != null && domain.length() > 0 && !HtmlParsingUtils.isEqualOrMatches(newLink.getDomain(), domain, matcher, patternCache)) {
            return false;
        }
        String path = config.getPath();
        if (!newLink.getPath().equals(path) && !matcher.matches(newLink.getPath(), patternCache.getPattern("[/]*" + path, 32768))) {
            return false;
        }
        PropertyIterator iter = arguments.iterator();
        while (iter.hasNext()) {
            Argument item = (Argument)iter.next().getObjectValue();
            String name = item.getName();
            if (query.indexOf(name + "=") != -1 || matcher.contains(query, patternCache.getPattern(name, 32768))) continue;
            return false;
        }
        return true;
    }

    public static boolean isArgumentMatched(Argument arg, Argument patternArg) {
        Perl5Matcher matcher = JMeterUtils.getMatcher();
        PatternCacheLRU patternCache = JMeterUtils.getPatternCache();
        return HtmlParsingUtils.isEqualOrMatches(arg.getName(), patternArg.getName(), matcher, patternCache) && HtmlParsingUtils.isEqualOrMatches(arg.getValue(), patternArg.getValue(), matcher, patternCache);
    }

    public static boolean isEqualOrMatches(String arg, String pat, Perl5Matcher matcher, PatternCacheLRU cache) {
        return arg.equals(pat) || matcher.matches(arg, cache.getPattern(pat, 32768));
    }

    public static boolean isEqualOrMatchesCaseBlind(String arg, String pat, Perl5Matcher matcher, PatternCacheLRU cache) {
        return arg.equalsIgnoreCase(pat) || matcher.matches(arg, cache.getPattern(pat, 32769));
    }

    public static boolean isEqualOrMatches(String arg, String pat) {
        return HtmlParsingUtils.isEqualOrMatches(arg, pat, JMeterUtils.getMatcher(), JMeterUtils.getPatternCache());
    }

    public static boolean isEqualOrMatchesCaseBlind(String arg, String pat) {
        return HtmlParsingUtils.isEqualOrMatchesCaseBlind(arg, pat, JMeterUtils.getMatcher(), JMeterUtils.getPatternCache());
    }

    public static Tidy getParser() {
        log.debug("Start : getParser1");
        Tidy tidy = new Tidy();
        tidy.setInputEncoding("UTF8");
        tidy.setOutputEncoding("UTF8");
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        if (log.isDebugEnabled()) {
            log.debug("getParser1 : tidy parser created - " + tidy);
        }
        log.debug("End : getParser1");
        return tidy;
    }

    public static Node getDOM(String text) {
        log.debug("Start : getDOM1");
        try {
            Document node = HtmlParsingUtils.getParser().parseDOM((InputStream)new ByteArrayInputStream(text.getBytes("UTF-8")), null);
            if (log.isDebugEnabled()) {
                log.debug("node : " + node);
            }
            log.debug("End : getDOM1");
            return node;
        }
        catch (UnsupportedEncodingException e) {
            log.error("getDOM1 : Unsupported encoding exception - " + e);
            log.debug("End : getDOM1");
            throw new RuntimeException("UTF-8 encoding failed", e);
        }
    }

    public static Document createEmptyDoc() {
        return Tidy.createEmptyDocument();
    }

    public static HTTPSamplerBase createUrlFromAnchor(String parsedUrlString, URL context) throws MalformedURLException {
        if (log.isDebugEnabled()) {
            log.debug("Creating URL from Anchor: " + parsedUrlString + ", base: " + context);
        }
        URL url = ConversionUtils.makeRelativeURL(context, parsedUrlString);
        HTTPSamplerBase sampler = HTTPSamplerFactory.newInstance();
        sampler.setDomain(url.getHost());
        sampler.setProtocol(url.getProtocol());
        sampler.setPort(url.getPort());
        sampler.setPath(url.getPath());
        sampler.parseArguments(url.getQuery());
        return sampler;
    }

    public static List<HTTPSamplerBase> createURLFromForm(Node doc, URL context) {
        String selectName = null;
        LinkedList<HTTPSamplerBase> urlConfigs = new LinkedList<HTTPSamplerBase>();
        HtmlParsingUtils.recurseForm(doc, urlConfigs, context, selectName, false);
        return urlConfigs;
    }

    private static boolean recurseForm(Node tempNode, LinkedList<HTTPSamplerBase> urlConfigs, URL context, String selectName, boolean inForm) {
        block18: {
            NamedNodeMap nodeAtts = tempNode.getAttributes();
            String tag = tempNode.getNodeName();
            try {
                if (inForm) {
                    HTTPSamplerBase url = urlConfigs.getLast();
                    if (tag.equalsIgnoreCase("form")) {
                        try {
                            urlConfigs.add(HtmlParsingUtils.createFormUrlConfig(tempNode, context));
                        }
                        catch (MalformedURLException e) {
                            inForm = false;
                        }
                        break block18;
                    }
                    if (tag.equalsIgnoreCase("input")) {
                        url.addEncodedArgument(HtmlParsingUtils.getAttributeValue(nodeAtts, "name"), HtmlParsingUtils.getAttributeValue(nodeAtts, "value"));
                        break block18;
                    }
                    if (tag.equalsIgnoreCase("textarea")) {
                        try {
                            url.addEncodedArgument(HtmlParsingUtils.getAttributeValue(nodeAtts, "name"), tempNode.getFirstChild().getNodeValue());
                        }
                        catch (NullPointerException e) {
                            url.addArgument(HtmlParsingUtils.getAttributeValue(nodeAtts, "name"), "");
                        }
                        break block18;
                    }
                    if (tag.equalsIgnoreCase("select")) {
                        selectName = HtmlParsingUtils.getAttributeValue(nodeAtts, "name");
                        break block18;
                    }
                    if (!tag.equalsIgnoreCase("option")) break block18;
                    String value = HtmlParsingUtils.getAttributeValue(nodeAtts, "value");
                    if (value == null) {
                        try {
                            value = tempNode.getFirstChild().getNodeValue();
                        }
                        catch (NullPointerException e) {
                            value = "";
                        }
                    }
                    url.addEncodedArgument(selectName, value);
                    break block18;
                }
                if (tag.equalsIgnoreCase("form")) {
                    try {
                        urlConfigs.add(HtmlParsingUtils.createFormUrlConfig(tempNode, context));
                        inForm = true;
                    }
                    catch (MalformedURLException e) {
                        inForm = false;
                    }
                }
            }
            catch (Exception ex) {
                log.warn("Some bad HTML " + HtmlParsingUtils.printNode(tempNode), (Throwable)ex);
            }
        }
        NodeList childNodes = tempNode.getChildNodes();
        for (int x = 0; x < childNodes.getLength(); ++x) {
            inForm = HtmlParsingUtils.recurseForm(childNodes.item(x), urlConfigs, context, selectName, inForm);
        }
        return inForm;
    }

    private static String getAttributeValue(NamedNodeMap att, String attName) {
        try {
            return att.getNamedItem(attName).getNodeValue();
        }
        catch (Exception ex) {
            return "";
        }
    }

    private static String printNode(Node node) {
        StringBuilder buf = new StringBuilder();
        buf.append("<");
        buf.append(node.getNodeName());
        NamedNodeMap atts = node.getAttributes();
        for (int x = 0; x < atts.getLength(); ++x) {
            buf.append(" ");
            buf.append(atts.item(x).getNodeName());
            buf.append("=\"");
            buf.append(atts.item(x).getNodeValue());
            buf.append("\"");
        }
        buf.append(">");
        return buf.toString();
    }

    private static HTTPSamplerBase createFormUrlConfig(Node tempNode, URL context) throws MalformedURLException {
        NamedNodeMap atts = tempNode.getAttributes();
        if (atts.getNamedItem("action") == null) {
            throw new MalformedURLException();
        }
        String action = atts.getNamedItem("action").getNodeValue();
        return HtmlParsingUtils.createUrlFromAnchor(action, context);
    }

    public static void extractStyleURLs(URL baseUrl, URLCollection urls, String styleTagStr) {
        Perl5Matcher matcher = JMeterUtils.getMatcher();
        Pattern pattern = JMeterUtils.getPatternCache().getPattern("URL\\(\\s*('|\")(.*)('|\")\\s*\\)", 32785);
        PatternMatcherInput input = null;
        input = new PatternMatcherInput(styleTagStr);
        while (matcher.contains(input, pattern)) {
            MatchResult match = matcher.getMatch();
            String styleUrl = match.group(2);
            urls.addURL(styleUrl, baseUrl);
        }
    }
}

