/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.CSVSaveService;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJDBCTestElement
extends AbstractTestElement
implements TestStateListener {
    private static final long serialVersionUID = 235L;
    private static final Logger log;
    private static final String COMMA = ",";
    private static final char COMMA_CHAR = ',';
    private static final String UNDERSCORE = "_";
    private static final String NULL_MARKER;
    private static final String INOUT = "INOUT";
    private static final String OUT = "OUT";
    protected static final String ENCODING;
    private static final Map<String, Integer> mapJdbcNameToInt;
    static final String SELECT = "Select Statement";
    static final String UPDATE = "Update Statement";
    static final String CALLABLE = "Callable Statement";
    static final String PREPARED_SELECT = "Prepared Select Statement";
    static final String PREPARED_UPDATE = "Prepared Update Statement";
    static final String COMMIT = "Commit";
    static final String ROLLBACK = "Rollback";
    static final String AUTOCOMMIT_FALSE = "AutoCommit(false)";
    static final String AUTOCOMMIT_TRUE = "AutoCommit(true)";
    static final String RS_STORE_AS_STRING = "Store as String";
    static final String RS_STORE_AS_OBJECT = "Store as Object";
    static final String RS_COUNT_RECORDS = "Count Records";
    private String query = "";
    private String dataSource = "";
    private String queryType = "Select Statement";
    private String queryArguments = "";
    private String queryArgumentsTypes = "";
    private String variableNames = "";
    private String resultSetHandler = "Store as String";
    private String resultVariable = "";
    private String queryTimeout = "";
    private static final int MAX_RETAIN_SIZE;

    protected AbstractJDBCTestElement() {
    }

    protected byte[] execute(Connection conn) throws SQLException, IOException, UnsupportedOperationException {
        return this.execute(conn, new SampleResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] execute(Connection conn, SampleResult sample) throws SQLException, IOException, UnsupportedOperationException {
        log.debug("executing jdbc:{}", (Object)this.getQuery());
        String currentQueryType = this.getQueryType();
        if (SELECT.equals(currentQueryType)) {
            Throwable throwable = null;
            try (Statement stmt = conn.createStatement();){
                byte[] byArray;
                stmt.setQueryTimeout(this.getIntegerQueryTimeout());
                ResultSet rs2 = null;
                try {
                    rs2 = stmt.executeQuery(this.getQuery());
                    sample.latencyEnd();
                    byArray = this.getStringFromResultSet(rs2).getBytes(ENCODING);
                }
                catch (Throwable throwable2) {
                    try {
                        AbstractJDBCTestElement.close(rs2);
                        throw throwable2;
                    }
                    catch (Throwable rs2) {
                        throwable = rs2;
                        throw rs2;
                    }
                }
                AbstractJDBCTestElement.close(rs2);
                return byArray;
            }
        }
        if (CALLABLE.equals(currentQueryType)) {
            try (CallableStatement cstmt = this.getCallableStatement(conn);){
                int[] out = this.setArguments(cstmt);
                boolean hasResultSet = cstmt.execute();
                sample.latencyEnd();
                String sb = this.resultSetsToString(cstmt, hasResultSet, out);
                byte[] byArray = sb.getBytes(ENCODING);
                return byArray;
            }
        }
        if (UPDATE.equals(currentQueryType)) {
            try (Statement stmt = conn.createStatement();){
                stmt.setQueryTimeout(this.getIntegerQueryTimeout());
                stmt.executeUpdate(this.getQuery());
                sample.latencyEnd();
                int updateCount = stmt.getUpdateCount();
                String results = updateCount + " updates";
                byte[] byArray = results.getBytes(ENCODING);
                return byArray;
            }
        }
        if (PREPARED_SELECT.equals(currentQueryType)) {
            Throwable throwable = null;
            try (PreparedStatement pstmt = this.getPreparedStatement(conn);){
                byte[] byArray;
                this.setArguments(pstmt);
                ResultSet rs3 = null;
                try {
                    rs3 = pstmt.executeQuery();
                    sample.latencyEnd();
                    byArray = this.getStringFromResultSet(rs3).getBytes(ENCODING);
                }
                catch (Throwable throwable3) {
                    try {
                        AbstractJDBCTestElement.close(rs3);
                        throw throwable3;
                    }
                    catch (Throwable rs3) {
                        throwable = rs3;
                        throw rs3;
                    }
                }
                AbstractJDBCTestElement.close(rs3);
                return byArray;
            }
        }
        if (PREPARED_UPDATE.equals(currentQueryType)) {
            try (PreparedStatement pstmt = this.getPreparedStatement(conn);){
                this.setArguments(pstmt);
                pstmt.executeUpdate();
                sample.latencyEnd();
                String sb = this.resultSetsToString(pstmt, false, null);
                byte[] byArray = sb.getBytes(ENCODING);
                return byArray;
            }
        }
        if (ROLLBACK.equals(currentQueryType)) {
            conn.rollback();
            sample.latencyEnd();
            return ROLLBACK.getBytes(ENCODING);
        }
        if (COMMIT.equals(currentQueryType)) {
            conn.commit();
            sample.latencyEnd();
            return COMMIT.getBytes(ENCODING);
        }
        if (AUTOCOMMIT_FALSE.equals(currentQueryType)) {
            conn.setAutoCommit(false);
            sample.latencyEnd();
            return AUTOCOMMIT_FALSE.getBytes(ENCODING);
        }
        if (AUTOCOMMIT_TRUE.equals(currentQueryType)) {
            conn.setAutoCommit(true);
            sample.latencyEnd();
            return AUTOCOMMIT_TRUE.getBytes(ENCODING);
        }
        throw new UnsupportedOperationException("Unexpected query type: " + currentQueryType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resultSetsToString(PreparedStatement pstmt, boolean result, int[] out) throws SQLException, UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        int updateCount = 0;
        boolean currentResult = result;
        if (!currentResult) {
            updateCount = pstmt.getUpdateCount();
        }
        do {
            if (currentResult) {
                ResultSet rs = null;
                try {
                    rs = pstmt.getResultSet();
                    sb.append(this.getStringFromResultSet(rs)).append("\n");
                }
                finally {
                    AbstractJDBCTestElement.close(rs);
                }
            } else {
                sb.append(updateCount).append(" updates.\n");
            }
            currentResult = pstmt.getMoreResults();
            if (currentResult) continue;
            updateCount = pstmt.getUpdateCount();
        } while (currentResult || updateCount != -1);
        if (out != null && pstmt instanceof CallableStatement) {
            ArrayList<Object> outputValues = new ArrayList<Object>();
            CallableStatement cs = (CallableStatement)pstmt;
            sb.append("Output variables by position:\n");
            for (int i = 0; i < out.length; ++i) {
                if (out[i] == 0) continue;
                Object o = cs.getObject(i + 1);
                outputValues.add(o);
                sb.append("[");
                sb.append(i + 1);
                sb.append("] ");
                sb.append(o);
                if (o instanceof ResultSet && RS_COUNT_RECORDS.equals(this.resultSetHandler)) {
                    sb.append(" ").append(AbstractJDBCTestElement.countRows((ResultSet)o)).append(" rows");
                }
                sb.append("\n");
            }
            String[] varnames = this.getVariableNames().split(COMMA);
            if (varnames.length > 0) {
                JMeterVariables jmvars = this.getThreadContext().getVariables();
                for (int i = 0; i < varnames.length && i < outputValues.size(); ++i) {
                    String name = varnames[i].trim();
                    if (name.length() <= 0) continue;
                    Object o = outputValues.get(i);
                    if (o instanceof ResultSet) {
                        this.putIntoVar(jmvars, name, (ResultSet)o);
                        continue;
                    }
                    if (o instanceof Clob) {
                        this.putIntoVar(jmvars, name, (Clob)o);
                        continue;
                    }
                    if (o instanceof Blob) {
                        this.putIntoVar(jmvars, name, (Blob)o);
                        continue;
                    }
                    jmvars.put(name, o == null ? null : o.toString());
                }
            }
        }
        return sb.toString();
    }

    private void putIntoVar(JMeterVariables jmvars, String name, ResultSet resultSet) throws SQLException {
        if (RS_STORE_AS_OBJECT.equals(this.resultSetHandler)) {
            jmvars.putObject(name, (Object)resultSet);
        } else if (RS_COUNT_RECORDS.equals(this.resultSetHandler)) {
            jmvars.put(name, resultSet.toString() + " " + AbstractJDBCTestElement.countRows(resultSet) + " rows");
        } else {
            jmvars.put(name, resultSet.toString());
        }
    }

    private void putIntoVar(JMeterVariables jmvars, String name, Clob clob) throws SQLException {
        block27: {
            try {
                if (clob.length() > (long)MAX_RETAIN_SIZE) {
                    try (Reader reader = clob.getCharacterStream(0L, MAX_RETAIN_SIZE);){
                        jmvars.put(name, IOUtils.toString((Reader)reader) + "<result cut off, it is too big>");
                        break block27;
                    }
                }
                try (Reader reader = clob.getCharacterStream();){
                    jmvars.put(name, IOUtils.toString((Reader)reader));
                }
            }
            catch (IOException e) {
                log.warn("Could not read CLOB into {}", (Object)name, (Object)e);
            }
        }
    }

    private void putIntoVar(JMeterVariables jmvars, String name, Blob blob) throws SQLException {
        if (RS_STORE_AS_OBJECT.equals(this.resultSetHandler)) {
            try {
                long length = Math.max(blob.length(), (long)MAX_RETAIN_SIZE);
                jmvars.putObject(name, (Object)IOUtils.toByteArray((InputStream)blob.getBinaryStream(0L, length)));
            }
            catch (IOException e) {
                log.warn("Could not read BLOB into {} as object.", (Object)name, (Object)e);
            }
        } else if (RS_COUNT_RECORDS.equals(this.resultSetHandler)) {
            jmvars.put(name, blob.length() + " bytes");
        } else {
            try {
                long length = Math.max(blob.length(), (long)MAX_RETAIN_SIZE);
                try (InputStream is = blob.getBinaryStream(0L, length);){
                    jmvars.put(name, IOUtils.toString((InputStream)is, (String)ENCODING));
                }
            }
            catch (IOException e) {
                log.warn("Can't convert BLOB to String using {}", (Object)ENCODING, (Object)e);
            }
        }
    }

    private static int countRows(ResultSet resultSet) throws SQLException {
        return resultSet.last() ? resultSet.getRow() : 0;
    }

    private int[] setArguments(PreparedStatement pstmt) throws SQLException, IOException {
        String[] argumentsTypes;
        if (this.getQueryArguments().trim().length() == 0) {
            return new int[0];
        }
        String[] arguments = CSVSaveService.csvSplitString((String)this.getQueryArguments(), (char)',');
        if (arguments.length != (argumentsTypes = this.getQueryArgumentsTypes().split(COMMA)).length) {
            throw new SQLException("number of arguments (" + arguments.length + ") and number of types (" + argumentsTypes.length + ") are not equal");
        }
        int[] outputs = new int[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            String argument = arguments[i];
            String argumentType = argumentsTypes[i];
            String[] arg = argumentType.split(" ");
            String inputOutput = "";
            if (arg.length > 1) {
                argumentType = arg[1];
                inputOutput = arg[0];
            }
            int targetSqlType = AbstractJDBCTestElement.getJdbcType(argumentType);
            try {
                if (!OUT.equalsIgnoreCase(inputOutput)) {
                    if (argument.equals(NULL_MARKER)) {
                        pstmt.setNull(i + 1, targetSqlType);
                    } else {
                        this.setArgument(pstmt, argument, targetSqlType, i + 1);
                    }
                }
                if (OUT.equalsIgnoreCase(inputOutput) || INOUT.equalsIgnoreCase(inputOutput)) {
                    CallableStatement cs = (CallableStatement)pstmt;
                    cs.registerOutParameter(i + 1, targetSqlType);
                    outputs[i] = targetSqlType;
                    continue;
                }
                outputs[i] = 0;
                continue;
            }
            catch (NullPointerException e) {
                throw new SQLException("Could not set argument no: " + (i + 1) + " - missing parameter marker?", e);
            }
        }
        return outputs;
    }

    private void setArgument(PreparedStatement pstmt, String argument, int targetSqlType, int index) throws SQLException {
        switch (targetSqlType) {
            case 4: {
                pstmt.setInt(index, Integer.parseInt(argument));
                break;
            }
            case 2: 
            case 3: {
                pstmt.setBigDecimal(index, new BigDecimal(argument));
                break;
            }
            case 6: 
            case 8: {
                pstmt.setDouble(index, Double.parseDouble(argument));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                pstmt.setString(index, argument);
                break;
            }
            case -7: 
            case 16: {
                pstmt.setBoolean(index, Boolean.parseBoolean(argument));
                break;
            }
            case -5: {
                pstmt.setLong(index, Long.parseLong(argument));
                break;
            }
            case 91: {
                pstmt.setDate(index, Date.valueOf(argument));
                break;
            }
            case 7: {
                pstmt.setFloat(index, Float.parseFloat(argument));
                break;
            }
            case -6: {
                pstmt.setByte(index, Byte.parseByte(argument));
                break;
            }
            case 5: {
                pstmt.setShort(index, Short.parseShort(argument));
                break;
            }
            case 93: {
                pstmt.setTimestamp(index, Timestamp.valueOf(argument));
                break;
            }
            case 92: {
                pstmt.setTime(index, Time.valueOf(argument));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                pstmt.setBytes(index, argument.getBytes());
                break;
            }
            case 0: {
                pstmt.setNull(index, targetSqlType);
                break;
            }
            default: {
                pstmt.setObject(index, (Object)argument, targetSqlType);
            }
        }
    }

    private static int getJdbcType(String jdbcType) throws SQLException {
        Integer entry = mapJdbcNameToInt.get(jdbcType.toLowerCase(Locale.ENGLISH));
        if (entry == null) {
            try {
                entry = Integer.decode(jdbcType);
            }
            catch (NumberFormatException e) {
                throw new SQLException("Invalid data type: " + jdbcType, e);
            }
        }
        return entry;
    }

    private CallableStatement getCallableStatement(Connection conn) throws SQLException {
        return (CallableStatement)this.getPreparedStatement(conn, true);
    }

    private PreparedStatement getPreparedStatement(Connection conn) throws SQLException {
        return this.getPreparedStatement(conn, false);
    }

    private PreparedStatement getPreparedStatement(Connection conn, boolean callable) throws SQLException {
        PreparedStatement pstmt = callable ? conn.prepareCall(this.getQuery()) : conn.prepareStatement(this.getQuery());
        pstmt.setQueryTimeout(this.getIntegerQueryTimeout());
        return pstmt;
    }

    private String getStringFromResultSet(ResultSet rs) throws SQLException, UnsupportedEncodingException {
        ResultSetMetaData meta = rs.getMetaData();
        StringBuilder sb = new StringBuilder();
        int numColumns = meta.getColumnCount();
        for (int i = 1; i <= numColumns; ++i) {
            sb.append(meta.getColumnLabel(i));
            if (i == numColumns) {
                sb.append('\n');
                continue;
            }
            sb.append('\t');
        }
        JMeterVariables jmvars = this.getThreadContext().getVariables();
        String[] varNames = this.getVariableNames().split(COMMA);
        String currentResultVariable = this.getResultVariable().trim();
        ArrayList results = null;
        if (!currentResultVariable.isEmpty()) {
            results = new ArrayList();
            jmvars.putObject(currentResultVariable, results);
        }
        int j = 0;
        while (rs.next()) {
            HashMap<String, Object> row = null;
            ++j;
            for (int i = 1; i <= numColumns; ++i) {
                String name;
                Object o = rs.getObject(i);
                if (results != null) {
                    if (row == null) {
                        row = new HashMap<String, Object>(numColumns);
                        results.add(row);
                    }
                    row.put(meta.getColumnLabel(i), o);
                }
                if (o instanceof byte[]) {
                    o = new String((byte[])o, ENCODING);
                }
                sb.append(o);
                if (i == numColumns) {
                    sb.append('\n');
                } else {
                    sb.append('\t');
                }
                if (i > varNames.length || (name = varNames[i - 1].trim()).length() <= 0) continue;
                jmvars.put(name + UNDERSCORE + j, o == null ? null : o.toString());
            }
        }
        for (String varName : varNames) {
            String name = varName.trim();
            if (name.length() <= 0 || jmvars == null) continue;
            String varCount = name + "_#";
            String prevCount = jmvars.get(varCount);
            if (prevCount != null) {
                int prev = Integer.parseInt(prevCount);
                for (int n = j + 1; n <= prev; ++n) {
                    jmvars.remove(name + UNDERSCORE + n);
                }
            }
            jmvars.put(varCount, Integer.toString(j));
        }
        return sb.toString();
    }

    public static void close(Connection c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (SQLException e) {
            log.warn("Error closing Connection", (Throwable)e);
        }
    }

    public static void close(Statement s) {
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (SQLException e) {
            log.warn("Error closing Statement {}", (Object)s.toString(), (Object)e);
        }
    }

    public static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            log.warn("Error closing ResultSet", (Throwable)e);
        }
    }

    public int getIntegerQueryTimeout() {
        int timeout = 0;
        try {
            timeout = Integer.parseInt(this.queryTimeout);
        }
        catch (NumberFormatException nfe) {
            timeout = 0;
        }
        return timeout;
    }

    public String getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(String queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public String getQuery() {
        return this.query;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("[");
        sb.append(this.getQueryType());
        sb.append("] ");
        sb.append(this.getQuery());
        sb.append("\n");
        sb.append(this.getQueryArguments());
        sb.append("\n");
        sb.append(this.getQueryArgumentsTypes());
        return sb.toString();
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public String getQueryArguments() {
        return this.queryArguments;
    }

    public void setQueryArguments(String queryArguments) {
        this.queryArguments = queryArguments;
    }

    public String getQueryArgumentsTypes() {
        return this.queryArgumentsTypes;
    }

    public void setQueryArgumentsTypes(String queryArgumentsType) {
        this.queryArgumentsTypes = queryArgumentsType;
    }

    public String getVariableNames() {
        return this.variableNames;
    }

    public void setVariableNames(String variableNames) {
        this.variableNames = variableNames;
    }

    public String getResultSetHandler() {
        return this.resultSetHandler;
    }

    public void setResultSetHandler(String resultSetHandler) {
        this.resultSetHandler = resultSetHandler;
    }

    public String getResultVariable() {
        return this.resultVariable;
    }

    public void setResultVariable(String resultVariable) {
        this.resultVariable = resultVariable;
    }

    public void testStarted() {
        this.testStarted("");
    }

    public void testStarted(String host) {
    }

    public void testEnded() {
        this.testEnded("");
    }

    public void testEnded(String host) {
    }

    static {
        Field[] fields;
        log = LoggerFactory.getLogger(AbstractJDBCTestElement.class);
        NULL_MARKER = JMeterUtils.getPropDefault((String)"jdbcsampler.nullmarker", (String)"]NULL[");
        ENCODING = StandardCharsets.UTF_8.name();
        mapJdbcNameToInt = new HashMap<String, Integer>();
        for (Field field : fields = Types.class.getFields()) {
            try {
                String name = field.getName();
                Integer value = (Integer)field.get(null);
                mapJdbcNameToInt.put(name.toLowerCase(Locale.ENGLISH), value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        MAX_RETAIN_SIZE = JMeterUtils.getPropDefault((String)"jdbcsampler.max_retain_result_size", (int)65536);
    }
}

