/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.JLabeledRadioI18N;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.jms.sampler.SubscriberSampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledPasswordField;
import org.apache.jorphan.gui.JLabeledTextField;

public class JMSSubscriberGui
extends AbstractSamplerGui
implements ChangeListener {
    private static final long serialVersionUID = 240L;
    private final JCheckBox useProperties = new JCheckBox(JMeterUtils.getResString((String)"jms_use_properties_file"), false);
    private final JLabeledTextField jndiICF = new JLabeledTextField(JMeterUtils.getResString((String)"jms_initial_context_factory"));
    private final JLabeledTextField urlField = new JLabeledTextField(JMeterUtils.getResString((String)"jms_provider_url"));
    private final JLabeledTextField jndiConnFac = new JLabeledTextField(JMeterUtils.getResString((String)"jms_connection_factory"));
    private final JLabeledTextField jmsDestination = new JLabeledTextField(JMeterUtils.getResString((String)"jms_topic"));
    private final JLabeledTextField jmsDurableSubscriptionId = new JLabeledTextField(JMeterUtils.getResString((String)"jms_durable_subscription_id"));
    private final JLabeledTextField jmsClientId = new JLabeledTextField(JMeterUtils.getResString((String)"jms_client_id"));
    private final JLabeledTextField jmsSelector = new JLabeledTextField(JMeterUtils.getResString((String)"jms_selector"));
    private final JLabeledTextField jmsUser = new JLabeledTextField(JMeterUtils.getResString((String)"jms_user"));
    private final JLabeledTextField jmsPwd = new JLabeledPasswordField(JMeterUtils.getResString((String)"jms_pwd"));
    private final JLabeledTextField samplesToAggregate = new JLabeledTextField(JMeterUtils.getResString((String)"jms_itertions"));
    private final JCheckBox useAuth = new JCheckBox(JMeterUtils.getResString((String)"jms_use_auth"), false);
    private final JCheckBox storeResponse = new JCheckBox(JMeterUtils.getResString((String)"jms_store_response"), true);
    private final JLabeledTextField timeout = new JLabeledTextField(JMeterUtils.getResString((String)"jms_timeout"));
    private final JLabeledTextField jmsErrorPauseBetween = new JLabeledTextField(JMeterUtils.getResString((String)"jms_error_pause_between"));
    private final JLabeledTextField jmsErrorReconnectOnCodes = new JLabeledTextField(JMeterUtils.getResString((String)"jms_error_reconnect_on_codes"));
    private final JLabeledTextField separator = new JLabeledTextField(JMeterUtils.getResString((String)"jms_separator"));
    public static final String RECEIVE_RSC = "jms_subscriber_receive";
    public static final String ON_MESSAGE_RSC = "jms_subscriber_on_message";
    private static final String[] CLIENT_ITEMS = new String[]{"jms_subscriber_receive", "jms_subscriber_on_message"};
    private final JLabeledRadioI18N clientChoice = new JLabeledRadioI18N("jms_client_type", CLIENT_ITEMS, "jms_subscriber_receive");
    private final JCheckBox stopBetweenSamples = new JCheckBox(JMeterUtils.getResString((String)"jms_stop_between_samples"), true);
    private static final String DEST_SETUP_STATIC = "jms_dest_setup_static";
    private static final String DEST_SETUP_DYNAMIC = "jms_dest_setup_dynamic";
    private static final String[] DEST_SETUP_ITEMS = new String[]{"jms_dest_setup_static", "jms_dest_setup_dynamic"};
    private final JLabeledRadioI18N destSetup = new JLabeledRadioI18N("jms_dest_setup", DEST_SETUP_ITEMS, "jms_dest_setup_static");

    public JMSSubscriberGui() {
        this.init();
    }

    public String getLabelResource() {
        return "jms_subscriber_title";
    }

    public TestElement createTestElement() {
        SubscriberSampler sampler = new SubscriberSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement s) {
        SubscriberSampler sampler = (SubscriberSampler)s;
        super.configureTestElement((TestElement)sampler);
        sampler.setUseJNDIProperties(String.valueOf(this.useProperties.isSelected()));
        sampler.setJNDIIntialContextFactory(this.jndiICF.getText());
        sampler.setProviderUrl(this.urlField.getText());
        sampler.setConnectionFactory(this.jndiConnFac.getText());
        sampler.setDestination(this.jmsDestination.getText());
        sampler.setDurableSubscriptionId(this.jmsDurableSubscriptionId.getText());
        sampler.setClientID(this.jmsClientId.getText());
        sampler.setJmsSelector(this.jmsSelector.getText());
        sampler.setUsername(this.jmsUser.getText());
        sampler.setPassword(this.jmsPwd.getText());
        sampler.setUseAuth(this.useAuth.isSelected());
        sampler.setIterations(this.samplesToAggregate.getText());
        sampler.setReadResponse(String.valueOf(this.storeResponse.isSelected()));
        sampler.setClientChoice(this.clientChoice.getText());
        sampler.setStopBetweenSamples(this.stopBetweenSamples.isSelected());
        sampler.setTimeout(this.timeout.getText());
        sampler.setReconnectionErrorCodes(this.jmsErrorReconnectOnCodes.getText());
        sampler.setPauseBetweenErrors(this.jmsErrorPauseBetween.getText());
        sampler.setDestinationStatic(this.destSetup.getText().equals(DEST_SETUP_STATIC));
        sampler.setSeparator(this.separator.getText());
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        VerticalPanel mainPanel = new VerticalPanel();
        this.add((Component)mainPanel, "Center");
        this.jndiICF.setToolTipText("java.naming.factory.initial");
        this.urlField.setToolTipText("java.naming.provider.url");
        this.jmsUser.setToolTipText("java.naming.security.principal");
        this.jmsPwd.setToolTipText("java.naming.security.credentials");
        mainPanel.add(this.useProperties);
        mainPanel.add((Component)this.jndiICF);
        mainPanel.add((Component)this.urlField);
        mainPanel.add((Component)this.jndiConnFac);
        mainPanel.add(this.createDestinationPane());
        mainPanel.add((Component)this.jmsDurableSubscriptionId);
        mainPanel.add((Component)this.jmsClientId);
        mainPanel.add((Component)this.jmsSelector);
        mainPanel.add(this.useAuth);
        mainPanel.add((Component)this.jmsUser);
        mainPanel.add((Component)this.jmsPwd);
        mainPanel.add((Component)this.samplesToAggregate);
        mainPanel.add(this.storeResponse);
        mainPanel.add((Component)this.timeout);
        HorizontalPanel choice = new HorizontalPanel();
        choice.add((Component)this.clientChoice);
        choice.add(this.stopBetweenSamples);
        mainPanel.add((Component)choice);
        mainPanel.add((Component)this.separator);
        mainPanel.add((Component)this.jmsErrorReconnectOnCodes);
        mainPanel.add((Component)this.jmsErrorPauseBetween);
        this.useProperties.addChangeListener(this);
        this.useAuth.addChangeListener(this);
    }

    public void configure(TestElement el) {
        super.configure(el);
        SubscriberSampler sampler = (SubscriberSampler)el;
        this.useProperties.setSelected(sampler.getUseJNDIPropertiesAsBoolean());
        this.jndiICF.setText(sampler.getJNDIInitialContextFactory());
        this.urlField.setText(sampler.getProviderUrl());
        this.jndiConnFac.setText(sampler.getConnectionFactory());
        this.jmsDestination.setText(sampler.getDestination());
        this.jmsDurableSubscriptionId.setText(sampler.getDurableSubscriptionId());
        this.jmsClientId.setText(sampler.getClientId());
        this.jmsSelector.setText(sampler.getJmsSelector());
        this.jmsUser.setText(sampler.getUsername());
        this.jmsPwd.setText(sampler.getPassword());
        this.samplesToAggregate.setText(sampler.getIterations());
        this.useAuth.setSelected(sampler.isUseAuth());
        this.jmsUser.setEnabled(this.useAuth.isSelected());
        this.jmsPwd.setEnabled(this.useAuth.isSelected());
        this.storeResponse.setSelected(sampler.getReadResponseAsBoolean());
        this.clientChoice.setText(sampler.getClientChoice());
        this.stopBetweenSamples.setSelected(sampler.isStopBetweenSamples());
        this.timeout.setText(sampler.getTimeout());
        this.separator.setText(sampler.getSeparator());
        this.destSetup.setText(sampler.isDestinationStatic() ? DEST_SETUP_STATIC : DEST_SETUP_DYNAMIC);
        this.jmsErrorReconnectOnCodes.setText(sampler.getReconnectionErrorCodes());
        this.jmsErrorPauseBetween.setText(sampler.getPauseBetweenErrors());
    }

    public void clearGui() {
        super.clearGui();
        this.useProperties.setSelected(false);
        this.jndiICF.setText("");
        this.urlField.setText("");
        this.jndiConnFac.setText("");
        this.jmsDestination.setText("");
        this.jmsDurableSubscriptionId.setText("");
        this.jmsClientId.setText("");
        this.jmsSelector.setText("");
        this.jmsUser.setText("");
        this.jmsPwd.setText("");
        this.samplesToAggregate.setText("1");
        this.timeout.setText("");
        this.separator.setText("");
        this.useAuth.setSelected(false);
        this.jmsUser.setEnabled(false);
        this.jmsPwd.setEnabled(false);
        this.storeResponse.setSelected(true);
        this.clientChoice.setText(RECEIVE_RSC);
        this.stopBetweenSamples.setSelected(false);
        this.destSetup.setText(DEST_SETUP_STATIC);
        this.jmsErrorReconnectOnCodes.setText("");
        this.jmsErrorPauseBetween.setText("");
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        if (event.getSource() == this.useProperties) {
            boolean isUseProperties = this.useProperties.isSelected();
            this.jndiICF.setEnabled(!isUseProperties);
            this.urlField.setEnabled(!isUseProperties);
            this.useAuth.setEnabled(!isUseProperties);
        } else if (event.getSource() == this.useAuth) {
            this.jmsUser.setEnabled(this.useAuth.isSelected() && this.useAuth.isEnabled());
            this.jmsPwd.setEnabled(this.useAuth.isSelected() && this.useAuth.isEnabled());
        }
    }

    private JPanel createDestinationPane() {
        JPanel pane = new JPanel(new BorderLayout(3, 0));
        pane.add((Component)this.jmsDestination, "Center");
        this.destSetup.setLayout((LayoutManager)new BoxLayout((Container)this.destSetup, 0));
        pane.add((Component)this.destSetup, "East");
        return pane;
    }
}

