/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.naming.NamingException;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.jms.Utils;
import org.apache.jmeter.protocol.jms.client.ClientPool;
import org.apache.jmeter.protocol.jms.client.InitialContextFactory;
import org.apache.jmeter.protocol.jms.client.Publisher;
import org.apache.jmeter.protocol.jms.sampler.BaseJMSSampler;
import org.apache.jmeter.protocol.jms.sampler.JMSProperties;
import org.apache.jmeter.protocol.jms.sampler.render.MessageRenderer;
import org.apache.jmeter.protocol.jms.sampler.render.Renderers;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublisherSampler
extends BaseJMSSampler
implements TestStateListener {
    public static final String RAW_DATA = "<RAW>";
    public static final String DEFAULT_ENCODING = "<DEFAULT>";
    public static final Set<String> NO_ENCODING = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("<RAW>", "<DEFAULT>")));
    private static final long serialVersionUID = 233L;
    private static final Logger log = LoggerFactory.getLogger(PublisherSampler.class);
    private static final String INPUT_FILE = "jms.input_file";
    private static final String RANDOM_PATH = "jms.random_path";
    private static final String TEXT_MSG = "jms.text_message";
    private static final String CONFIG_CHOICE = "jms.config_choice";
    private static final String MESSAGE_CHOICE = "jms.config_msg_type";
    private static final String NON_PERSISTENT_DELIVERY = "jms.non_persistent";
    private static final String JMS_PROPERTIES = "jms.jmsProperties";
    private static final String JMS_PRIORITY = "jms.priority";
    private static final String JMS_EXPIRATION = "jms.expiration";
    private static final String JMS_FILE_ENCODING = "jms.file_encoding";
    private static final String[] TEXT_FILE_EXTS = new String[]{".txt", ".obj"};
    private static final String[] BIN_FILE_EXTS = new String[]{".dat"};
    private transient Publisher publisher = null;
    private static final FileServer FSERVER = FileServer.getFileServer();
    private Cache<Object, Object> fileCache = null;
    private static final String USE_FILE_LOCALNAME = JMeterUtils.getResString((String)"jms_use_file");
    private static final String USE_RANDOM_LOCALNAME = JMeterUtils.getResString((String)"jms_use_random_file");

    public static String[] getSupportedEncodings() {
        return (String[])Stream.concat(NO_ENCODING.stream(), Arrays.stream(StandardCharsets.class.getDeclaredFields()).filter(f -> Modifier.isStatic(f.getModifiers()) && Modifier.isPublic(f.getModifiers()) && f.getType() == Charset.class).map(f -> {
            try {
                return (Charset)f.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }).map(Charset::displayName).sorted()).toArray(String[]::new);
    }

    public void testStarted(String test) {
        this.testStarted();
    }

    public void testEnded(String host) {
        this.testEnded();
    }

    public void testEnded() {
        log.debug("PublisherSampler.testEnded called");
        ClientPool.clearClient();
        InitialContextFactory.close();
    }

    public void testStarted() {
    }

    private void initClient() throws JMSException, NamingException {
        this.configureIsReconnectErrorCode();
        this.publisher = new Publisher(this.getUseJNDIPropertiesAsBoolean(), this.getJNDIInitialContextFactory(), this.getProviderUrl(), this.getConnectionFactory(), this.getDestination(), this.isUseAuth(), this.getUsername(), this.getPassword(), this.isDestinationStatic());
        ClientPool.addClient(this.publisher);
        log.debug("PublisherSampler.initClient called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SampleResult sample() {
        String configChoice = this.getConfigChoice();
        if (this.fileCache == null) {
            this.fileCache = PublisherSampler.buildCache(configChoice);
        }
        SampleResult result = new SampleResult();
        result.setSampleLabel(this.getName());
        result.setSuccessful(false);
        result.setResponseCode("000");
        if (this.publisher == null) {
            try {
                this.initClient();
            }
            catch (JMSException | NamingException e) {
                result.sampleStart();
                result.sampleEnd();
                this.handleError(result, (Exception)e, false);
                return result;
            }
        }
        StringBuilder buffer = new StringBuilder();
        StringBuilder propBuffer = new StringBuilder();
        int loop = this.getIterationCount();
        result.sampleStart();
        String type = this.getMessageChoice();
        try {
            Map<String, Object> msgProperties = this.getJMSProperties().getJmsPropertysAsMap();
            int deliveryMode = this.getUseNonPersistentDelivery() ? 1 : 2;
            int priority = Integer.parseInt(this.getPriority());
            long expiration = Long.parseLong(this.getExpiration());
            for (int idx = 0; idx < loop; ++idx) {
                Message msg;
                if ("jms_text_message".equals(type)) {
                    String tmsg = this.getRenderedContent(String.class, TEXT_FILE_EXTS);
                    msg = this.publisher.publish(tmsg, this.getDestination(), msgProperties, deliveryMode, priority, expiration);
                    buffer.append(tmsg);
                } else if ("jms_map_message".equals(type)) {
                    Map map = this.getRenderedContent(Map.class, TEXT_FILE_EXTS);
                    msg = this.publisher.publish(map, this.getDestination(), msgProperties, deliveryMode, priority, expiration);
                } else if ("jms_object_message".equals(type)) {
                    Serializable omsg = this.getRenderedContent(Serializable.class, TEXT_FILE_EXTS);
                    msg = this.publisher.publish(omsg, this.getDestination(), msgProperties, deliveryMode, priority, expiration);
                } else if ("jms_bytes_message".equals(type)) {
                    byte[] bmsg = this.getRenderedContent(byte[].class, BIN_FILE_EXTS);
                    msg = this.publisher.publish(bmsg, this.getDestination(), msgProperties, deliveryMode, priority, expiration);
                } else {
                    throw new JMSException(type + " is not recognised");
                }
                Utils.messageProperties(propBuffer, msg);
            }
            result.setResponseCodeOK();
            result.setResponseMessage(loop + " messages published");
            result.setSuccessful(true);
            result.setSamplerData(buffer.toString());
            result.setSampleCount(loop);
            result.setRequestHeaders(propBuffer.toString());
        }
        catch (JMSException e) {
            this.handleError(result, (Exception)((Object)e), true);
        }
        catch (Exception e) {
            this.handleError(result, e, false);
        }
        finally {
            result.sampleEnd();
        }
        return result;
    }

    private void handleError(SampleResult result, Exception e, boolean checkForReconnect) {
        result.setSuccessful(false);
        result.setResponseMessage(e.toString());
        if (e instanceof JMSException) {
            JMSException jms = (JMSException)((Object)e);
            String errorCode = Optional.ofNullable(jms.getErrorCode()).orElse("");
            if (checkForReconnect && this.publisher != null && this.getIsReconnectErrorCode().test(errorCode)) {
                ClientPool.removeClient(this.publisher);
                IOUtils.closeQuietly((Closeable)this.publisher);
                this.publisher = null;
            }
            result.setResponseCode(errorCode);
        }
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        result.setResponseData(writer.toString(), "UTF-8");
    }

    protected static Cache<Object, Object> buildCache(String configChoice) {
        Caffeine cacheBuilder = Caffeine.newBuilder();
        switch (configChoice) {
            case "jms_use_file": {
                cacheBuilder.maximumSize(1L);
                break;
            }
            default: {
                cacheBuilder.expireAfterWrite(0L, TimeUnit.MILLISECONDS).maximumSize(0L);
            }
        }
        return cacheBuilder.build();
    }

    private String getFilePath(String ... ext) {
        switch (this.getConfigChoice()) {
            case "jms_use_file": {
                return this.getInputFile();
            }
            case "jms_use_random_file": {
                return FSERVER.getRandomFile(this.getRandomPath(), ext).getAbsolutePath();
            }
        }
        throw new IllegalArgumentException("Type of input not handled:" + this.getConfigChoice());
    }

    private <T> T getRenderedContent(Class<T> type, String[] fileExts) {
        MessageRenderer<T> renderer = Renderers.getInstance(type);
        if (this.getConfigChoice().equals("jms_use_text")) {
            return renderer.getValueFromText(this.getTextMessage());
        }
        return renderer.getValueFromFile(this.getFilePath(fileExts), this.getFileEncoding(), !this.isRaw(), this.fileCache);
    }

    private boolean isRaw() {
        return RAW_DATA.equals(this.getFileEncoding());
    }

    public void setConfigChoice(String choice) {
        this.setProperty(CONFIG_CHOICE, choice);
    }

    public String getConfigChoice() {
        String config = this.getPropertyAsString(CONFIG_CHOICE);
        if (config.equals(USE_FILE_LOCALNAME) || config.equals("jms_use_file")) {
            return "jms_use_file";
        }
        if (config.equals(USE_RANDOM_LOCALNAME) || config.equals("jms_use_random_file")) {
            return "jms_use_random_file";
        }
        return config;
    }

    public void setMessageChoice(String choice) {
        this.setProperty(MESSAGE_CHOICE, choice);
    }

    public String getMessageChoice() {
        return this.getPropertyAsString(MESSAGE_CHOICE);
    }

    public void setInputFile(String file) {
        this.setProperty(INPUT_FILE, file);
    }

    public String getInputFile() {
        return this.getPropertyAsString(INPUT_FILE);
    }

    public void setRandomPath(String path) {
        this.setProperty(RANDOM_PATH, path);
    }

    public String getRandomPath() {
        return this.getPropertyAsString(RANDOM_PATH);
    }

    public void setTextMessage(String message) {
        this.setProperty(TEXT_MSG, message);
    }

    public String getTextMessage() {
        return this.getPropertyAsString(TEXT_MSG);
    }

    public String getExpiration() {
        String expiration = this.getPropertyAsString(JMS_EXPIRATION);
        if (expiration.length() == 0) {
            return "0";
        }
        return expiration;
    }

    public String getPriority() {
        String priority = this.getPropertyAsString(JMS_PRIORITY);
        if (priority.length() == 0) {
            return "4";
        }
        return priority;
    }

    public void setPriority(String s) {
        if ("4".equals(s)) {
            s = "";
        }
        this.setProperty(JMS_PRIORITY, s);
    }

    public void setExpiration(String s) {
        if ("0".equals(s)) {
            s = "";
        }
        this.setProperty(JMS_EXPIRATION, s);
    }

    public void setUseNonPersistentDelivery(boolean value) {
        this.setProperty(NON_PERSISTENT_DELIVERY, value, false);
    }

    public boolean getUseNonPersistentDelivery() {
        return this.getPropertyAsBoolean(NON_PERSISTENT_DELIVERY, false);
    }

    public JMSProperties getJMSProperties() {
        Object o = this.getProperty(JMS_PROPERTIES).getObjectValue();
        JMSProperties jmsProperties = null;
        jmsProperties = o instanceof Arguments ? Utils.convertArgumentsToJmsProperties((Arguments)o) : (JMSProperties)o;
        if (jmsProperties == null) {
            jmsProperties = new JMSProperties();
            this.setJMSProperties(jmsProperties);
        }
        return jmsProperties;
    }

    public void setJMSProperties(JMSProperties jmsProperties) {
        this.setProperty((JMeterProperty)new TestElementProperty(JMS_PROPERTIES, (TestElement)jmsProperties));
    }

    public String getFileEncoding() {
        return this.getPropertyAsString(JMS_FILE_ENCODING, RAW_DATA);
    }

    public void setFileEncoding(String fileEncoding) {
        this.setProperty(JMS_FILE_ENCODING, fileEncoding, RAW_DATA);
    }
}

