/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.json.JsonValue;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.MappingGenerator;
import org.apache.johnzon.mapper.MappingParser;
import org.apache.johnzon.mapper.ObjectConverter;
import org.apache.johnzon.mapper.SerializeValueFilter;
import org.apache.johnzon.mapper.TypeAwareAdapter;
import org.apache.johnzon.mapper.access.AccessMode;
import org.apache.johnzon.mapper.internal.AdapterKey;
import org.apache.johnzon.mapper.internal.ConverterAdapter;
import org.apache.johnzon.mapper.map.LazyConverterMap;

public class MapperConfig
implements Cloneable {
    private static final ObjectConverter.Codec NO_CONVERTER = new ObjectConverter.Codec(){

        @Override
        public void writeJson(Object instance, MappingGenerator jsonbGenerator) {
        }

        @Override
        public Object fromJson(JsonValue jsonObject, Type targetType, MappingParser parser) {
            return null;
        }
    };
    private final int version;
    private final boolean useJsRange;
    private final boolean close;
    private final boolean skipNull;
    private final boolean skipEmptyArray;
    private final boolean treatByteArrayAsBase64;
    private final boolean treatByteArrayAsBase64URL;
    private final boolean readAttributeBeforeWrite;
    private final boolean supportEnumMapDeserialization;
    private final AccessMode accessMode;
    private final Charset encoding;
    private final LazyConverterMap adapters;
    private final ConcurrentMap<Adapter<?, ?>, AdapterKey> reverseAdapters;
    private final Map<Class<?>, ObjectConverter.Writer<?>> objectConverterWriters;
    private final Map<Class<?>, ObjectConverter.Reader<?>> objectConverterReaders;
    private final Comparator<String> attributeOrder;
    private final boolean enforceQuoteString;
    private final boolean failOnUnknown;
    private final SerializeValueFilter serializeValueFilter;
    private final boolean useBigDecimalForFloats;
    private final Boolean deduplicateObjects;
    private final Map<Class<?>, Class<?>> interfaceImplementationMapping;
    private final boolean useBigDecimalForObjectNumbers;
    private final Function<String, Class<?>> typeLoader;
    private final Function<Class<?>, String> discriminatorMapper;
    private final Predicate<Class<?>> serializationPredicate;
    private final Predicate<Class<?>> deserializationPredicate;
    private final String discriminator;
    private final Map<Class<?>, ObjectConverter.Writer<?>> objectConverterWriterCache;
    private final Map<Class<?>, ObjectConverter.Reader<?>> objectConverterReaderCache;
    private final Collection<Type> noParserAdapterTypes = new ConcurrentHashMap().keySet(true);
    private final Collection<Type> noGeneratorAdapterTypes = new ConcurrentHashMap().keySet(true);
    private final Function<Class<?>, CustomEnumConverter<?>> enumConverterFactory;

    public MapperConfig(LazyConverterMap adapters, Map<Class<?>, ObjectConverter.Writer<?>> objectConverterWriters, Map<Class<?>, ObjectConverter.Reader<?>> objectConverterReaders, int version, boolean close, boolean skipNull, boolean skipEmptyArray, boolean treatByteArrayAsBase64, boolean treatByteArrayAsBase64URL, boolean readAttributeBeforeWrite, AccessMode accessMode, Charset encoding, Comparator<String> attributeOrder, boolean enforceQuoteString, boolean failOnUnknown, SerializeValueFilter serializeValueFilter, boolean useBigDecimalForFloats, Boolean deduplicateObjects, Map<Class<?>, Class<?>> interfaceImplementationMapping, boolean useJsRange, boolean useBigDecimalForObjectNumbers, boolean supportEnumMapDeserialization, Function<String, Class<?>> typeLoader, Function<Class<?>, String> discriminatorMapper, String discriminator, Predicate<Class<?>> deserializationPredicate, Predicate<Class<?>> serializationPredicate, Function<Class<?>, CustomEnumConverter<?>> enumConverterFactory) {
        this.objectConverterWriters = objectConverterWriters;
        this.objectConverterReaders = objectConverterReaders;
        this.version = version;
        this.close = close;
        this.skipNull = skipNull;
        this.skipEmptyArray = skipEmptyArray;
        this.treatByteArrayAsBase64 = treatByteArrayAsBase64;
        this.treatByteArrayAsBase64URL = treatByteArrayAsBase64URL;
        this.readAttributeBeforeWrite = readAttributeBeforeWrite;
        this.accessMode = accessMode;
        this.encoding = encoding;
        this.useJsRange = useJsRange;
        this.useBigDecimalForObjectNumbers = useBigDecimalForObjectNumbers;
        this.supportEnumMapDeserialization = supportEnumMapDeserialization;
        this.typeLoader = typeLoader;
        this.discriminatorMapper = discriminatorMapper;
        this.serializationPredicate = serializationPredicate;
        this.deserializationPredicate = deserializationPredicate;
        this.discriminator = discriminator;
        this.enumConverterFactory = enumConverterFactory;
        this.adapters = adapters;
        this.reverseAdapters = new ConcurrentHashMap(adapters.size());
        adapters.forEach((k, v) -> this.reverseAdapters.put((Adapter<?, ?>)v, (AdapterKey)k));
        this.attributeOrder = attributeOrder;
        this.enforceQuoteString = enforceQuoteString;
        this.failOnUnknown = failOnUnknown;
        this.serializeValueFilter = serializeValueFilter == null ? (name, value) -> false : serializeValueFilter;
        this.interfaceImplementationMapping = interfaceImplementationMapping;
        this.objectConverterWriterCache = new HashMap(objectConverterWriters.size());
        this.objectConverterReaderCache = new HashMap(objectConverterReaders.size());
        this.useBigDecimalForFloats = useBigDecimalForFloats;
        this.deduplicateObjects = deduplicateObjects;
    }

    public Function<Class<?>, CustomEnumConverter<?>> getEnumConverterFactory() {
        return this.enumConverterFactory;
    }

    public Collection<Type> getNoParserAdapterTypes() {
        return this.noParserAdapterTypes;
    }

    public Collection<Type> getNoGeneratorAdapterTypes() {
        return this.noGeneratorAdapterTypes;
    }

    public Function<String, Class<?>> getTypeLoader() {
        return this.typeLoader;
    }

    public Function<Class<?>, String> getDiscriminatorMapper() {
        return this.discriminatorMapper;
    }

    public Predicate<Class<?>> getDeserializationPredicate() {
        return this.deserializationPredicate;
    }

    public Predicate<Class<?>> getSerializationPredicate() {
        return this.serializationPredicate;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public boolean isUseBigDecimalForObjectNumbers() {
        return this.useBigDecimalForObjectNumbers;
    }

    public boolean isUseJsRange() {
        return this.useJsRange;
    }

    public Map<Class<?>, Class<?>> getInterfaceImplementationMapping() {
        return this.interfaceImplementationMapping;
    }

    public SerializeValueFilter getSerializeValueFilter() {
        return this.serializeValueFilter;
    }

    public Adapter findAdapter(Type aClass) {
        Class clazz;
        if (this.getNoGeneratorAdapterTypes().contains(aClass)) {
            return null;
        }
        Object converter = this.adapters.get(new AdapterKey(aClass, (Type)((Object)String.class), true));
        if (converter != null) {
            return converter;
        }
        if (Class.class.isInstance(aClass) && Enum.class.isAssignableFrom(clazz = (Class)Class.class.cast(aClass))) {
            ConverterAdapter enumConverter = new ConverterAdapter(this.enumConverterFactory.apply(clazz), clazz);
            this.adapters.putIfAbsent(new AdapterKey((Type)((Object)String.class), aClass), enumConverter);
            return enumConverter;
        }
        List matched = this.adapters.adapterKeys().stream().filter(k -> k.isAssignableFrom(aClass)).collect(Collectors.toList());
        if (matched.size() == 1) {
            Object adapter = this.adapters.get(matched.iterator().next());
            if (TypeAwareAdapter.class.isInstance(adapter)) {
                this.adapters.put(new AdapterKey(aClass, ((TypeAwareAdapter)TypeAwareAdapter.class.cast(adapter)).getTo()), adapter);
            }
            return adapter;
        }
        this.getNoGeneratorAdapterTypes().add(aClass);
        return null;
    }

    public ObjectConverter.Reader findObjectConverterReader(Class clazz) {
        return this.findObjectConverter(clazz, this.objectConverterReaders, this.objectConverterReaderCache);
    }

    public ObjectConverter.Writer findObjectConverterWriter(Class clazz) {
        return this.findObjectConverter(clazz, this.objectConverterWriters, this.objectConverterWriterCache);
    }

    private <T> T findObjectConverter(Class clazz, Map<Class<?>, T> from, Map<Class<?>, T> cache) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz must not be null");
        }
        Object converter = cache.get(clazz);
        if (converter != null && converter != NO_CONVERTER) {
            return converter;
        }
        if (converter == NO_CONVERTER) {
            return null;
        }
        HashMap matchingConverters = new HashMap();
        for (Map.Entry<Class<?>, T> entry : from.entrySet()) {
            if (clazz == entry.getKey()) {
                converter = entry.getValue();
                break;
            }
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            matchingConverters.put(entry.getKey(), entry.getValue());
        }
        if (converter != null) {
            cache.put(clazz, converter);
            return converter;
        }
        if (matchingConverters.isEmpty()) {
            cache.put(clazz, NO_CONVERTER);
            return null;
        }
        for (Class toProcess = clazz; toProcess != null && converter == null && (converter = matchingConverters.get(toProcess)) == null; toProcess = toProcess.getSuperclass()) {
            Class<?>[] interfaces = toProcess.getInterfaces();
            if (interfaces.length > 0) {
                Class<?> interfaceToSearch;
                Class<?>[] classArray = interfaces;
                int n = classArray.length;
                for (int i = 0; i < n && (converter = matchingConverters.get(interfaceToSearch = classArray[i])) == null; ++i) {
                }
            }
            if (converter != null || !toProcess.isInterface()) continue;
            converter = matchingConverters.get(Object.class);
            break;
        }
        if (converter == null) {
            cache.put(clazz, NO_CONVERTER);
        } else {
            cache.put(clazz, converter);
        }
        return converter;
    }

    public boolean isFailOnUnknown() {
        return this.failOnUnknown;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isClose() {
        return this.close;
    }

    public boolean isSkipNull() {
        return this.skipNull;
    }

    public boolean isSkipEmptyArray() {
        return this.skipEmptyArray;
    }

    public boolean isTreatByteArrayAsBase64() {
        return this.treatByteArrayAsBase64;
    }

    public boolean isTreatByteArrayAsBase64URL() {
        return this.treatByteArrayAsBase64URL;
    }

    public boolean isReadAttributeBeforeWrite() {
        return this.readAttributeBeforeWrite;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public LazyConverterMap getAdapters() {
        return this.adapters;
    }

    public ConcurrentMap<Adapter<?, ?>, AdapterKey> getReverseAdapters() {
        return this.reverseAdapters;
    }

    public Map<Class<?>, ObjectConverter.Writer<?>> getObjectConverterWriters() {
        return this.objectConverterWriters;
    }

    public Map<Class<?>, ObjectConverter.Reader<?>> getObjectConverterReaders() {
        return this.objectConverterReaders;
    }

    public Comparator<String> getAttributeOrder() {
        return this.attributeOrder;
    }

    public boolean isEnforceQuoteString() {
        return this.enforceQuoteString;
    }

    public boolean isUseBigDecimalForFloats() {
        return this.useBigDecimalForFloats;
    }

    public Boolean isDeduplicateObjects() {
        return this.deduplicateObjects;
    }

    public boolean isSupportEnumContainerDeserialization() {
        return this.supportEnumMapDeserialization;
    }

    public static interface CustomEnumConverter<A>
    extends Converter<A>,
    Converter.TypeAccess {
    }
}

