/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public interface ReplicationPolicy {
    public String formatRemoteTopic(String var1, String var2);

    public String topicSource(String var1);

    public String upstreamTopic(String var1);

    default public String originalTopic(String topic) {
        String upstream = this.upstreamTopic(topic);
        if (upstream == null || upstream.equals(topic)) {
            return topic;
        }
        return this.originalTopic(upstream);
    }

    default public String heartbeatsTopic() {
        return "heartbeats";
    }

    default public String offsetSyncsTopic(String clusterAlias) {
        return "mm2-offset-syncs." + clusterAlias + ".internal";
    }

    default public String checkpointsTopic(String clusterAlias) {
        return clusterAlias + ".checkpoints.internal";
    }

    default public boolean isHeartbeatsTopic(String topic) {
        return this.heartbeatsTopic().equals(this.originalTopic(topic));
    }

    default public boolean isCheckpointsTopic(String topic) {
        return topic.endsWith(".checkpoints.internal");
    }

    default public boolean isMM2InternalTopic(String topic) {
        return topic.endsWith(".internal");
    }

    default public boolean isInternalTopic(String topic) {
        boolean isKafkaInternalTopic = topic.startsWith("__") || topic.startsWith(".");
        boolean isDefaultConnectTopic = topic.endsWith("-internal") || topic.endsWith(".internal");
        return this.isMM2InternalTopic(topic) || isKafkaInternalTopic || isDefaultConnectTopic;
    }
}

