/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.ws.rs.core.UriBuilder;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.rest.ConnectRestExtension;
import org.apache.kafka.connect.rest.ConnectRestExtensionContext;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.health.ConnectClusterDetailsImpl;
import org.apache.kafka.connect.runtime.health.ConnectClusterStateImpl;
import org.apache.kafka.connect.runtime.rest.ConnectRestConfigurable;
import org.apache.kafka.connect.runtime.rest.ConnectRestExtensionContextImpl;
import org.apache.kafka.connect.runtime.rest.errors.ConnectExceptionMapper;
import org.apache.kafka.connect.runtime.rest.resources.ConfluentV1MetadataResource;
import org.apache.kafka.connect.runtime.rest.resources.ConnectorPluginsResource;
import org.apache.kafka.connect.runtime.rest.resources.ConnectorsResource;
import org.apache.kafka.connect.runtime.rest.resources.LoggingResource;
import org.apache.kafka.connect.runtime.rest.resources.RootResource;
import org.apache.kafka.connect.runtime.rest.util.SSLUtils;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.Slf4jRequestLogWriter;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.servlets.HeaderFilter;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServer {
    private static final Logger log = LoggerFactory.getLogger(RestServer.class);
    private static final String ADMIN_SERVER_CONNECTOR_NAME = "Admin";
    private static final Pattern LISTENER_PATTERN = Pattern.compile("^(.*)://\\[?([0-9a-zA-Z\\-%._:]*)\\]?:(-?[0-9]+)");
    private static final long GRACEFUL_SHUTDOWN_TIMEOUT_MS = 60000L;
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    private final WorkerConfig config;
    private ContextHandlerCollection handlers;
    private Server jettyServer;
    private List<ConnectRestExtension> connectRestExtensions = Collections.emptyList();

    public RestServer(WorkerConfig config) {
        this.config = config;
        List<String> listeners = this.parseListeners();
        List adminListeners = config.getList("admin.listeners");
        this.jettyServer = new Server();
        this.handlers = new ContextHandlerCollection();
        this.createConnectors(listeners, adminListeners);
    }

    List<String> parseListeners() {
        List<String> listeners = this.config.getList("listeners");
        if (listeners == null || listeners.size() == 0) {
            String hostname = this.config.getString("rest.host.name");
            if (hostname == null) {
                hostname = "";
            }
            listeners = Collections.singletonList(String.format("%s://%s:%d", PROTOCOL_HTTP, hostname, this.config.getInt("rest.port")));
        }
        return listeners;
    }

    public void createConnectors(List<String> listeners, List<String> adminListeners) {
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        for (String listener : listeners) {
            if (listener.isEmpty()) continue;
            Connector connector = this.createConnector(listener);
            connectors.add(connector);
            log.info("Added connector for {}", (Object)listener);
        }
        this.jettyServer.setConnectors(connectors.toArray(new Connector[connectors.size()]));
        if (adminListeners != null && !adminListeners.isEmpty()) {
            for (String adminListener : adminListeners) {
                Connector conn = this.createConnector(adminListener, true);
                this.jettyServer.addConnector(conn);
                log.info("Added admin connector for {}", (Object)adminListener);
            }
        }
    }

    public Connector createConnector(String listener) {
        return this.createConnector(listener, false);
    }

    public Connector createConnector(String listener, boolean isAdmin) {
        ServerConnector connector;
        Matcher listenerMatcher = LISTENER_PATTERN.matcher(listener);
        if (!listenerMatcher.matches()) {
            throw new ConfigException("Listener doesn't have the right format (protocol://hostname:port).");
        }
        String protocol = listenerMatcher.group(1).toLowerCase(Locale.ENGLISH);
        if (!PROTOCOL_HTTP.equals(protocol) && !PROTOCOL_HTTPS.equals(protocol)) {
            throw new ConfigException(String.format("Listener protocol must be either \"%s\" or \"%s\".", PROTOCOL_HTTP, PROTOCOL_HTTPS));
        }
        String hostname = listenerMatcher.group(2);
        int port = Integer.parseInt(listenerMatcher.group(3));
        if (PROTOCOL_HTTPS.equals(protocol)) {
            SslContextFactory ssl = isAdmin ? SSLUtils.createServerSideSslContextFactory(this.config, "admin.listeners.https.") : SSLUtils.createServerSideSslContextFactory(this.config);
            connector = new ServerConnector(this.jettyServer, ssl);
            if (!isAdmin) {
                connector.setName(String.format("%s_%s%d", PROTOCOL_HTTPS, hostname, port));
            }
        } else {
            connector = new ServerConnector(this.jettyServer);
            if (!isAdmin) {
                connector.setName(String.format("%s_%s%d", PROTOCOL_HTTP, hostname, port));
            }
        }
        if (isAdmin) {
            connector.setName(ADMIN_SERVER_CONNECTOR_NAME);
        }
        if (!hostname.isEmpty()) {
            connector.setHost(hostname);
        }
        connector.setPort(port);
        return connector;
    }

    public void initializeServer() {
        log.info("Initializing REST server");
        StatisticsHandler statsHandler = new StatisticsHandler();
        statsHandler.setHandler((Handler)this.handlers);
        this.jettyServer.setHandler((Handler)statsHandler);
        this.jettyServer.setStopTimeout(60000L);
        this.jettyServer.setStopAtShutdown(true);
        try {
            this.jettyServer.start();
        }
        catch (Exception e) {
            throw new ConnectException("Unable to initialize REST server", (Throwable)e);
        }
        log.info("REST server listening at " + this.jettyServer.getURI() + ", advertising URL " + this.advertisedUrl());
        log.info("REST admin endpoints at " + this.adminUrl());
    }

    public void initializeResources(Herder herder) {
        String headerConfig;
        String allowedOrigins;
        ResourceConfig adminResourceConfig;
        log.info("Initializing REST resources");
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register((Object)new JacksonJsonProvider());
        resourceConfig.register((Object)new RootResource(herder));
        resourceConfig.register((Object)new ConnectorsResource(herder, this.config));
        resourceConfig.register((Object)new ConnectorPluginsResource(herder));
        resourceConfig.register((Object)new ConfluentV1MetadataResource(herder, this.config));
        resourceConfig.register(ConnectExceptionMapper.class);
        resourceConfig.property("jersey.config.server.wadl.disableWadl", (Object)true);
        this.registerRestExtensions(herder, resourceConfig);
        List adminListeners = this.config.getList("admin.listeners");
        if (adminListeners == null) {
            log.info("Adding admin resources to main listener");
            adminResourceConfig = resourceConfig;
            adminResourceConfig.register((Object)new LoggingResource());
        } else if (adminListeners.size() > 0) {
            log.info("Adding admin resources to admin listener");
            adminResourceConfig = new ResourceConfig();
            adminResourceConfig.register((Object)new JacksonJsonProvider());
            adminResourceConfig.register((Object)new LoggingResource());
            adminResourceConfig.register(ConnectExceptionMapper.class);
        } else {
            log.info("Skipping adding admin resources");
            adminResourceConfig = resourceConfig;
        }
        ServletContainer servletContainer = new ServletContainer(resourceConfig);
        ServletHolder servletHolder = new ServletHolder((Servlet)servletContainer);
        ArrayList<Object> contextHandlers = new ArrayList<Object>();
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.addServlet(servletHolder, "/*");
        contextHandlers.add(context);
        ServletContextHandler adminContext = null;
        if (adminResourceConfig != resourceConfig) {
            adminContext = new ServletContextHandler(1);
            ServletHolder adminServletHolder = new ServletHolder((Servlet)new ServletContainer(adminResourceConfig));
            adminContext.setContextPath("/");
            adminContext.addServlet(adminServletHolder, "/*");
            adminContext.setVirtualHosts(new String[]{"@Admin"});
            contextHandlers.add(adminContext);
        }
        if ((allowedOrigins = this.config.getString("access.control.allow.origin")) != null && !allowedOrigins.trim().isEmpty()) {
            FilterHolder filterHolder = new FilterHolder((Filter)new CrossOriginFilter());
            filterHolder.setName("cross-origin");
            filterHolder.setInitParameter("allowedOrigins", allowedOrigins);
            String allowedMethods = this.config.getString("access.control.allow.methods");
            if (allowedMethods != null && !allowedOrigins.trim().isEmpty()) {
                filterHolder.setInitParameter("allowedMethods", allowedMethods);
            }
            context.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        }
        if ((headerConfig = this.config.getString("response.http.headers.config")) != null && !headerConfig.trim().isEmpty()) {
            this.configureHttpResponsHeaderFilter(context);
        }
        this.applyServletInitializers(context);
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        Slf4jRequestLogWriter slf4jRequestLogWriter = new Slf4jRequestLogWriter();
        slf4jRequestLogWriter.setLoggerName(RestServer.class.getCanonicalName());
        CustomRequestLog requestLog = new CustomRequestLog((RequestLog.Writer)slf4jRequestLogWriter, "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\" %msT");
        requestLogHandler.setRequestLog((RequestLog)requestLog);
        contextHandlers.add(new DefaultHandler());
        contextHandlers.add(requestLogHandler);
        this.handlers.setHandlers(contextHandlers.toArray(new Handler[0]));
        try {
            context.start();
        }
        catch (Exception e) {
            throw new ConnectException("Unable to initialize REST resources", (Throwable)e);
        }
        if (adminResourceConfig != resourceConfig) {
            try {
                log.debug("Starting admin context");
                adminContext.start();
            }
            catch (Exception e) {
                throw new ConnectException("Unable to initialize Admin REST resources", (Throwable)e);
            }
        }
        log.info("REST resources initialized; server is started and ready to handle requests");
    }

    public URI serverUrl() {
        return this.jettyServer.getURI();
    }

    public void stop() {
        log.info("Stopping REST server");
        try {
            for (ConnectRestExtension connectRestExtension : this.connectRestExtensions) {
                try {
                    connectRestExtension.close();
                }
                catch (IOException e) {
                    log.warn("Error while invoking close on " + connectRestExtension.getClass(), (Throwable)e);
                }
            }
            this.jettyServer.stop();
            this.jettyServer.join();
        }
        catch (Exception e) {
            this.jettyServer.destroy();
            throw new ConnectException("Unable to stop REST server", (Throwable)e);
        }
        log.info("REST server stopped");
    }

    public URI advertisedUrl() {
        UriBuilder builder = UriBuilder.fromUri((URI)this.jettyServer.getURI());
        String advertisedSecurityProtocol = this.determineAdvertisedProtocol();
        ServerConnector serverConnector = this.findConnector(advertisedSecurityProtocol);
        builder.scheme(advertisedSecurityProtocol);
        String advertisedHostname = this.config.getString("rest.advertised.host.name");
        if (advertisedHostname != null && !advertisedHostname.isEmpty()) {
            builder.host(advertisedHostname);
        } else if (serverConnector != null && serverConnector.getHost() != null && serverConnector.getHost().length() > 0) {
            builder.host(serverConnector.getHost());
        }
        Integer advertisedPort = this.config.getInt("rest.advertised.port");
        if (advertisedPort != null) {
            builder.port(advertisedPort.intValue());
        } else if (serverConnector != null && serverConnector.getPort() > 0) {
            builder.port(serverConnector.getPort());
        }
        log.info("Advertised URI: {}", (Object)builder.build(new Object[0]));
        return builder.build(new Object[0]);
    }

    public URI adminUrl() {
        ServerConnector adminConnector = null;
        for (Connector connector : this.jettyServer.getConnectors()) {
            if (!ADMIN_SERVER_CONNECTOR_NAME.equals(connector.getName())) continue;
            adminConnector = (ServerConnector)connector;
        }
        if (adminConnector == null) {
            List adminListeners = this.config.getList("admin.listeners");
            if (adminListeners == null) {
                return this.advertisedUrl();
            }
            if (adminListeners.isEmpty()) {
                return null;
            }
            log.error("No admin connector found for listeners {}", (Object)adminListeners);
            return null;
        }
        UriBuilder builder = UriBuilder.fromUri((URI)this.jettyServer.getURI());
        builder.port(adminConnector.getLocalPort());
        return builder.build(new Object[0]);
    }

    String determineAdvertisedProtocol() {
        String advertisedSecurityProtocol = this.config.getString("rest.advertised.listener");
        if (advertisedSecurityProtocol == null) {
            String listeners = (String)this.config.originals().get("listeners");
            if (listeners == null) {
                return PROTOCOL_HTTP;
            }
            listeners = listeners.toLowerCase(Locale.ENGLISH);
            if (listeners.contains(String.format("%s://", PROTOCOL_HTTP))) {
                return PROTOCOL_HTTP;
            }
            if (listeners.contains(String.format("%s://", PROTOCOL_HTTPS))) {
                return PROTOCOL_HTTPS;
            }
            return PROTOCOL_HTTP;
        }
        return advertisedSecurityProtocol.toLowerCase(Locale.ENGLISH);
    }

    ServerConnector findConnector(String protocol) {
        for (Connector connector : this.jettyServer.getConnectors()) {
            String connectorName = connector.getName();
            if (!connectorName.startsWith(protocol + "_") || ADMIN_SERVER_CONNECTOR_NAME.equals(connectorName)) continue;
            return (ServerConnector)connector;
        }
        return null;
    }

    void registerRestExtensions(Herder herder, ResourceConfig resourceConfig) {
        this.connectRestExtensions = herder.plugins().newPlugins(this.config.getList("rest.extension.classes"), this.config, ConnectRestExtension.class);
        long herderRequestTimeoutMs = 90000L;
        Integer rebalanceTimeoutMs = this.config.getRebalanceTimeout();
        if (rebalanceTimeoutMs != null) {
            herderRequestTimeoutMs = Math.min(herderRequestTimeoutMs, rebalanceTimeoutMs.longValue());
        }
        ConnectClusterDetailsImpl connectClusterDetails = new ConnectClusterDetailsImpl(herder.kafkaClusterId());
        ConnectRestExtensionContextImpl connectRestExtensionContext = new ConnectRestExtensionContextImpl(new ConnectRestConfigurable(resourceConfig), new ConnectClusterStateImpl(herderRequestTimeoutMs, connectClusterDetails, herder));
        for (ConnectRestExtension connectRestExtension : this.connectRestExtensions) {
            connectRestExtension.register((ConnectRestExtensionContext)connectRestExtensionContext);
        }
    }

    public static String urlJoin(String base, String path) {
        if (base.endsWith("/") && path.startsWith("/")) {
            return base + path.substring(1);
        }
        return base + path;
    }

    private void applyServletInitializers(ServletContextHandler context) {
        List servletInitializers = this.config.getConfiguredInstances("rest.servlet.initializor.classes", Consumer.class);
        for (Consumer servletInitializer : servletInitializers) {
            log.info("Creating rest initializer {}", (Object)servletInitializer);
            try {
                servletInitializer.accept(context);
            }
            catch (Throwable e) {
                throw new ConfigException("Exception from custom servlet initializer " + servletInitializer.getClass().getName(), (Object)e);
            }
        }
    }

    protected void configureHttpResponsHeaderFilter(ServletContextHandler context) {
        String headerConfig = this.config.getString("response.http.headers.config");
        FilterHolder headerFilterHolder = new FilterHolder(HeaderFilter.class);
        headerFilterHolder.setInitParameter("headerConfig", headerConfig);
        context.addFilter(headerFilterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
    }
}

