/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import io.confluent.logevents.connect.LogEvents;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigTransformer;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import org.apache.kafka.connect.connector.policy.ConnectorClientConfigRequest;
import org.apache.kafka.connect.errors.NotFoundException;
import org.apache.kafka.connect.runtime.AbstractStatus;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.ConnectorStatus;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.RestartPlan;
import org.apache.kafka.connect.runtime.RestartRequest;
import org.apache.kafka.connect.runtime.SinkConnectorConfig;
import org.apache.kafka.connect.runtime.SourceConnectorConfig;
import org.apache.kafka.connect.runtime.TargetState;
import org.apache.kafka.connect.runtime.TaskStatus;
import org.apache.kafka.connect.runtime.TopicStatus;
import org.apache.kafka.connect.runtime.Worker;
import org.apache.kafka.connect.runtime.distributed.ClusterConfigState;
import org.apache.kafka.connect.runtime.isolation.PluginType;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.runtime.rest.entities.ActiveTopicsInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConfigInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConfigInfos;
import org.apache.kafka.connect.runtime.rest.entities.ConfigKeyInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConfigValueInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorStateInfo;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorType;
import org.apache.kafka.connect.runtime.rest.errors.BadRequestException;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.storage.ConfigBackingStore;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.ConverterType;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.apache.kafka.connect.storage.StatusBackingStore;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.predicates.Predicate;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHerder
implements Herder,
TaskStatus.Listener,
ConnectorStatus.Listener {
    private static final Logger log = LoggerFactory.getLogger(AbstractHerder.class);
    private final String workerId;
    protected final Worker worker;
    private final String kafkaClusterId;
    protected final StatusBackingStore statusBackingStore;
    protected final ConfigBackingStore configBackingStore;
    private final ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy;
    protected volatile boolean running = false;
    private final ExecutorService connectorExecutor;
    private final ConcurrentMap<String, Connector> tempConnectors = new ConcurrentHashMap<String, Connector>();

    public AbstractHerder(Worker worker, String workerId, String kafkaClusterId, StatusBackingStore statusBackingStore, ConfigBackingStore configBackingStore, ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy) {
        this.worker = worker;
        this.worker.herder = this;
        this.workerId = workerId;
        this.kafkaClusterId = kafkaClusterId;
        this.statusBackingStore = statusBackingStore;
        this.configBackingStore = configBackingStore;
        this.connectorClientConfigOverridePolicy = connectorClientConfigOverridePolicy;
        this.connectorExecutor = Executors.newCachedThreadPool();
    }

    @Override
    public String kafkaClusterId() {
        return this.kafkaClusterId;
    }

    protected abstract int generation();

    protected void startServices() {
        this.worker.start();
        this.statusBackingStore.start();
        this.configBackingStore.start();
    }

    protected void stopServices() {
        this.statusBackingStore.stop();
        this.configBackingStore.stop();
        this.worker.stop();
        this.connectorExecutor.shutdown();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public void onStartup(String connector) {
        this.statusBackingStore.put(new ConnectorStatus(connector, AbstractStatus.State.RUNNING, this.workerId, this.generation()));
    }

    @Override
    public void onPause(String connector) {
        this.statusBackingStore.put(new ConnectorStatus(connector, AbstractStatus.State.PAUSED, this.workerId, this.generation()));
    }

    @Override
    public void onResume(String connector) {
        this.statusBackingStore.put(new ConnectorStatus(connector, AbstractStatus.State.RUNNING, this.workerId, this.generation()));
    }

    @Override
    public void onShutdown(String connector) {
        this.statusBackingStore.putSafe(new ConnectorStatus(connector, AbstractStatus.State.UNASSIGNED, this.workerId, this.generation()));
    }

    @Override
    public void onFailure(String connector, Throwable cause) {
        LogEvents.connectorFailedEvent(this.worker::logEventsEmitter, (String)connector, (Throwable)cause);
        this.statusBackingStore.putSafe(new ConnectorStatus(connector, AbstractStatus.State.FAILED, this.trace(cause), this.workerId, this.generation()));
    }

    @Override
    public void onStartup(ConnectorTaskId id) {
        this.statusBackingStore.put(new TaskStatus(id, AbstractStatus.State.RUNNING, this.workerId, this.generation()));
    }

    @Override
    public void onFailure(ConnectorTaskId id, Throwable cause) {
        LogEvents.connectorTaskFailedEvent(this.worker::logEventsEmitter, (String)id.connector(), (String)id.toString(), (Throwable)cause);
        this.statusBackingStore.putSafe(new TaskStatus(id, AbstractStatus.State.FAILED, this.workerId, this.generation(), this.trace(cause)));
    }

    @Override
    public void onShutdown(ConnectorTaskId id) {
        this.statusBackingStore.putSafe(new TaskStatus(id, AbstractStatus.State.UNASSIGNED, this.workerId, this.generation()));
    }

    @Override
    public void onResume(ConnectorTaskId id) {
        this.statusBackingStore.put(new TaskStatus(id, AbstractStatus.State.RUNNING, this.workerId, this.generation()));
    }

    @Override
    public void onPause(ConnectorTaskId id) {
        this.statusBackingStore.put(new TaskStatus(id, AbstractStatus.State.PAUSED, this.workerId, this.generation()));
    }

    @Override
    public void onDeletion(String connector) {
        for (TaskStatus status : this.statusBackingStore.getAll(connector)) {
            this.onDeletion((ConnectorTaskId)status.id());
        }
        this.statusBackingStore.put(new ConnectorStatus(connector, AbstractStatus.State.DESTROYED, this.workerId, this.generation()));
    }

    @Override
    public void onDeletion(ConnectorTaskId id) {
        this.statusBackingStore.put(new TaskStatus(id, AbstractStatus.State.DESTROYED, this.workerId, this.generation()));
    }

    @Override
    public void onRestart(String connector) {
        this.statusBackingStore.put(new ConnectorStatus(connector, AbstractStatus.State.RESTARTING, this.workerId, this.generation()));
    }

    @Override
    public void onRestart(ConnectorTaskId id) {
        this.statusBackingStore.put(new TaskStatus(id, AbstractStatus.State.RESTARTING, this.workerId, this.generation()));
    }

    @Override
    public void pauseConnector(String connector) {
        if (!this.configBackingStore.contains(connector)) {
            throw new NotFoundException("Unknown connector " + connector);
        }
        this.configBackingStore.putTargetState(connector, TargetState.PAUSED);
    }

    @Override
    public void resumeConnector(String connector) {
        if (!this.configBackingStore.contains(connector)) {
            throw new NotFoundException("Unknown connector " + connector);
        }
        this.configBackingStore.putTargetState(connector, TargetState.STARTED);
    }

    @Override
    public Plugins plugins() {
        return this.worker.getPlugins();
    }

    protected abstract Map<String, String> rawConfig(String var1);

    @Override
    public void connectorConfig(String connName, Callback<Map<String, String>> callback) {
        this.connectorInfo(connName, (error, result) -> {
            if (error != null) {
                callback.onCompletion(error, null);
            } else {
                callback.onCompletion(null, result.config());
            }
        });
    }

    @Override
    public Collection<String> connectors() {
        return this.configBackingStore.snapshot().connectors();
    }

    @Override
    public ConnectorInfo connectorInfo(String connector) {
        ClusterConfigState configState = this.configBackingStore.snapshot();
        if (!configState.contains(connector)) {
            return null;
        }
        Map<String, String> config = configState.rawConnectorConfig(connector);
        return new ConnectorInfo(connector, config, configState.tasks(connector), this.connectorTypeForClass(config.get("connector.class")));
    }

    protected Map<ConnectorTaskId, Map<String, String>> buildTasksConfig(String connector) {
        ClusterConfigState configState = this.configBackingStore.snapshot();
        if (!configState.contains(connector)) {
            return Collections.emptyMap();
        }
        HashMap<ConnectorTaskId, Map<String, String>> configs = new HashMap<ConnectorTaskId, Map<String, String>>();
        for (ConnectorTaskId cti : configState.tasks(connector)) {
            configs.put(cti, configState.taskConfig(cti));
        }
        return configs;
    }

    @Override
    public ConnectorStateInfo connectorStatus(String connName) {
        ConnectorStatus connector = this.statusBackingStore.get(connName);
        if (connector == null) {
            throw new NotFoundException("No status found for connector " + connName);
        }
        Collection<TaskStatus> tasks = this.statusBackingStore.getAll(connName);
        ConnectorStateInfo.ConnectorState connectorState = new ConnectorStateInfo.ConnectorState(connector.state().toString(), connector.workerId(), connector.trace());
        ArrayList<ConnectorStateInfo.TaskState> taskStates = new ArrayList<ConnectorStateInfo.TaskState>();
        for (TaskStatus status : tasks) {
            taskStates.add(new ConnectorStateInfo.TaskState(((ConnectorTaskId)status.id()).task(), status.state().toString(), status.workerId(), status.trace()));
        }
        Collections.sort(taskStates);
        Map<String, String> conf = this.rawConfig(connName);
        return new ConnectorStateInfo(connName, connectorState, taskStates, conf == null ? ConnectorType.UNKNOWN : this.connectorTypeForClass(conf.get("connector.class")));
    }

    @Override
    public ActiveTopicsInfo connectorActiveTopics(String connName) {
        Collection topics = this.statusBackingStore.getAllTopics(connName).stream().map(TopicStatus::topic).collect(Collectors.toList());
        return new ActiveTopicsInfo(connName, topics);
    }

    @Override
    public void resetConnectorActiveTopics(String connName) {
        this.statusBackingStore.getAllTopics(connName).stream().forEach(status -> this.statusBackingStore.deleteTopic(status.connector(), status.topic()));
    }

    @Override
    public StatusBackingStore statusBackingStore() {
        return this.statusBackingStore;
    }

    @Override
    public ConnectorStateInfo.TaskState taskStatus(ConnectorTaskId id) {
        TaskStatus status = this.statusBackingStore.get(id);
        if (status == null) {
            throw new NotFoundException("No status found for task " + id);
        }
        return new ConnectorStateInfo.TaskState(id.task(), status.state().toString(), status.workerId(), status.trace());
    }

    protected Map<String, ConfigValue> validateSinkConnectorConfig(ConfigDef configDef, Map<String, String> config) {
        return SinkConnectorConfig.validate(configDef.validateAll(config), config);
    }

    protected Map<String, ConfigValue> validateSourceConnectorConfig(ConfigDef configDef, Map<String, String> config) {
        return configDef.validateAll(config);
    }

    private ConfigInfos validateHeaderConverterConfig(Map<String, String> connectorConfig, ConfigValue headerConverterConfigValue) {
        List configValues;
        ConfigDef configDef;
        HeaderConverter headerConverter;
        String headerConverterClass = connectorConfig.get("header.converter");
        if (headerConverterClass == null || headerConverterConfigValue == null || !headerConverterConfigValue.errorMessages().isEmpty()) {
            return null;
        }
        try {
            headerConverter = (HeaderConverter)Utils.newInstance((String)headerConverterClass, HeaderConverter.class);
        }
        catch (ClassNotFoundException | RuntimeException e2) {
            log.error("Failed to instantiate header converter class {}; this should have been caught by prior validation logic", (Object)headerConverterClass, (Object)e2);
            headerConverterConfigValue.addErrorMessage("Failed to load class " + headerConverterClass + (e2.getMessage() != null ? ": " + e2.getMessage() : ""));
            return null;
        }
        try {
            configDef = headerConverter.config();
        }
        catch (RuntimeException e3) {
            log.error("Failed to load ConfigDef from header converter of type {}", (Object)headerConverterClass, (Object)e3);
            headerConverterConfigValue.addErrorMessage("Failed to load ConfigDef from header converter" + (e3.getMessage() != null ? ": " + e3.getMessage() : ""));
            return null;
        }
        if (configDef == null) {
            log.warn("{}.config() has returned a null ConfigDef; no further preflight config validation for this converter will be performed", (Object)headerConverterClass);
            return null;
        }
        String headerConverterPrefix = "header.converter.";
        Map<String, String> headerConverterConfig = connectorConfig.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("header.converter.")).collect(Collectors.toMap(e -> ((String)e.getKey()).substring("header.converter.".length()), Map.Entry::getValue));
        headerConverterConfig.put("converter.type", ConverterType.HEADER.getName());
        try {
            configValues = configDef.validate(headerConverterConfig);
        }
        catch (RuntimeException e4) {
            log.error("Failed to perform custom config validation for header converter of type {}", (Object)headerConverterClass, (Object)e4);
            headerConverterConfigValue.addErrorMessage("Failed to perform custom config validation for header converter" + (e4.getMessage() != null ? ": " + e4.getMessage() : ""));
            return null;
        }
        return AbstractHerder.prefixedConfigInfos(configDef.configKeys(), configValues, "header.converter.");
    }

    @Override
    public void validateConnectorConfig(Map<String, String> connectorProps, Callback<ConfigInfos> callback) {
        this.validateConnectorConfig(connectorProps, callback, true);
    }

    @Override
    public void validateConnectorConfig(Map<String, String> connectorProps, Callback<ConfigInfos> callback, boolean doLog) {
        this.connectorExecutor.submit(() -> {
            try {
                ConfigInfos result = this.validateConnectorConfig(connectorProps, doLog);
                callback.onCompletion(null, result);
            }
            catch (Throwable t) {
                callback.onCompletion(t, null);
            }
        });
    }

    public Optional<RestartPlan> buildRestartPlan(RestartRequest request) {
        String connectorName = request.connectorName();
        ConnectorStatus connectorStatus = this.statusBackingStore.get(connectorName);
        if (connectorStatus == null) {
            return Optional.empty();
        }
        AbstractStatus.State connectorState = request.shouldRestartConnector(connectorStatus) ? AbstractStatus.State.RESTARTING : connectorStatus.state();
        ConnectorStateInfo.ConnectorState connectorInfoState = new ConnectorStateInfo.ConnectorState(connectorState.toString(), connectorStatus.workerId(), connectorStatus.trace());
        List<ConnectorStateInfo.TaskState> taskStates = this.statusBackingStore.getAll(connectorName).stream().map(taskStatus -> {
            AbstractStatus.State taskState = request.shouldRestartTask((TaskStatus)taskStatus) ? AbstractStatus.State.RESTARTING : taskStatus.state();
            return new ConnectorStateInfo.TaskState(((ConnectorTaskId)taskStatus.id()).task(), taskState.toString(), taskStatus.workerId(), taskStatus.trace());
        }).collect(Collectors.toList());
        Map<String, String> conf = this.rawConfig(connectorName);
        ConnectorStateInfo stateInfo = new ConnectorStateInfo(connectorName, connectorInfoState, taskStates, conf == null ? ConnectorType.UNKNOWN : this.connectorTypeForClass(conf.get("connector.class")));
        return Optional.of(new RestartPlan(request, stateInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConfigInfos validateConnectorConfig(Map<String, String> connectorProps, boolean doLog) {
        String connType;
        if (this.worker.configTransformer() != null) {
            connectorProps = this.worker.configTransformer().transform(connectorProps);
        }
        if ((connType = connectorProps.get("connector.class")) == null) {
            throw new BadRequestException("Connector config " + connectorProps + " contains no connector type");
        }
        Connector connector = this.getConnector(connType);
        ClassLoader savedLoader = this.plugins().compareAndSwapLoaders(connector);
        try {
            Map<String, ConfigValue> validatedConnectorConfig;
            ConfigDef enrichedConfigDef;
            org.apache.kafka.connect.health.ConnectorType connectorType;
            if (connector instanceof SourceConnector) {
                connectorType = org.apache.kafka.connect.health.ConnectorType.SOURCE;
                enrichedConfigDef = ConnectorConfig.enrich(this.plugins(), SourceConnectorConfig.configDef(), connectorProps, false);
                validatedConnectorConfig = this.validateSourceConnectorConfig(enrichedConfigDef, connectorProps);
            } else {
                connectorType = org.apache.kafka.connect.health.ConnectorType.SINK;
                enrichedConfigDef = ConnectorConfig.enrich(this.plugins(), SinkConnectorConfig.configDef(), connectorProps, false);
                validatedConnectorConfig = this.validateSinkConnectorConfig(enrichedConfigDef, connectorProps);
            }
            connectorProps.entrySet().stream().filter(e -> e.getValue() == null).map(Map.Entry::getKey).forEach(prop -> validatedConnectorConfig.computeIfAbsent((String)prop, ConfigValue::new).addErrorMessage("Null value can not be supplied as the configuration value."));
            ArrayList<ConfigValue> configValues = new ArrayList<ConfigValue>(validatedConnectorConfig.values());
            LinkedHashMap<String, ConfigDef.ConfigKey> configKeys = new LinkedHashMap<String, ConfigDef.ConfigKey>(enrichedConfigDef.configKeys());
            LinkedHashSet allGroups = new LinkedHashSet(enrichedConfigDef.groups());
            ConfigDef configDef = connector.config();
            if (null == configDef) {
                throw new BadRequestException(String.format("%s.config() must return a ConfigDef that is not null.", connector.getClass().getName()));
            }
            String connName = connectorProps.get("name");
            Map<String, String> decoratedConnectorProps = this.worker.configDecorator().decorateConnectorConfig(connName, connector, configDef, connectorProps);
            Config config = connector.validate(decoratedConnectorProps);
            if (null == config) {
                throw new BadRequestException(String.format("%s.validate() must return a Config that is not null.", connector.getClass().getName()));
            }
            configKeys.putAll(configDef.configKeys());
            allGroups.addAll(configDef.groups());
            configValues.addAll(config.configValues());
            ConfigInfos headerConverterConfigInfos = this.validateHeaderConverterConfig(connectorProps, validatedConnectorConfig.get("header.converter"));
            ConfigInfos configInfos = AbstractHerder.generateResult(connType, configKeys, configValues, new ArrayList<String>(allGroups));
            configInfos = this.worker.configDecorator().decorateValidationResult(connName, connector, configDef, connectorProps, configInfos);
            AbstractConfig connectorConfig = new AbstractConfig(new ConfigDef(), connectorProps, doLog);
            ConfigInfos producerConfigInfos = null;
            ConfigInfos consumerConfigInfos = null;
            ConfigInfos adminConfigInfos = null;
            if (connectorType.equals((Object)org.apache.kafka.connect.health.ConnectorType.SOURCE)) {
                producerConfigInfos = AbstractHerder.validateClientOverrides(connName, "producer.override.", connectorConfig, ProducerConfig.configDef(), connector.getClass(), connectorType, ConnectorClientConfigRequest.ClientType.PRODUCER, this.connectorClientConfigOverridePolicy);
                ConfigInfos configInfos2 = AbstractHerder.mergeConfigInfos(connType, configInfos, producerConfigInfos);
                return configInfos2;
            }
            consumerConfigInfos = AbstractHerder.validateClientOverrides(connName, "consumer.override.", connectorConfig, ProducerConfig.configDef(), connector.getClass(), connectorType, ConnectorClientConfigRequest.ClientType.CONSUMER, this.connectorClientConfigOverridePolicy);
            String topic = connectorProps.get("errors.deadletterqueue.topic.name");
            if (topic != null && !topic.isEmpty()) {
                adminConfigInfos = AbstractHerder.validateClientOverrides(connName, "admin.override.", connectorConfig, ProducerConfig.configDef(), connector.getClass(), connectorType, ConnectorClientConfigRequest.ClientType.ADMIN, this.connectorClientConfigOverridePolicy);
            }
            ConfigInfos configInfos3 = AbstractHerder.mergeConfigInfos(connType, configInfos, consumerConfigInfos, adminConfigInfos, headerConverterConfigInfos);
            return configInfos3;
        }
        finally {
            Plugins.compareAndSwapLoaders(savedLoader);
        }
    }

    private static ConfigInfos mergeConfigInfos(String connType, ConfigInfos ... configInfosList) {
        int errorCount = 0;
        LinkedList<ConfigInfo> configInfoList = new LinkedList<ConfigInfo>();
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        for (ConfigInfos configInfos : configInfosList) {
            if (configInfos == null) continue;
            errorCount += configInfos.errorCount();
            configInfoList.addAll(configInfos.values());
            groups.addAll(configInfos.groups());
        }
        return new ConfigInfos(connType, errorCount, new ArrayList<String>(groups), configInfoList);
    }

    private static ConfigInfos validateClientOverrides(String connName, String prefix, AbstractConfig connectorConfig, ConfigDef configDef, Class<? extends Connector> connectorClass, org.apache.kafka.connect.health.ConnectorType connectorType, ConnectorClientConfigRequest.ClientType clientType, ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy) {
        HashMap clientConfigs = new HashMap();
        for (Map.Entry rawClientConfig : connectorConfig.originalsWithPrefix(prefix).entrySet()) {
            String configName = (String)rawClientConfig.getKey();
            Object rawConfigValue = rawClientConfig.getValue();
            ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configDef.configKeys().get(configName);
            Object parsedConfigValue = configKey != null ? ConfigDef.parseType((String)configName, rawConfigValue, (ConfigDef.Type)configKey.type) : rawConfigValue;
            clientConfigs.put(configName, parsedConfigValue);
        }
        ConnectorClientConfigRequest connectorClientConfigRequest = new ConnectorClientConfigRequest(connName, connectorType, connectorClass, clientConfigs, clientType);
        List configValues = connectorClientConfigOverridePolicy.validate(connectorClientConfigRequest);
        return AbstractHerder.prefixedConfigInfos(configDef.configKeys(), configValues, prefix);
    }

    private static ConfigInfos prefixedConfigInfos(Map<String, ConfigDef.ConfigKey> configKeys, List<ConfigValue> configValues, String prefix) {
        int errorCount = 0;
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        ArrayList<ConfigInfo> configInfos = new ArrayList<ConfigInfo>();
        if (configValues == null) {
            return new ConfigInfos("", errorCount, new ArrayList<String>(groups), configInfos);
        }
        for (ConfigValue validatedConfigValue : configValues) {
            ConfigValue configValue;
            ConfigDef.ConfigKey configKey = configKeys.get(validatedConfigValue.name());
            ConfigKeyInfo configKeyInfo = null;
            if (configKey != null) {
                if (configKey.group != null) {
                    groups.add(configKey.group);
                }
                configKeyInfo = AbstractHerder.convertConfigKey(configKey, prefix);
            }
            if ((configValue = new ConfigValue(prefix + validatedConfigValue.name(), validatedConfigValue.value(), validatedConfigValue.recommendedValues(), validatedConfigValue.errorMessages())).errorMessages().size() > 0) {
                ++errorCount;
            }
            ConfigValueInfo configValueInfo = AbstractHerder.convertConfigValue(configValue, configKey != null ? configKey.type : null);
            configInfos.add(new ConfigInfo(configKeyInfo, configValueInfo));
        }
        return new ConfigInfos("", errorCount, new ArrayList<String>(groups), configInfos);
    }

    public static ConfigInfos generateResult(String connType, Map<String, ConfigDef.ConfigKey> configKeys, List<ConfigValue> configValues, List<String> groups) {
        String configName;
        int errorCount = 0;
        LinkedList<ConfigInfo> configInfoList = new LinkedList<ConfigInfo>();
        HashMap<String, ConfigValue> configValueMap = new HashMap<String, ConfigValue>();
        for (ConfigValue configValue : configValues) {
            configName = configValue.name();
            configValueMap.put(configName, configValue);
            if (configKeys.containsKey(configName)) continue;
            configInfoList.add(new ConfigInfo(null, AbstractHerder.convertConfigValue(configValue, null)));
            errorCount += configValue.errorMessages().size();
        }
        for (Map.Entry entry : configKeys.entrySet()) {
            configName = (String)entry.getKey();
            ConfigKeyInfo configKeyInfo = AbstractHerder.convertConfigKey((ConfigDef.ConfigKey)entry.getValue());
            ConfigDef.Type type = ((ConfigDef.ConfigKey)entry.getValue()).type;
            ConfigValueInfo configValueInfo = null;
            if (configValueMap.containsKey(configName)) {
                ConfigValue configValue = (ConfigValue)configValueMap.get(configName);
                configValueInfo = AbstractHerder.convertConfigValue(configValue, type);
                errorCount += configValue.errorMessages().size();
            }
            configInfoList.add(new ConfigInfo(configKeyInfo, configValueInfo));
        }
        return new ConfigInfos(connType, errorCount, groups, configInfoList);
    }

    public static ConfigKeyInfo convertConfigKey(ConfigDef.ConfigKey configKey) {
        return AbstractHerder.convertConfigKey(configKey, "");
    }

    private static ConfigKeyInfo convertConfigKey(ConfigDef.ConfigKey configKey, String prefix) {
        String defaultValue;
        String name = prefix + configKey.name;
        ConfigDef.Type type = configKey.type;
        String typeName = configKey.type.name();
        boolean required = false;
        if (ConfigDef.NO_DEFAULT_VALUE.equals(configKey.defaultValue)) {
            defaultValue = null;
            required = true;
        } else {
            defaultValue = ConfigDef.convertToString((Object)configKey.defaultValue, (ConfigDef.Type)type);
        }
        String importance = configKey.importance.name();
        String documentation = configKey.documentation;
        String group = configKey.group;
        int orderInGroup = configKey.orderInGroup;
        String width = configKey.width.name();
        String displayName = configKey.displayName;
        List dependents = configKey.dependents;
        return new ConfigKeyInfo(name, typeName, required, defaultValue, importance, documentation, group, orderInGroup, width, displayName, dependents);
    }

    private static ConfigValueInfo convertConfigValue(ConfigValue configValue, ConfigDef.Type type) {
        String value = configValue.value() instanceof String ? (String)configValue.value() : ConfigDef.convertToString((Object)configValue.value(), (ConfigDef.Type)type);
        LinkedList<String> recommendedValues = new LinkedList<String>();
        if (type == ConfigDef.Type.LIST) {
            for (Object object : configValue.recommendedValues()) {
                recommendedValues.add(ConfigDef.convertToString(object, (ConfigDef.Type)ConfigDef.Type.STRING));
            }
        } else {
            for (Object object : configValue.recommendedValues()) {
                recommendedValues.add(ConfigDef.convertToString(object, (ConfigDef.Type)type));
            }
        }
        return new ConfigValueInfo(configValue.name(), value, recommendedValues, configValue.errorMessages(), configValue.visible());
    }

    protected Connector getConnector(String connType) {
        return this.tempConnectors.computeIfAbsent(connType, k -> this.plugins().newConnector((String)k));
    }

    public ConnectorType connectorTypeForClass(String connClass) {
        return ConnectorType.from(this.getConnector(connClass).getClass());
    }

    protected final boolean maybeAddConfigErrors(ConfigInfos configInfos, Callback<Herder.Created<ConnectorInfo>> callback) {
        boolean hasErrors;
        int errors = configInfos.errorCount();
        boolean bl = hasErrors = errors > 0;
        if (hasErrors) {
            StringBuilder messages = new StringBuilder();
            messages.append("Connector configuration is invalid and contains the following ").append(errors).append(" error(s):");
            for (ConfigInfo configInfo : configInfos.values()) {
                for (String msg : configInfo.configValue().errors()) {
                    messages.append('\n').append(msg);
                }
            }
            callback.onCompletion((Throwable)((Object)new BadRequestException(messages.append("\nYou can also find the above list of errors at the endpoint `/connector-plugins/{connectorType}/config/validate`").toString())), null);
        }
        return hasErrors;
    }

    private String trace(Throwable t) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            t.printStackTrace(new PrintStream((OutputStream)output, false, StandardCharsets.UTF_8.name()));
            return output.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static List<Map<String, String>> reverseTransform(String connName, ClusterConfigState configState, List<Map<String, String>> configs) {
        Map<String, String> rawConnConfig = configState.rawConnectorConfig(connName);
        Set<String> connKeysWithVariableValues = AbstractHerder.keysWithVariableValues(rawConnConfig, ConfigTransformer.DEFAULT_PATTERN);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (Map<String, String> config : configs) {
            HashMap<String, String> newConfig = new HashMap<String, String>(config);
            for (String key : connKeysWithVariableValues) {
                if (!newConfig.containsKey(key)) continue;
                newConfig.put(key, rawConnConfig.get(key));
            }
            result.add(newConfig);
        }
        return result;
    }

    static Set<String> keysWithVariableValues(Map<String, String> rawConfig, Pattern pattern) {
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<String, String> config : rawConfig.entrySet()) {
            Matcher matcher;
            if (config.getValue() == null || !(matcher = pattern.matcher(config.getValue())).find()) continue;
            keys.add(config.getKey());
        }
        return keys;
    }

    @Override
    public List<ConfigKeyInfo> connectorPluginConfig(String pluginName) {
        ConfigDef configDefs;
        ArrayList<ConfigKeyInfo> results = new ArrayList<ConfigKeyInfo>();
        try {
            Plugins p = this.plugins();
            Object plugin = p.newPlugin(pluginName);
            PluginType pluginType = PluginType.from(plugin.getClass());
            switch (pluginType) {
                case SINK: 
                case SOURCE: {
                    configDefs = ((Connector)plugin).config();
                    break;
                }
                case CONVERTER: {
                    configDefs = ((Converter)plugin).config();
                    break;
                }
                case HEADER_CONVERTER: {
                    configDefs = ((HeaderConverter)plugin).config();
                    break;
                }
                case TRANSFORMATION: {
                    configDefs = ((Transformation)plugin).config();
                    break;
                }
                case PREDICATE: {
                    configDefs = ((Predicate)plugin).config();
                    break;
                }
                default: {
                    throw new BadRequestException("Invalid plugin type " + (Object)((Object)pluginType) + ". Valid types are sink, source, converter, header_converter, transformation, predicate.");
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new NotFoundException("Unknown plugin " + pluginName + ".");
        }
        for (ConfigDef.ConfigKey configKey : configDefs.configKeys().values()) {
            results.add(AbstractHerder.convertConfigKey(configKey));
        }
        return results;
    }
}

