/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.tracing;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.json.JsonConverter;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.TransformationStage;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.runtime.tracing.TraceRecord;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.HeaderConverter;
import org.apache.kafka.connect.storage.SimpleHeaderConverter;
import org.slf4j.Logger;

@Confluent
public class TracerConfig
extends AbstractConfig {
    public static final String TRACE_PREFIX = "trace.records.";
    public static final String ENABLE_CONFIG = "trace.records.enable";
    public static final String ENABLE_DOC = "The configuration if true will enable tracing mode in a connector";
    public static final boolean ENABLE_DEFAULT = false;
    public static final String TOPIC_CONFIG = "trace.records.topic";
    public static final String TOPIC_DOC = "The topic where trace information will be send to";
    public static final String TOPIC_DEFAULT = "connect-traces";
    public static final String TOPIC_PARTITION_CONFIG = "trace.records.topic.partition";
    public static final String TOPIC_PARTITION_DOC = "Partition for trace topic";
    public static final Integer TOPIC_PARTITION_DEFAULT = 1;
    public static final String TOPIC_REPLICATION_FACTOR = "trace.records.topic.replication.factor";
    public static final String TOPIC_REPLICATION_FACTOR_DOC = "Replication factor for the trace topic";
    public static final Short TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    public static final String TOPIC_CONFIGS_PREFIX = "trace.records.trace.topic.config.";
    public static final String KEY_CONVERTER_CONFIG = "trace.records.key.converter";
    public static final String KEY_CONVERTER_DOC = "Key converter used for trace topic";
    public static final Class KEY_CONVERTER_DEFAULT = JsonConverter.class;
    public static final String VALUE_CONVERTER_CONFIG = "trace.records.value.converter";
    public static final String VALUE_CONVERTER_DOC = "Value converter for trace topic";
    public static final Class VALUE_CONVERTER_DEFAULT = JsonConverter.class;
    public static final String HEADER_CONVERTER_CONFIG = "trace.records.header.converter";
    public static final String HEADER_CONVERTER_DOC = "Header converter for trace topic";
    public static final Class HEADER_CONVERTER_DEFAULT = SimpleHeaderConverter.class;
    public static final String TRACE_TRANSFORMS_CONFIG = "trace.records.transforms";
    public static final String TRACE_TRANSFORMS_CONFIG_DOC = "Transformations on the trace topic";
    public static final String TRACE_PREDICATES_CONFIG = "trace.records.predicates";
    public static final String TRACE_PREDICATES_CONFIG_DOC = "Predicates for transformations on the trace topic";
    private static final ConfigDef CONVERTER_CONFIG_DEF = new ConfigDef().define((ConfigDef.ConfigKey)ConnectorConfig.configDef().configKeys().get("key.converter")).define((ConfigDef.ConfigKey)ConnectorConfig.configDef().configKeys().get("value.converter")).define((ConfigDef.ConfigKey)ConnectorConfig.configDef().configKeys().get("header.converter"));
    private static final ConfigDef TRANSFORMS_CONFIG_DEF = new ConfigDef().define((ConfigDef.ConfigKey)ConnectorConfig.configDef().configKeys().get("transforms")).define((ConfigDef.ConfigKey)ConnectorConfig.configDef().configKeys().get("predicates"));
    private final Plugins plugins;
    private final Logger log;
    private final ConnectorConfig connectorConfig;
    private final Map<String, Object> traceConfigsWithDefaults;
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("trace.records.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, "The configuration if true will enable tracing mode in a connector").define("trace.records.topic", ConfigDef.Type.STRING, (Object)"connect-traces", ConfigDef.Importance.HIGH, "The topic where trace information will be send to").define("trace.records.topic.partition", ConfigDef.Type.INT, (Object)TOPIC_PARTITION_DEFAULT, ConfigDef.Importance.HIGH, "Partition for trace topic").define("trace.records.topic.replication.factor", ConfigDef.Type.SHORT, (Object)TOPIC_REPLICATION_FACTOR_DEFAULT, ConfigDef.Importance.LOW, "Replication factor for the trace topic").define("trace.records.key.converter", ConfigDef.Type.CLASS, (Object)KEY_CONVERTER_DEFAULT, ConfigDef.Importance.MEDIUM, "Key converter used for trace topic").define("trace.records.value.converter", ConfigDef.Type.CLASS, (Object)VALUE_CONVERTER_DEFAULT, ConfigDef.Importance.MEDIUM, "Value converter for trace topic").define("trace.records.header.converter", ConfigDef.Type.CLASS, (Object)HEADER_CONVERTER_DEFAULT, ConfigDef.Importance.MEDIUM, "Header converter for trace topic").define("trace.records.transforms", ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.LOW, "Transformations on the trace topic").define("trace.records.predicates", ConfigDef.Type.LIST, Collections.emptyList(), ConfigDef.Importance.LOW, "Predicates for transformations on the trace topic");
    public static final AbstractConfig DEFAULT_CONFIG = new AbstractConfig(CONFIG_DEF, CONFIG_DEF.defaultValues());

    public TracerConfig(Plugins plugins, ConnectorConfig connectorConfig) {
        super(CONFIG_DEF, connectorConfig.originals());
        this.plugins = plugins;
        this.connectorConfig = connectorConfig;
        this.traceConfigsWithDefaults = DEFAULT_CONFIG.originalsWithPrefix(TRACE_PREFIX);
        this.traceConfigsWithDefaults.putAll(this.originalsWithPrefix(TRACE_PREFIX));
        this.log = new LogContext("[" + connectorConfig.get("name") + "-tracer]").logger(TracerConfig.class);
    }

    public List<TransformationStage<TraceRecord>> traceTransformations() {
        this.log.debug("Constructing tracing transformation ");
        Map<String, String> transformAndPredicateConfigs = this.originalsWithPrefix(TRACE_PREFIX).entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("transforms") || ((String)e.getKey()).startsWith("predicates")).collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
        return new ConnectorConfig(this.plugins, TRANSFORMS_CONFIG_DEF, transformAndPredicateConfigs).transformationStages();
    }

    private Converter converter(String converterType) {
        try {
            return this.plugins.newConverter(new AbstractConfig(CONVERTER_CONFIG_DEF, this.traceConfigsWithDefaults), converterType, Plugins.ClassLoaderUsage.CURRENT_CLASSLOADER);
        }
        catch (Exception e) {
            this.log.warn("{} converter loader threw exception, Reverting to using default converter {}", new Object[]{converterType, DEFAULT_CONFIG.getString(converterType), e});
            return this.plugins.newConverter(new AbstractConfig(CONVERTER_CONFIG_DEF, DEFAULT_CONFIG.originalsWithPrefix(TRACE_PREFIX)), converterType, Plugins.ClassLoaderUsage.CURRENT_CLASSLOADER);
        }
    }

    public Converter valueConverter() {
        return this.converter("value.converter");
    }

    public Converter keyConverter() {
        return this.converter("key.converter");
    }

    public HeaderConverter headerConverter() {
        try {
            return this.plugins.newHeaderConverter(new AbstractConfig(CONVERTER_CONFIG_DEF, this.traceConfigsWithDefaults), "header.converter", Plugins.ClassLoaderUsage.CURRENT_CLASSLOADER);
        }
        catch (Exception e) {
            this.log.warn("{} converter loader threw exception, Reverting to using default converter {}", new Object[]{HEADER_CONVERTER_CONFIG, DEFAULT_CONFIG.getString(HEADER_CONVERTER_CONFIG), e});
            return this.plugins.newHeaderConverter(new AbstractConfig(CONVERTER_CONFIG_DEF, DEFAULT_CONFIG.originalsWithPrefix(TRACE_PREFIX)), "header.converter", Plugins.ClassLoaderUsage.CURRENT_CLASSLOADER);
        }
    }

    public ConnectorConfig connectorConfig() {
        return this.connectorConfig;
    }

    public Class<? extends Connector> connectorClass() {
        return this.plugins.connectorClass(this.connectorConfig.getString("connector.class"));
    }

    public String traceTopic() {
        return this.getString(TOPIC_CONFIG);
    }

    public boolean isTracingEnabled() {
        return this.getBoolean(ENABLE_CONFIG);
    }
}

