/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.licensing;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.runtime.licensing.ConnectWorkerLicenseManager;

public class LicenseConfigUtil {
    public static final String CONFLUENT_LICENSE_CONFIG = "confluent.license";
    public static final String CONFLUENT_LICENSE_DISPLAY = "License";
    public static final String CONFLUENT_LICENSE_DEFAULT = "";
    public static final String CONFLUENT_LICENSE_DOC = "Confluent will issue a license key to each subscriber. The license key will be a short snippet of text that you can copy and paste. Without the license key, you can use the connector for a 30-day trial period. If you are a subscriber, please contact Confluent Support for more information.";
    public static final String CONFLUENT_TOPIC_CONFIG = "confluent.topic";
    public static final String CONFLUENT_TOPIC_DISPLAY = "Confluent Topic";
    public static final String CONFLUENT_TOPIC_DEFAULT = "_confluent-command";
    public static final String CONFLUENT_TOPIC_DOC = "Name of the Kafka topic used for Confluent Platform configuration, including licensing information.";
    public static final String CONFLUENT_TOPIC_PREFIX = "confluent.topic.";
    public static final String CONFLUENT_TOPIC_PRODUCER_PREFIX = "confluent.topic.producer.";
    public static final String CONFLUENT_TOPIC_CONSUMER_PREFIX = "confluent.topic.consumer.";
    public static final String CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_CONFIG = "confluent.topic.bootstrap.servers";
    public static final String CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_DISPLAY = "Confluent Topic Servers";
    public static final String CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_DOC = "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster used for licensing. All servers in the cluster will be discovered from the initial connection. This list should be in the form ``host1:port1,host2:port2,...``. These servers are used only for the initial connection to discover the full cluster membership, which may change dynamically, so this list need not contain the full set of servers. You may want more than one, in case a server is down.";
    public static final String CONFLUENT_TOPIC_REPLICATION_FACTOR_CONFIG = "confluent.topic.replication.factor";
    public static final String CONFLUENT_TOPIC_REPLICATION_FACTOR_DISPLAY = "Confluent Topic Replication Factor";
    public static final int CONFLUENT_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    public static final String CONFLUENT_TOPIC_REPLICATION_FACTOR_DOC = "The replication factor for the Kafka topic used for Confluent Platform configuration, including licensing information. This is used only if the topic does not already exist, and the default of 3 is appropriate for production use. If you are using a development environment with less than 3 brokers, you must set this to the number of brokers (often 1).";
    public static final String CONFLUENT_GROUP = "Confluent Licensing";

    public static ConfigDef addToConfigDef(ConfigDef base) {
        ConfigDef licensingDefs = new ConfigDef(base);
        for (String key : licensingDefs.configKeys().keySet()) {
            if (!key.startsWith(CONFLUENT_TOPIC_PREFIX) && !key.startsWith(CONFLUENT_LICENSE_CONFIG)) continue;
            return licensingDefs;
        }
        return LicenseConfigUtil.addToConfigDef(licensingDefs, CONFLUENT_GROUP);
    }

    public static ConfigDef addToConfigDef(ConfigDef base, String group) {
        int orderInGroup = LicenseConfigUtil.keysInGroup(base, group);
        return base.define(CONFLUENT_LICENSE_CONFIG, ConfigDef.Type.PASSWORD, (Object)CONFLUENT_LICENSE_DEFAULT, ConfigDef.Importance.HIGH, CONFLUENT_LICENSE_DOC, group, ++orderInGroup, ConfigDef.Width.NONE, CONFLUENT_LICENSE_DISPLAY).define(CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.HIGH, CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_DOC, group, ++orderInGroup, ConfigDef.Width.LONG, CONFLUENT_TOPIC_BOOTSTRAP_SERVERS_DISPLAY).define(CONFLUENT_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)CONFLUENT_TOPIC_DEFAULT, ConfigDef.Importance.LOW, CONFLUENT_TOPIC_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, CONFLUENT_TOPIC_DISPLAY).define(CONFLUENT_TOPIC_REPLICATION_FACTOR_CONFIG, ConfigDef.Type.INT, (Object)3, ConfigDef.Importance.LOW, CONFLUENT_TOPIC_REPLICATION_FACTOR_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, CONFLUENT_TOPIC_REPLICATION_FACTOR_DISPLAY);
    }

    public static int keysInGroup(ConfigDef configDef, String groupName) {
        int numKeys = 0;
        for (ConfigDef.ConfigKey key : configDef.configKeys().values()) {
            if (key.group == null || !key.group.equals(groupName)) continue;
            ++numKeys;
        }
        return numKeys;
    }

    public static ConnectWorkerLicenseManager createLicenseManager(Map<?, ?> originals, Map<String, Object> detectorConfigs) {
        ConfigDef base = new ConfigDef();
        ConfigDef licensingDefs = LicenseConfigUtil.addToConfigDef(base);
        AbstractConfig config = new AbstractConfig(licensingDefs, originals);
        return ConnectWorkerLicenseManager.create().useLicense(LicenseConfigUtil.extractLicense(config)).useBrokerDetectorConsumerConfig(detectorConfigs).useTopicName(LicenseConfigUtil.extractLicenseTopicName(config)).useDefaultClientId(LicenseConfigUtil.extractLicenseDefaultClientId(config)).useProducerConfig(LicenseConfigUtil.extractLicenseProducerConfig(config)).useConsumerConfig(LicenseConfigUtil.extractLicenseConsumerConfig(config)).useAdminConfig(LicenseConfigUtil.extractLicenseTopicAdminConfig(config)).build();
    }

    protected static String extractLicenseDefaultClientId(AbstractConfig config) {
        String connectorName = (String)config.originalsStrings().get("name");
        return connectorName != null ? connectorName + "-license-manager" : null;
    }

    protected static Map<String, Object> extractLicenseProducerConfig(AbstractConfig config) {
        HashMap<String, Object> unifiedConfig = new HashMap<String, Object>();
        unifiedConfig.putAll(config.originalsWithPrefix(CONFLUENT_TOPIC_PREFIX));
        unifiedConfig.putAll(config.originalsWithPrefix(CONFLUENT_TOPIC_PRODUCER_PREFIX));
        return unifiedConfig;
    }

    protected static Map<String, Object> extractLicenseConsumerConfig(AbstractConfig config) {
        HashMap<String, Object> unifiedConfig = new HashMap<String, Object>();
        unifiedConfig.putAll(config.originalsWithPrefix(CONFLUENT_TOPIC_PREFIX));
        unifiedConfig.putAll(config.originalsWithPrefix(CONFLUENT_TOPIC_CONSUMER_PREFIX));
        return unifiedConfig;
    }

    protected static Map<String, Object> extractLicenseTopicAdminConfig(AbstractConfig config) {
        HashMap<String, Object> unifiedConfig = new HashMap<String, Object>();
        unifiedConfig.putAll(config.originalsWithPrefix(CONFLUENT_TOPIC_PREFIX));
        unifiedConfig.putAll(config.originalsWithPrefix(CONFLUENT_TOPIC_PRODUCER_PREFIX));
        unifiedConfig.putAll(config.originalsWithPrefix(CONFLUENT_TOPIC_CONSUMER_PREFIX));
        return unifiedConfig;
    }

    protected static String extractLicenseTopicName(AbstractConfig config) {
        return config.getString(CONFLUENT_TOPIC_CONFIG);
    }

    protected static String extractLicense(AbstractConfig config) {
        return config.getPassword(CONFLUENT_LICENSE_CONFIG).value();
    }
}

