/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.distributed;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.util.ConnectorTaskId;

public class ConnectClusterMetrics {
    private final List<WorkerResourceLoad> workerLoads;
    private final List<TaskLoad> taskLoads;

    public List<WorkerResourceLoad> workerLoads() {
        return this.workerLoads;
    }

    public List<TaskLoad> taskLoads() {
        return this.taskLoads;
    }

    public Map<ConnectorTaskId, Double> taskLoadsToMap() {
        return this.taskLoads.stream().collect(Collectors.toMap(TaskLoad::taskId, TaskLoad::taskLoad, Double::max));
    }

    public Map<String, Double> workerLoadsToMap() {
        return this.workerLoads.stream().collect(Collectors.toMap(WorkerResourceLoad::worker, WorkerResourceLoad::workerLoad));
    }

    public ConnectClusterMetrics(List<WorkerResourceLoad> workerLoads, List<TaskLoad> taskLoads) {
        this.workerLoads = workerLoads != null ? workerLoads : Collections.emptyList();
        this.taskLoads = taskLoads != null ? taskLoads : Collections.emptyList();
    }

    public String toString() {
        return "ConnectClusterMetrics{workerLoads=" + this.workerLoads.stream().map(WorkerResourceLoad::toString).collect(Collectors.joining(", ")) + ", taskLoads=" + this.taskLoads.stream().map(TaskLoad::toString).collect(Collectors.joining(", ")) + "}";
    }

    public static class TaskLoad {
        private final ConnectorTaskId taskId;
        private final double taskLoad;

        public ConnectorTaskId taskId() {
            return this.taskId;
        }

        public double taskLoad() {
            return this.taskLoad;
        }

        public TaskLoad(ConnectorTaskId taskId, double taskLoad) {
            this.taskId = taskId;
            this.taskLoad = taskLoad;
        }

        public String toString() {
            return "TaskLoad{taskId=" + String.valueOf(this.taskId) + ", taskLoad=" + this.taskLoad + "}";
        }
    }

    public static class WorkerResourceLoad {
        private final String worker;
        private final double workerLoad;

        public WorkerResourceLoad(String worker, double workerLoad) {
            this.worker = worker;
            this.workerLoad = workerLoad;
        }

        public String worker() {
            return this.worker;
        }

        public double workerLoad() {
            return this.workerLoad;
        }

        public String toString() {
            return "WorkerResourceLoad{worker='" + this.worker + "', workerLoad=" + this.workerLoad + "}";
        }
    }
}

