/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.Connector;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.ConfluentCloudNetworkingType;
import org.apache.kafka.connect.runtime.ConnectRegionalConnectivityType;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.sink.SinkConnector;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConnectUtils {
    private static final Logger log = LoggerFactory.getLogger(ConnectUtils.class);
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    private static final String ENV_VAR_PATTERN = "\\$\\{([A-Za-z0-9_]+)\\}";

    public static Long checkAndConvertTimestamp(Long timestamp) {
        if (timestamp == null || timestamp >= 0L) {
            return timestamp;
        }
        if (timestamp == -1L) {
            return null;
        }
        throw new InvalidRecordException(String.format("Invalid record timestamp %d", timestamp));
    }

    public static void ensureProperty(Map<String, ? super String> props, String key, String expectedValue, String justification, boolean caseSensitive) {
        ConnectUtils.ensurePropertyAndGetWarning(props, key, expectedValue, justification, caseSensitive).ifPresent(arg_0 -> ((Logger)log).warn(arg_0));
    }

    static Optional<String> ensurePropertyAndGetWarning(Map<String, ? super String> props, String key, String expectedValue, String justification, boolean caseSensitive) {
        boolean matchesExpectedValue;
        if (!props.containsKey(key)) {
            props.put(key, expectedValue);
            return Optional.empty();
        }
        String value = Objects.toString(props.get(key));
        boolean bl = matchesExpectedValue = caseSensitive ? expectedValue.equals(value) : expectedValue.equalsIgnoreCase(value);
        if (matchesExpectedValue) {
            return Optional.empty();
        }
        props.put(key, expectedValue);
        justification = justification != null ? " " + (String)justification : "";
        return Optional.of(String.format("The value '%s' for the '%s' property will be ignored as it cannot be overridden%s. The value '%s' will be used instead.", value, key, justification, expectedValue));
    }

    public static void addMetricsContextProperties(Map<String, Object> prop, WorkerConfig config, String clusterId) {
        ConnectUtils.addMetricsContextProperties(prop, config, clusterId, null);
    }

    public static void addMetricsContextProperties(Map<String, Object> prop, WorkerConfig config, String clusterId, ConnectorTaskId connectorTaskId) {
        prop.putAll(config.originalsWithPrefix("metrics.context.", false));
        prop.put("metrics.context.connect.kafka.cluster.id", clusterId);
        Object groupId = config.originals().get("group.id");
        if (groupId != null) {
            prop.put("metrics.context.connect.group.id", groupId);
        }
        if (connectorTaskId != null) {
            prop.put("metrics.context.resource.connector", connectorTaskId.connector());
            prop.put("metrics.context.resource.task", connectorTaskId.task());
        }
    }

    public static void addConfluentMetricsContextProperties(Map<String, Object> prop) {
        prop.put("metrics.context.resource.type", "connect");
        prop.put("metrics.context.resource.version", AppInfoParser.getVersion());
        prop.put("metrics.context.resource.commit.id", AppInfoParser.getCommitId());
        prop.put("enable.metrics.push", "false");
    }

    public static void addConnectorNetworkingTypeMetricsContextProperty(Map<String, Object> clientProps, ConnectorConfig connectorConfig, ConfluentCloudNetworkingType clusterNetworkingType) {
        ConfluentCloudNetworkingType networkingType = ConnectUtils.getConnectorNetworkType(connectorConfig, clusterNetworkingType);
        clientProps.put("metrics.context.resource.connector.networking_type", networkingType.toString());
    }

    public static void addConnectorRegionalConnectivityTypeMetricsContextProperty(Map<String, Object> clientProps, ConnectorConfig connectorConfig) {
        ConnectRegionalConnectivityType regionalConnectivityType = ConnectUtils.getConnectorRegionalConnectivityType(connectorConfig);
        clientProps.put("metrics.context.resource.connector.target_region", regionalConnectivityType.toString());
    }

    public static boolean isSinkConnector(Connector connector) {
        return SinkConnector.class.isAssignableFrom(connector.getClass());
    }

    public static boolean isSourceConnector(Connector connector) {
        return SourceConnector.class.isAssignableFrom(connector.getClass());
    }

    public static <K, I, O> Map<K, O> transformValues(Map<K, I> map, Function<I, O> transformation) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, transformation.compose(Map.Entry::getValue)));
    }

    public static <I> List<I> combineCollections(Collection<Collection<I>> collections) {
        return ConnectUtils.combineCollections(collections, Function.identity());
    }

    public static <I, T> List<T> combineCollections(Collection<I> collection, Function<I, Collection<T>> extractCollection) {
        return ConnectUtils.combineCollections(collection, extractCollection, Collectors.toList());
    }

    public static <I, T, C> C combineCollections(Collection<I> collection, Function<I, Collection<T>> extractCollection, Collector<T, ?, C> collector) {
        return collection.stream().map(extractCollection).flatMap(Collection::stream).collect(collector);
    }

    public static ConnectException maybeWrap(Throwable t, String message) {
        if (t == null) {
            return null;
        }
        if (t instanceof ConnectException) {
            return (ConnectException)t;
        }
        return new ConnectException(message, t);
    }

    public static String clientIdBase(WorkerConfig config) {
        Object result = Optional.ofNullable(config.groupId()).orElse("connect");
        String userSpecifiedClientId = config.getString("client.id");
        if (userSpecifiedClientId != null && !userSpecifiedClientId.trim().isEmpty()) {
            result = (String)result + "-" + userSpecifiedClientId;
        }
        return (String)result + "-";
    }

    public static String determineAdvertisedProtocol(WorkerConfig config) {
        String advertisedSecurityProtocol = config.getString("rest.advertised.listener");
        if (advertisedSecurityProtocol == null) {
            String listeners = (String)config.originals().get("listeners");
            if (listeners == null) {
                return PROTOCOL_HTTP;
            }
            listeners = listeners.toLowerCase(Locale.ENGLISH);
            if (listeners.contains(String.format("%s://", PROTOCOL_HTTP))) {
                return PROTOCOL_HTTP;
            }
            if (listeners.contains(String.format("%s://", PROTOCOL_HTTPS))) {
                return PROTOCOL_HTTPS;
            }
            return PROTOCOL_HTTP;
        }
        return advertisedSecurityProtocol.toLowerCase(Locale.ENGLISH);
    }

    public static String resolveConfigEnvPattern(String input, String property) {
        if (input == null || property == null) {
            return input;
        }
        Pattern pattern = Pattern.compile(ENV_VAR_PATTERN);
        Matcher matcher = pattern.matcher(input);
        StringBuffer resolvedString = new StringBuffer();
        while (matcher.find()) {
            String varName = matcher.group(1);
            String envValue = System.getenv(varName);
            if (envValue != null) {
                matcher.appendReplacement(resolvedString, envValue);
                continue;
            }
            throw new ConfigException(String.format("Missing environment variable '%s' for property '%s'", varName, property));
        }
        matcher.appendTail(resolvedString);
        return resolvedString.toString();
    }

    public static String className(Object o) {
        return o != null ? o.getClass().getName() : "null";
    }

    public static Map<String, String> patchConfig(Map<String, String> config, Map<String, String> patch) {
        HashMap<String, String> result = new HashMap<String, String>(config);
        patch.forEach((k, v) -> {
            if (v != null) {
                result.put((String)k, (String)v);
            } else {
                result.remove(k);
            }
        });
        return result;
    }

    public static boolean isSharedAddress(InetAddress address) {
        byte[] addressBytes = address.getAddress();
        return addressBytes.length == 4 && addressBytes[0] == 100 && (addressBytes[1] & 0xC0) == 64;
    }

    @Confluent
    public static ConfluentCloudNetworkingType getConnectorNetworkType(ConnectorConfig connectorConfig, ConfluentCloudNetworkingType clusterNetworkingType) {
        String connectorName = connectorConfig.getString("name");
        try {
            InetAddress inetAddress;
            String endpoint = connectorConfig.originals().getOrDefault("connector.endpoint", "");
            if (Utils.isBlank((String)endpoint)) {
                log.debug("Connector '{}' has no configured value for '{}'", (Object)connectorName, (Object)"connector.endpoint");
                return ConfluentCloudNetworkingType.PUBLIC;
            }
            endpoint = endpoint.split(",")[0].trim();
            endpoint = endpoint.split("\\$")[0].trim();
            String host = null;
            if (endpoint.contains("_")) {
                try {
                    URL url = new URL(endpoint);
                    host = url.getHost();
                }
                catch (MalformedURLException e) {
                    log.warn("Could not parse endpoint URL: '{}' for connector: '{}'", new Object[]{endpoint, connectorName, e});
                }
            } else {
                URI uri = null;
                try {
                    uri = new URI(endpoint);
                    host = uri.getHost();
                }
                catch (URISyntaxException e) {
                    log.debug("Could not parse endpoint URL: '{}' for connector: '{}'", new Object[]{endpoint, connectorName, e});
                }
            }
            if (host == null) {
                host = endpoint.split(":")[0];
            }
            try {
                inetAddress = Stream.of(InetAddress.getAllByName(host)).filter(address -> address instanceof Inet4Address).findFirst().orElse(null);
            }
            catch (UnknownHostException e) {
                log.warn("Failed to resolve endpoint URL: '{}' (host: '{}') for connector: '{}'", new Object[]{endpoint, host, connectorName});
                return ConfluentCloudNetworkingType.PUBLIC;
            }
            if (inetAddress == null) {
                log.warn("Couldn't find any valid IPv4 addresses for endpoint URL: '{}' for connector '{}'", (Object)endpoint, (Object)connectorName);
                return ConfluentCloudNetworkingType.PUBLIC;
            }
            log.debug("Resolved endpoint '{}' to '{}' for connector '{}'", new Object[]{endpoint, inetAddress, connectorName});
            if (inetAddress.isSiteLocalAddress() || ConnectUtils.isSharedAddress(inetAddress)) {
                return clusterNetworkingType;
            }
            return ConfluentCloudNetworkingType.PUBLIC;
        }
        catch (Throwable t) {
            log.warn("Unexpected error while determining networking type for connector: '" + connectorName + "'", t);
            return ConfluentCloudNetworkingType.PUBLIC;
        }
    }

    @Confluent
    public static ConnectRegionalConnectivityType getConnectorRegionalConnectivityType(ConnectorConfig connectorConfig) {
        Optional<String> inputString = ConnectUtils.getRegionalConnectivityType(connectorConfig);
        if (inputString.isPresent()) {
            try {
                return ConnectRegionalConnectivityType.valueOf(inputString.get());
            }
            catch (Exception e) {
                log.warn("Invalid string value for ConnectRegionalConnectivityType: " + inputString.get() + ". Using default regional connectivity type. ");
                return ConnectRegionalConnectivityType.DEFAULT;
            }
        }
        return ConnectRegionalConnectivityType.DEFAULT;
    }

    private static Optional<String> getRegionalConnectivityType(ConnectorConfig connectorConfig) {
        String configVal = connectorConfig.originals().getOrDefault("connector.target.region", "");
        if (configVal == "") {
            return Optional.empty();
        }
        return Optional.of(configVal);
    }
}

