/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.events;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.connect.runtime.events.EmitterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventsHttpEmitterConfig
extends EmitterConfig {
    private static final Logger log = LoggerFactory.getLogger(CloudEventsHttpEmitterConfig.class);
    public static final String HTTP_BASE_URL = "client.base.url";
    public static final String HTTP_BASE_URL_DOC = "The base URL for the HTTP event emitter.";
    public static final String HTTP_BASE_URL_DEFAULT = "";
    public static final String API_KEY = "api.key";
    public static final String API_KEY_DOC = "The API key for the event emitter.";
    public static final String API_KEY_DEFAULT = "";
    public static final String API_SECRET = "api.secret";
    public static final String API_SECRET_DOC = "The API secret for the event emitter.";
    public static final String API_SECRET_DEFAULT = "";
    public static final String COMPRESSION_ENABLED = "compression.enabled";
    public static final String COMPRESSION_ENABLED_DOC = "Whether to enable compression for HTTP requests. Default: true";
    public static final boolean COMPRESSION_ENABLED_DEFAULT = true;
    public static final String COMPRESSION_TYPE = "compression.type";
    public static final String COMPRESSION_TYPE_DOC = "The compression type to use. Supported types: gzip, zstd, lz4. Default: gzip";
    public static final String COMPRESSION_TYPE_DEFAULT = "gzip";
    public static final String COMPRESSION_MIN_SIZE = "compression.min.size";
    public static final String COMPRESSION_MIN_SIZE_DOC = "Minimum payload size in bytes to trigger compression. Default: 1024";
    public static final int COMPRESSION_MIN_SIZE_DEFAULT = 1024;
    public static final String SSL_CONFIG_PREFIX = "ssl.";
    public static final List<String> SUPPORTED_COMPRESSION_TYPES = Arrays.asList("gzip", "zstd", "lz4");

    public static ConfigDef configDef() {
        ConfigDef configDef = new ConfigDef().define(HTTP_BASE_URL, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, HTTP_BASE_URL_DOC).define(API_KEY, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, API_KEY_DOC).define(API_SECRET, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.MEDIUM, API_SECRET_DOC).define(COMPRESSION_ENABLED, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, COMPRESSION_ENABLED_DOC).define(COMPRESSION_TYPE, ConfigDef.Type.STRING, (Object)COMPRESSION_TYPE_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])SUPPORTED_COMPRESSION_TYPES.toArray(new String[0])), ConfigDef.Importance.MEDIUM, COMPRESSION_TYPE_DOC).define(COMPRESSION_MIN_SIZE, ConfigDef.Type.INT, (Object)1024, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, COMPRESSION_MIN_SIZE_DOC);
        SslConfigs.addClientSslSupport((ConfigDef)configDef);
        return configDef;
    }

    public String httpBaseUrl() {
        return this.getString(HTTP_BASE_URL);
    }

    public String apiKey() {
        return this.getString(API_KEY);
    }

    public String apiSecret() {
        return this.getPassword(API_SECRET).value();
    }

    public boolean isCompressionEnabled() {
        return this.getBoolean(COMPRESSION_ENABLED);
    }

    public String getCompressionType() {
        return this.getString(COMPRESSION_TYPE);
    }

    public CompressionType getCompressionTypeEnum() {
        String type = this.getCompressionType();
        try {
            return CompressionType.forName((String)type);
        }
        catch (IllegalArgumentException e) {
            log.warn("Invalid compression type: {}, defaulting to NONE", (Object)type);
            return CompressionType.NONE;
        }
    }

    public int getCompressionMinSize() {
        return this.getInt(COMPRESSION_MIN_SIZE);
    }

    public void validateCompressionConfig() {
        if (!this.isCompressionEnabled()) {
            return;
        }
        String type = this.getCompressionType();
        try {
            CompressionType.forName((String)type);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unsupported compression type: " + type);
        }
    }

    public Map<String, Object> sslConfigs() {
        ConfigDef sslConfigDef = new ConfigDef();
        SslConfigs.addClientSslSupport((ConfigDef)sslConfigDef);
        return sslConfigDef.parse(this.originalsWithPrefix(SSL_CONFIG_PREFIX, false));
    }

    public boolean hasExplicitSslConfig() {
        return !this.originalsWithPrefix(SSL_CONFIG_PREFIX, false).isEmpty();
    }

    public CloudEventsHttpEmitterConfig(ConfigDef configDef, Map<String, ?> originals) {
        super(configDef, originals);
    }

    public static CloudEventsHttpEmitterConfig from(AbstractConfig combinedConfig) {
        return new CloudEventsHttpEmitterConfig(CloudEventsHttpEmitterConfig.configDef(), combinedConfig.originalsWithPrefix("confluent.connect.metadata.events."));
    }
}

