/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.events;

import com.google.protobuf.util.Timestamps;
import io.confluent.protobuf.events.catalog.v1.ConnectorSpec;
import io.confluent.protobuf.events.catalog.v1.HybridConnectMetadata;
import io.confluent.protobuf.events.catalog.v1.HybridConnectorStatus;
import io.confluent.protobuf.events.catalog.v1.MetadataEvent;
import org.apache.kafka.connect.runtime.AbstractStatus;
import org.apache.kafka.connect.runtime.events.ConnectorMetadata;
import org.apache.kafka.connect.runtime.events.EventTransformer;
import org.apache.kafka.connect.runtime.events.EventsException;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorStateInfo;

class MetadataEventTransformer
implements EventTransformer<ConnectorMetadata, MetadataEvent> {
    MetadataEventTransformer() {
    }

    @Override
    public MetadataEvent transform(ConnectorMetadata connectorMetadata) throws EventsException {
        ConnectorSpec connectorSpec = this.getConnectorSpec(connectorMetadata);
        HybridConnectorStatus status = MetadataEventTransformer.getHybridConnectorStatus(connectorMetadata);
        HybridConnectMetadata hybridConnectMetadata = HybridConnectMetadata.newBuilder().setConnectorSpec(connectorSpec).setConnectorStatus(status).setEventTime(Timestamps.fromMillis((long)connectorMetadata.getEpochMs())).build();
        return MetadataEvent.newBuilder().setHybridConnectMetadata(hybridConnectMetadata).build();
    }

    private static HybridConnectorStatus getHybridConnectorStatus(ConnectorMetadata connectorMetadata) throws EventsException {
        HybridConnectorStatus.Builder statusBuilder = HybridConnectorStatus.newBuilder();
        if (connectorMetadata.getConnectorState() != null) {
            HybridConnectorStatus.ConnectorStatus connectorStatus = HybridConnectorStatus.ConnectorStatus.newBuilder().setState(MetadataEventTransformer.extractState(connectorMetadata.getConnectorState().state())).setTrace(connectorMetadata.getConnectorErrorTrace() == null ? "" : connectorMetadata.getConnectorErrorTrace()).build();
            statusBuilder.setConnectorStatus(connectorStatus);
        }
        for (ConnectorStateInfo.TaskState taskState : connectorMetadata.getTaskStatuses()) {
            HybridConnectorStatus.TaskStatus taskStatus = HybridConnectorStatus.TaskStatus.newBuilder().setTaskId(taskState.id()).setState(MetadataEventTransformer.extractState(taskState.state())).setTrace(connectorMetadata.getTaskTrace(taskState.id()) == null ? "" : connectorMetadata.getTaskTrace(taskState.id())).build();
            statusBuilder.addTaskStatus(taskStatus);
        }
        return statusBuilder.build();
    }

    private ConnectorSpec getConnectorSpec(ConnectorMetadata connectorMetadata) {
        ConnectorSpec.Builder specBuilder = ConnectorSpec.newBuilder();
        specBuilder.setConnectorName(connectorMetadata.getName()).setClusterGroupId(connectorMetadata.getConnectClusterId()).setMetadataKafkaClusterId(connectorMetadata.getMetadataKafkaClusterId());
        if (connectorMetadata.getClassName() != null) {
            specBuilder.setClass_(connectorMetadata.getClassName());
        }
        if (connectorMetadata.getType() != null) {
            specBuilder.setType(ConnectorSpec.ConnectorType.valueOf((String)connectorMetadata.getType()));
        }
        specBuilder.addAllTopics(connectorMetadata.getTopics()).putAllConfigs(connectorMetadata.configs());
        if (connectorMetadata.getDataKafkaClusterId() != null) {
            specBuilder.setDataKafkaClusterId(connectorMetadata.getDataKafkaClusterId());
        }
        ConnectorSpec.DerivedConfigs derivedConfigs = ConnectorSpec.DerivedConfigs.newBuilder().setTasksMax(connectorMetadata.getTasksMax()).setValueConverter(connectorMetadata.getValueConverter() == null ? "" : connectorMetadata.getValueConverter()).build();
        specBuilder.setDerivedConfigs(derivedConfigs);
        return specBuilder.build();
    }

    private static HybridConnectorStatus.State extractState(String state) throws EventsException {
        AbstractStatus.State connectorState;
        try {
            connectorState = AbstractStatus.State.valueOf(state);
        }
        catch (IllegalArgumentException e) {
            throw new EventsException("Unknown connector state: " + state, e);
        }
        switch (connectorState) {
            case UNASSIGNED: {
                return HybridConnectorStatus.State.STATUS_UNASSIGNED;
            }
            case RUNNING: {
                return HybridConnectorStatus.State.STATUS_RUNNING;
            }
            case PAUSED: {
                return HybridConnectorStatus.State.STATUS_PAUSED;
            }
            case FAILED: {
                return HybridConnectorStatus.State.STATUS_FAILED;
            }
            case DESTROYED: {
                return HybridConnectorStatus.State.STATUS_DESTROYED;
            }
            case RESTARTING: {
                return HybridConnectorStatus.State.STATUS_RESTARTING;
            }
            case STOPPED: {
                return HybridConnectorStatus.State.STATUS_STOPPED;
            }
        }
        throw new EventsException("Unknown connector state: " + state);
    }
}

