/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.events;

import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.events.CloudEventsEmitter;
import org.apache.kafka.connect.runtime.events.CloudEventsHttpEmitterConfig;
import org.apache.kafka.connect.runtime.events.ClusterMetadata;
import org.apache.kafka.connect.runtime.events.EventEmitter;
import org.apache.kafka.connect.runtime.events.HttpMetadataChangePublisher;
import org.apache.kafka.connect.runtime.events.MetadataEventTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EmitterFactory {
    public static final String EMITTER_TYPE = "confluent.connect.metadata.events.emitter.type";
    protected static final Logger log = LoggerFactory.getLogger(EmitterFactory.class);

    public abstract EventEmitter createEmitter(WorkerConfig var1, ClusterMetadata var2);

    public static class DefaultEmitterFactory
    extends EmitterFactory {
        protected EventEmitter cloudEventsHttpEmitter(WorkerConfig config, ClusterMetadata clusterMetadata) {
            CloudEventsHttpEmitterConfig emitterConfig = CloudEventsHttpEmitterConfig.from(config);
            MetadataEventTransformer transformer = new MetadataEventTransformer();
            HttpMetadataChangePublisher publisher = new HttpMetadataChangePublisher(emitterConfig);
            return new CloudEventsEmitter(emitterConfig, clusterMetadata, transformer, publisher);
        }

        @Override
        public EventEmitter createEmitter(WorkerConfig config, ClusterMetadata clusterMetadata) {
            EventEmitter emitter = null;
            try {
                switch (EmitterType.from(config).ordinal()) {
                    case 1: {
                        emitter = this.cloudEventsHttpEmitter(config, clusterMetadata);
                        break;
                    }
                    case 2: {
                        log.info("No event emitter configured");
                        break;
                    }
                    case 0: {
                        log.info("Unknown event Emitter type {}", config.originals().get(EmitterFactory.EMITTER_TYPE));
                    }
                }
            }
            catch (Throwable e) {
                log.error("Failed to create emitter", e);
            }
            return emitter;
        }
    }

    public static enum EmitterType {
        UNKNOWN("unknown"),
        CLOUD_EVENTS_HTTP("cloud.events.http"),
        NO_OP("no.op");

        final String typeName;

        private EmitterType(String name) {
            this.typeName = name;
        }

        private static EmitterType from(WorkerConfig config) {
            for (EmitterType emitterType : EmitterType.values()) {
                if (!emitterType.typeName.equals(config.originals().get(EmitterFactory.EMITTER_TYPE))) continue;
                return emitterType;
            }
            return UNKNOWN;
        }

        public String toString() {
            return this.typeName;
        }
    }
}

