/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.tracing;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.common.Confluent;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorType;
import org.apache.kafka.connect.runtime.tracing.TracerConfig;
import org.apache.kafka.connect.util.ConnectorTaskId;

@Confluent
public class TracingContext {
    private final ConnectorType connectorType;
    private final ConnectorTaskId connectorTaskId;
    private Long processedRecordCount;
    private String currentTransformationName;
    private final UUID tracingId;
    private final Map<String, Class<?>> transformationTypes = new LinkedHashMap();

    public TracingContext(ConnectorTaskId connectorTaskId, TracerConfig tracerConfig) {
        this.connectorType = ConnectorType.from(tracerConfig.connectorClass());
        this.connectorTaskId = connectorTaskId;
        this.processedRecordCount = 0L;
        this.tracingId = UUID.randomUUID();
        this.createTransformationTypesMap(tracerConfig.connectorConfig());
    }

    private void createTransformationTypesMap(ConnectorConfig connectorConfig) {
        for (String transform : connectorConfig.getList("transforms")) {
            this.transformationTypes.put(transform, connectorConfig.getClass("transforms." + transform + ".type"));
        }
    }

    public void incrementProcessedRecordCount() {
        Long l = this.processedRecordCount;
        this.processedRecordCount = this.processedRecordCount + 1L;
    }

    public Long processedRecordCount() {
        return this.processedRecordCount;
    }

    public ConnectorTaskId connectorTaskId() {
        return this.connectorTaskId;
    }

    public void setCurrentTransformationName(String name) {
        this.currentTransformationName = name;
    }

    public String currentTransformationName() {
        return this.currentTransformationName;
    }

    public Class<?> currentTransformationType() {
        return this.transformationTypes.get(this.currentTransformationName);
    }

    public ConnectorType connectorType() {
        return this.connectorType;
    }

    public UUID traceID() {
        return this.tracingId;
    }

    public String toString() {
        return String.valueOf(this.connectorTaskId()) + "-" + this.tracingId.toString() + "-" + this.processedRecordCount.toString();
    }
}

