/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.storage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.runtime.AbstractStatus;
import org.apache.kafka.connect.runtime.ConnectorStatus;
import org.apache.kafka.connect.runtime.TaskStatus;
import org.apache.kafka.connect.runtime.TopicStatus;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.distributed.DistributedConfig;
import org.apache.kafka.connect.runtime.events.EventEmitter;
import org.apache.kafka.connect.storage.Converter;
import org.apache.kafka.connect.storage.KafkaTopicBasedBackingStore;
import org.apache.kafka.connect.storage.StatusBackingStore;
import org.apache.kafka.connect.util.Callback;
import org.apache.kafka.connect.util.ConnectUtils;
import org.apache.kafka.connect.util.ConnectorTaskId;
import org.apache.kafka.connect.util.KafkaBasedLog;
import org.apache.kafka.connect.util.Table;
import org.apache.kafka.connect.util.TopicAdmin;
import org.apache.kafka.connect.util.TopicCleanupPolicyVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStatusBackingStore
extends KafkaTopicBasedBackingStore
implements StatusBackingStore {
    private static final Logger log = LoggerFactory.getLogger(KafkaStatusBackingStore.class);
    public static final String TASK_STATUS_PREFIX = "status-task-";
    public static final String CONNECTOR_STATUS_PREFIX = "status-connector-";
    public static final String TOPIC_STATUS_PREFIX = "status-topic-";
    public static final String TOPIC_STATUS_SEPARATOR = ":connector-";
    public static final String STATE_KEY_NAME = "state";
    public static final String TRACE_KEY_NAME = "trace";
    public static final String WORKER_ID_KEY_NAME = "worker_id";
    public static final String GENERATION_KEY_NAME = "generation";
    public static final String VERSION_KEY_NAME = "version";
    public static final String TOPIC_STATE_KEY = "topic";
    public static final String TOPIC_NAME_KEY = "name";
    public static final String TOPIC_CONNECTOR_KEY = "connector";
    public static final String TOPIC_TASK_KEY = "task";
    public static final String TOPIC_DISCOVER_TIMESTAMP_KEY = "discoverTimestamp";
    private static final Schema STATUS_SCHEMA_V0 = SchemaBuilder.struct().field("state", Schema.STRING_SCHEMA).field("trace", SchemaBuilder.string().optional().build()).field("worker_id", Schema.STRING_SCHEMA).field("generation", Schema.INT32_SCHEMA).field("version", Schema.OPTIONAL_STRING_SCHEMA).build();
    private static final Schema TOPIC_STATUS_VALUE_SCHEMA_V0 = SchemaBuilder.struct().field("name", Schema.STRING_SCHEMA).field("connector", Schema.STRING_SCHEMA).field("task", Schema.INT32_SCHEMA).field("discoverTimestamp", Schema.INT64_SCHEMA).build();
    private static final Schema TOPIC_STATUS_SCHEMA_V0 = SchemaBuilder.map((Schema)Schema.STRING_SCHEMA, (Schema)TOPIC_STATUS_VALUE_SCHEMA_V0).build();
    private final Time time;
    private final Converter converter;
    protected final Table<String, Integer, CacheEntry<TaskStatus>> tasks;
    protected final Map<String, CacheEntry<ConnectorStatus>> connectors;
    protected final ConcurrentMap<String, ConcurrentMap<String, TopicStatus>> topics;
    private final Supplier<TopicAdmin> topicAdminSupplier;
    private final String clientId;
    private String statusTopic;
    private KafkaBasedLog<String, byte[]> kafkaLog;
    private TopicCleanupPolicyVerifier cleanupPolicyVerifier;
    private int generation;
    private ExecutorService sendRetryExecutor;
    private Optional<EventEmitter> eventEmitter = Optional.empty();

    public KafkaStatusBackingStore(Time time, Converter converter, Supplier<TopicAdmin> topicAdminSupplier, String clientIdBase) {
        this.time = time;
        this.converter = converter;
        this.tasks = new Table();
        this.connectors = new HashMap<String, CacheEntry<ConnectorStatus>>();
        this.topics = new ConcurrentHashMap<String, ConcurrentMap<String, TopicStatus>>();
        this.topicAdminSupplier = topicAdminSupplier;
        this.clientId = Objects.requireNonNull(clientIdBase) + "statuses";
    }

    KafkaStatusBackingStore(Time time, Converter converter, String statusTopic, Supplier<TopicAdmin> topicAdminSupplier, KafkaBasedLog<String, byte[]> kafkaLog) {
        this(time, converter, topicAdminSupplier, "connect-distributed-");
        this.kafkaLog = kafkaLog;
        this.statusTopic = statusTopic;
        this.sendRetryExecutor = Executors.newSingleThreadExecutor(ThreadUtils.createThreadFactory((String)("status-store-retry-" + statusTopic), (boolean)true));
    }

    @Override
    public void configure(WorkerConfig config) {
        this.statusTopic = config.getString("status.storage.topic");
        if (this.statusTopic == null || this.statusTopic.trim().isEmpty()) {
            throw new ConfigException("Must specify topic for connector status.");
        }
        this.sendRetryExecutor = Executors.newSingleThreadExecutor(ThreadUtils.createThreadFactory((String)("status-store-retry-" + this.statusTopic), (boolean)true));
        String clusterId = config.kafkaClusterId();
        Map<String, Object> originals = config.originals();
        HashMap<String, Object> producerProps = new HashMap<String, Object>(originals);
        producerProps.put("key.serializer", StringSerializer.class.getName());
        producerProps.put("value.serializer", ByteArraySerializer.class.getName());
        producerProps.put("retries", 0);
        producerProps.put("enable.idempotence", "false");
        producerProps.put("client.id", this.clientId);
        ConnectUtils.addMetricsContextProperties(producerProps, config, clusterId);
        ConnectUtils.addConfluentMetricsContextProperties(producerProps);
        HashMap<String, Object> consumerProps = new HashMap<String, Object>(originals);
        consumerProps.put("key.deserializer", StringDeserializer.class.getName());
        consumerProps.put("value.deserializer", ByteArrayDeserializer.class.getName());
        consumerProps.put("client.id", this.clientId);
        ConnectUtils.addMetricsContextProperties(consumerProps, config, clusterId);
        ConnectUtils.addConfluentMetricsContextProperties(consumerProps);
        HashMap<String, Object> adminProps = new HashMap<String, Object>(originals);
        adminProps.put("client.id", this.clientId);
        ConnectUtils.addMetricsContextProperties(adminProps, config, clusterId);
        ConnectUtils.addConfluentMetricsContextProperties(adminProps);
        Map<String, Object> topicSettings = config instanceof DistributedConfig ? ((DistributedConfig)config).statusStorageTopicSettings() : Collections.emptyMap();
        NewTopic topicDescription = TopicAdmin.defineTopic(this.statusTopic).config(topicSettings).compacted().partitions(config.getInt("status.storage.partitions")).replicationFactor(config.getShort("status.storage.replication.factor")).build();
        Callback readCallback = (error, record) -> this.read((ConsumerRecord<String, byte[]>)record);
        this.kafkaLog = this.createKafkaBasedLog(this.statusTopic, producerProps, consumerProps, readCallback, topicDescription, this.topicAdminSupplier, config, this.time);
        this.cleanupPolicyVerifier = new TopicCleanupPolicyVerifier(this.statusTopic, this.getTopicConfig(), this.getTopicPurpose(), this.topicAdminSupplier);
    }

    @Override
    public void start() {
        this.kafkaLog.start();
        this.kafkaLog.readToEnd();
        this.cleanupPolicyVerifier.start();
    }

    @Override
    public void stop() {
        try {
            this.kafkaLog.stop();
        }
        finally {
            Utils.closeQuietly(this.cleanupPolicyVerifier::stop, (String)"log cleanup policy verifier");
            ThreadUtils.shutdownExecutorServiceQuietly((ExecutorService)this.sendRetryExecutor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    public void assignEventEmitter(EventEmitter eventEmitter) {
        this.eventEmitter = Optional.of(eventEmitter);
    }

    @Override
    public void put(ConnectorStatus status) {
        this.sendConnectorStatus(status, false);
    }

    @Override
    public void putSafe(ConnectorStatus status) {
        this.sendConnectorStatus(status, true);
    }

    @Override
    public void put(TaskStatus status) {
        this.sendTaskStatus(status, false);
    }

    @Override
    public void putSafe(TaskStatus status) {
        this.sendTaskStatus(status, true);
    }

    @Override
    public void put(TopicStatus status) {
        this.sendTopicStatus(status.connector(), status.topic(), status);
    }

    @Override
    public void flush() {
        this.kafkaLog.flush();
    }

    private void sendConnectorStatus(ConnectorStatus status, boolean safeWrite) {
        String connector = (String)status.id();
        CacheEntry<ConnectorStatus> entry = this.getOrAdd(connector);
        String key = CONNECTOR_STATUS_PREFIX + connector;
        this.send(key, status, entry, safeWrite);
    }

    private void sendTaskStatus(TaskStatus status, boolean safeWrite) {
        ConnectorTaskId taskId = (ConnectorTaskId)status.id();
        CacheEntry<TaskStatus> entry = this.getOrAdd(taskId);
        String key = TASK_STATUS_PREFIX + taskId.connector() + "-" + taskId.task();
        this.send(key, status, entry, safeWrite);
    }

    private void sendTopicStatus(String connector, String topic, TopicStatus status) {
        final String key = TOPIC_STATUS_PREFIX + topic + TOPIC_STATUS_SEPARATOR + connector;
        final byte[] value = this.serializeTopicStatus(status);
        this.kafkaLog.send(key, value, new org.apache.kafka.clients.producer.Callback(){
            final /* synthetic */ KafkaStatusBackingStore this$0;
            {
                this.this$0 = this$0;
            }

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (exception == null) {
                    return;
                }
                if (exception instanceof RetriableException) {
                    this.this$0.sendRetryExecutor.submit(() -> this.this$0.kafkaLog.send(key, value, this));
                } else {
                    log.error("Failed to write status update", (Throwable)exception);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V extends AbstractStatus<?>> void send(final String key, final V status, final CacheEntry<V> entry, final boolean safeWrite) {
        int sequence;
        KafkaStatusBackingStore kafkaStatusBackingStore = this;
        synchronized (kafkaStatusBackingStore) {
            this.generation = status.generation();
            if (safeWrite && !entry.canWriteSafely(status)) {
                return;
            }
            sequence = entry.increment();
        }
        final byte[] value = status.state() == AbstractStatus.State.DESTROYED ? null : this.serialize(status);
        this.kafkaLog.send(key, value, new org.apache.kafka.clients.producer.Callback(){
            final /* synthetic */ KafkaStatusBackingStore this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCompletion(RecordMetadata metadata, Exception exception) {
                if (exception == null) {
                    return;
                }
                if (exception instanceof RetriableException) {
                    KafkaStatusBackingStore kafkaStatusBackingStore = this.this$0;
                    synchronized (kafkaStatusBackingStore) {
                        if (entry.isDeleted() || status.generation() != this.this$0.generation || safeWrite && !entry.canWriteSafely(status, sequence)) {
                            return;
                        }
                    }
                    this.this$0.sendRetryExecutor.submit(() -> this.this$0.kafkaLog.send(key, value, this));
                } else {
                    log.error("Failed to write status update", (Throwable)exception);
                }
            }
        });
    }

    private synchronized CacheEntry<ConnectorStatus> getOrAdd(String connector) {
        CacheEntry<ConnectorStatus> entry = this.connectors.get(connector);
        if (entry == null) {
            entry = new CacheEntry();
            this.connectors.put(connector, entry);
        }
        return entry;
    }

    private synchronized void remove(String connector) {
        Map<Integer, CacheEntry<TaskStatus>> tasks;
        CacheEntry<ConnectorStatus> removed = this.connectors.remove(connector);
        if (removed != null) {
            removed.delete();
        }
        if ((tasks = this.tasks.remove(connector)) != null) {
            for (CacheEntry<TaskStatus> taskEntry : tasks.values()) {
                taskEntry.delete();
            }
        }
    }

    private synchronized CacheEntry<TaskStatus> getOrAdd(ConnectorTaskId task) {
        CacheEntry<TaskStatus> entry = this.tasks.get(task.connector(), task.task());
        if (entry == null) {
            entry = new CacheEntry();
            this.tasks.put(task.connector(), task.task(), entry);
        }
        return entry;
    }

    private synchronized void remove(ConnectorTaskId id) {
        CacheEntry<TaskStatus> removed = this.tasks.remove(id.connector(), id.task());
        if (removed != null) {
            removed.delete();
        }
    }

    private void removeTopic(String topic, String connector) {
        ConcurrentMap activeTopics = (ConcurrentMap)this.topics.get(connector);
        if (activeTopics == null) {
            return;
        }
        activeTopics.remove(topic);
    }

    @Override
    public synchronized TaskStatus get(ConnectorTaskId id) {
        CacheEntry<TaskStatus> entry = this.tasks.get(id.connector(), id.task());
        return entry == null ? null : entry.get();
    }

    @Override
    public synchronized ConnectorStatus get(String connector) {
        CacheEntry<ConnectorStatus> entry = this.connectors.get(connector);
        return entry == null ? null : entry.get();
    }

    @Override
    public synchronized Collection<TaskStatus> getAll(String connector) {
        ArrayList<TaskStatus> res = new ArrayList<TaskStatus>();
        for (CacheEntry<TaskStatus> statusEntry : this.tasks.row(connector).values()) {
            TaskStatus status = statusEntry.get();
            if (status == null) continue;
            res.add(status);
        }
        return res;
    }

    @Override
    public TopicStatus getTopic(String connector, String topic) {
        ConcurrentMap activeTopics = (ConcurrentMap)this.topics.get(Objects.requireNonNull(connector));
        return activeTopics != null ? (TopicStatus)activeTopics.get(Objects.requireNonNull(topic)) : null;
    }

    @Override
    public Collection<TopicStatus> getAllTopics(String connector) {
        ConcurrentMap activeTopics = (ConcurrentMap)this.topics.get(Objects.requireNonNull(connector));
        return activeTopics != null ? Collections.unmodifiableCollection(Objects.requireNonNull(activeTopics.values())) : Collections.emptySet();
    }

    @Override
    public void deleteTopic(String connector, String topic) {
        this.sendTopicStatus(Objects.requireNonNull(connector), Objects.requireNonNull(topic), null);
    }

    @Override
    public synchronized Set<String> connectors() {
        return new HashSet<String>(this.connectors.keySet());
    }

    private ConnectorStatus parseConnectorStatus(String connector, byte[] data) {
        try {
            SchemaAndValue schemaAndValue = this.converter.toConnectData(this.statusTopic, data);
            if (!(schemaAndValue.value() instanceof Map)) {
                log.error("Invalid connector status type {}", schemaAndValue.value().getClass());
                return null;
            }
            Map statusMap = (Map)schemaAndValue.value();
            AbstractStatus.State state = AbstractStatus.State.valueOf((String)statusMap.get(STATE_KEY_NAME));
            String trace = (String)statusMap.get(TRACE_KEY_NAME);
            String workerUrl = (String)statusMap.get(WORKER_ID_KEY_NAME);
            int generation = ((Long)statusMap.get(GENERATION_KEY_NAME)).intValue();
            String version = (String)statusMap.get(VERSION_KEY_NAME);
            return new ConnectorStatus(connector, state, trace, workerUrl, generation, version);
        }
        catch (Exception e) {
            log.error("Failed to deserialize connector status", (Throwable)e);
            return null;
        }
    }

    private TaskStatus parseTaskStatus(ConnectorTaskId taskId, byte[] data) {
        try {
            SchemaAndValue schemaAndValue = this.converter.toConnectData(this.statusTopic, data);
            if (!(schemaAndValue.value() instanceof Map)) {
                log.error("Invalid task status type {}", schemaAndValue.value().getClass());
                return null;
            }
            Map statusMap = (Map)schemaAndValue.value();
            AbstractStatus.State state = AbstractStatus.State.valueOf((String)statusMap.get(STATE_KEY_NAME));
            String trace = (String)statusMap.get(TRACE_KEY_NAME);
            String workerUrl = (String)statusMap.get(WORKER_ID_KEY_NAME);
            int generation = ((Long)statusMap.get(GENERATION_KEY_NAME)).intValue();
            String version = (String)statusMap.get(VERSION_KEY_NAME);
            return new TaskStatus(taskId, state, workerUrl, generation, trace, version);
        }
        catch (Exception e) {
            log.error("Failed to deserialize task status", (Throwable)e);
            return null;
        }
    }

    protected TopicStatus parseTopicStatus(byte[] data) {
        try {
            SchemaAndValue schemaAndValue = this.converter.toConnectData(this.statusTopic, data);
            if (!(schemaAndValue.value() instanceof Map)) {
                log.error("Invalid topic status value {}", schemaAndValue.value());
                return null;
            }
            Object innerValue = ((Map)schemaAndValue.value()).get(TOPIC_STATE_KEY);
            if (!(innerValue instanceof Map)) {
                log.error("Invalid topic status value {} for field {}", innerValue, (Object)TOPIC_STATE_KEY);
                return null;
            }
            Map topicStatusMetadata = (Map)innerValue;
            return new TopicStatus((String)topicStatusMetadata.get(TOPIC_NAME_KEY), (String)topicStatusMetadata.get(TOPIC_CONNECTOR_KEY), ((Long)topicStatusMetadata.get(TOPIC_TASK_KEY)).intValue(), (Long)topicStatusMetadata.get(TOPIC_DISCOVER_TIMESTAMP_KEY));
        }
        catch (Exception e) {
            log.error("Failed to deserialize topic status", (Throwable)e);
            return null;
        }
    }

    private byte[] serialize(AbstractStatus<?> status) {
        Struct struct = new Struct(STATUS_SCHEMA_V0);
        struct.put(STATE_KEY_NAME, (Object)status.state().name());
        if (status.trace() != null) {
            struct.put(TRACE_KEY_NAME, (Object)status.trace());
        }
        struct.put(WORKER_ID_KEY_NAME, (Object)status.workerId());
        struct.put(GENERATION_KEY_NAME, (Object)status.generation());
        struct.put(VERSION_KEY_NAME, (Object)status.version());
        return this.converter.fromConnectData(this.statusTopic, STATUS_SCHEMA_V0, (Object)struct);
    }

    protected byte[] serializeTopicStatus(TopicStatus status) {
        if (status == null) {
            return null;
        }
        Struct struct = new Struct(TOPIC_STATUS_VALUE_SCHEMA_V0);
        struct.put(TOPIC_NAME_KEY, (Object)status.topic());
        struct.put(TOPIC_CONNECTOR_KEY, (Object)status.connector());
        struct.put(TOPIC_TASK_KEY, (Object)status.task());
        struct.put(TOPIC_DISCOVER_TIMESTAMP_KEY, (Object)status.discoverTimestamp());
        return this.converter.fromConnectData(this.statusTopic, TOPIC_STATUS_SCHEMA_V0, Collections.singletonMap(TOPIC_STATE_KEY, struct));
    }

    private String parseConnectorStatusKey(String key) {
        return key.substring(CONNECTOR_STATUS_PREFIX.length());
    }

    private ConnectorTaskId parseConnectorTaskId(String key) {
        String[] parts = key.split("-");
        if (parts.length < 4) {
            return null;
        }
        try {
            int taskNum = Integer.parseInt(parts[parts.length - 1]);
            String connectorName = String.join((CharSequence)"-", Arrays.copyOfRange(parts, 2, parts.length - 1));
            return new ConnectorTaskId(connectorName, taskNum);
        }
        catch (NumberFormatException e) {
            log.warn("Invalid task status key {}", (Object)key);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readConnectorStatus(String key, byte[] value) {
        String connector = this.parseConnectorStatusKey(key);
        if (connector.isEmpty()) {
            log.warn("Discarding record with invalid connector status key {}", (Object)key);
            return;
        }
        if (value == null) {
            log.trace("Removing status for connector {}", (Object)connector);
            this.remove(connector);
            return;
        }
        ConnectorStatus status = this.parseConnectorStatus(connector, value);
        if (status == null) {
            return;
        }
        KafkaStatusBackingStore kafkaStatusBackingStore = this;
        synchronized (kafkaStatusBackingStore) {
            log.trace("Received connector {} status update {}", (Object)connector, (Object)status);
            CacheEntry<ConnectorStatus> entry = this.getOrAdd(connector);
            entry.put(status);
        }
        this.eventEmitter.ifPresent(e -> e.emitChange(connector, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTaskStatus(String key, byte[] value) {
        ConnectorTaskId id = this.parseConnectorTaskId(key);
        if (id == null) {
            log.warn("Discarding record with invalid task status key {}", (Object)key);
            return;
        }
        if (value == null) {
            log.trace("Removing task status for {}", (Object)id);
            this.remove(id);
            return;
        }
        TaskStatus status = this.parseTaskStatus(id, value);
        if (status == null) {
            log.warn("Failed to parse task status with key {}", (Object)key);
            return;
        }
        KafkaStatusBackingStore kafkaStatusBackingStore = this;
        synchronized (kafkaStatusBackingStore) {
            log.trace("Received task {} status update {}", (Object)id, (Object)status);
            CacheEntry<TaskStatus> entry = this.getOrAdd(id);
            if (status.state() == AbstractStatus.State.UNASSIGNED && entry.get() != null && entry.get().state() == AbstractStatus.State.RUNNING && entry.get().generation() >= status.generation()) {
                log.trace("Ignoring stale status {} in favour of more upto date status {}", (Object)status, (Object)entry.get());
                return;
            }
            entry.put(status);
            this.eventEmitter.ifPresent(e -> e.emitChange(id.connector(), false));
        }
    }

    private void readTopicStatus(String key, byte[] value) {
        int endPos;
        int delimiterPos = key.indexOf(58);
        int beginPos = TOPIC_STATUS_PREFIX.length();
        if (beginPos > delimiterPos) {
            log.warn("Discarding record with invalid topic status key {}", (Object)key);
            return;
        }
        String topic = key.substring(beginPos, delimiterPos);
        if (topic.isEmpty()) {
            log.warn("Discarding record with invalid topic status key containing empty topic {}", (Object)key);
            return;
        }
        beginPos = delimiterPos + TOPIC_STATUS_SEPARATOR.length();
        if (beginPos > (endPos = key.length())) {
            log.warn("Discarding record with invalid topic status key {}", (Object)key);
            return;
        }
        String connector = key.substring(beginPos);
        if (connector.isEmpty()) {
            log.warn("Discarding record with invalid topic status key containing empty connector {}", (Object)key);
            return;
        }
        if (value == null) {
            log.trace("Removing status for topic {} and connector {}", (Object)topic, (Object)connector);
            this.removeTopic(topic, connector);
            this.eventEmitter.ifPresent(e -> e.emitChange(connector, false));
            return;
        }
        TopicStatus status = this.parseTopicStatus(value);
        if (status == null) {
            log.warn("Failed to parse topic status with key {}", (Object)key);
            return;
        }
        log.trace("Received topic status update {}", (Object)status);
        this.topics.computeIfAbsent(connector, k -> new ConcurrentHashMap()).put(topic, status);
        this.eventEmitter.ifPresent(e -> e.emitChange(connector, false));
    }

    void read(ConsumerRecord<String, byte[]> record) {
        String key = (String)record.key();
        if (key.startsWith(CONNECTOR_STATUS_PREFIX)) {
            this.readConnectorStatus(key, (byte[])record.value());
        } else if (key.startsWith(TASK_STATUS_PREFIX)) {
            this.readTaskStatus(key, (byte[])record.value());
        } else if (key.startsWith(TOPIC_STATUS_PREFIX)) {
            this.readTopicStatus(key, (byte[])record.value());
        } else {
            log.warn("Discarding record with invalid key {}", (Object)key);
        }
    }

    @Override
    protected String getTopicConfig() {
        return "status.storage.topic";
    }

    @Override
    protected String getTopicPurpose() {
        return "connector and task statuses";
    }

    private static class CacheEntry<T extends AbstractStatus<?>> {
        private T value = null;
        private int sequence = 0;
        private boolean deleted = false;

        private CacheEntry() {
        }

        public int increment() {
            return ++this.sequence;
        }

        public void put(T value) {
            this.value = value;
        }

        public T get() {
            return this.value;
        }

        public void delete() {
            this.deleted = true;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public boolean canWriteSafely(T status) {
            return this.value == null || ((AbstractStatus)this.value).workerId().equals(((AbstractStatus)status).workerId()) || ((AbstractStatus)this.value).generation() <= ((AbstractStatus)status).generation();
        }

        public boolean canWriteSafely(T status, int sequence) {
            return this.canWriteSafely(status) && this.sequence == sequence;
        }
    }
}

