/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.message;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.kafka.message.FieldSpec;
import org.apache.kafka.message.FieldType;
import org.apache.kafka.message.MessageGenerator;
import org.apache.kafka.message.MessageSpec;
import org.apache.kafka.message.StructSpec;
import org.apache.kafka.message.Versions;

final class StructRegistry {
    private final Map<String, StructInfo> structs = new TreeMap<String, StructInfo>();
    private final Set<String> commonStructNames = new TreeSet<String>();

    StructRegistry() {
    }

    void register(MessageSpec message) {
        for (StructSpec struct : message.commonStructs()) {
            if (!MessageGenerator.firstIsCapitalized(struct.name())) {
                throw new RuntimeException("Can't process structure " + struct.name() + ": the first letter of structure names must be capitalized.");
            }
            if (this.structs.containsKey(struct.name())) {
                throw new RuntimeException("Common struct " + struct.name() + " was specified twice.");
            }
            this.structs.put(struct.name(), new StructInfo(struct, struct.versions()));
            this.commonStructNames.add(struct.name());
        }
        this.addStructSpecs(message.validVersions(), message.fields());
    }

    private void addStructSpecs(Versions parentVersions, List<FieldSpec> fields) {
        for (FieldSpec field : fields) {
            String typeName = null;
            if (field.type().isStructArray()) {
                FieldType.ArrayType arrayType = (FieldType.ArrayType)field.type();
                typeName = arrayType.elementName();
            } else if (field.type().isStruct()) {
                FieldType.StructType structType = (FieldType.StructType)field.type();
                typeName = structType.typeName();
            }
            if (typeName == null) continue;
            if (this.commonStructNames.contains(typeName)) {
                if (!field.fields().isEmpty()) {
                    throw new RuntimeException("Can't re-specify the common struct " + typeName + " as an inline struct.");
                }
            } else {
                if (this.structs.containsKey(typeName)) {
                    throw new RuntimeException("Struct " + typeName + " was specified twice.");
                }
                StructSpec spec = new StructSpec(typeName, field.versions().toString(), "none", field.fields());
                this.structs.put(typeName, new StructInfo(spec, parentVersions));
            }
            this.addStructSpecs(parentVersions.intersect(field.versions()), field.fields());
        }
    }

    StructSpec findStruct(FieldSpec field) {
        String structFieldName;
        if (field.type().isArray()) {
            FieldType.ArrayType arrayType = (FieldType.ArrayType)field.type();
            structFieldName = arrayType.elementName();
        } else if (field.type().isStruct()) {
            FieldType.StructType structType = (FieldType.StructType)field.type();
            structFieldName = structType.typeName();
        } else {
            throw new RuntimeException("Field " + field.name() + " cannot be treated as a structure.");
        }
        StructInfo structInfo = this.structs.get(structFieldName);
        if (structInfo == null) {
            throw new RuntimeException("Unable to locate a specification for the structure " + structFieldName);
        }
        return structInfo.spec;
    }

    boolean isStructArrayWithKeys(FieldSpec field) {
        if (!field.type().isArray()) {
            return false;
        }
        FieldType.ArrayType arrayType = (FieldType.ArrayType)field.type();
        if (!arrayType.isStructArray()) {
            return false;
        }
        StructInfo structInfo = this.structs.get(arrayType.elementName());
        if (structInfo == null) {
            throw new RuntimeException("Unable to locate a specification for the structure " + arrayType.elementName());
        }
        return structInfo.spec.hasKeys();
    }

    Set<String> commonStructNames() {
        return this.commonStructNames;
    }

    Iterator<StructSpec> commonStructs() {
        return new Iterator<StructSpec>(){
            private final Iterator<String> iter;
            {
                this.iter = StructRegistry.this.commonStructNames.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public StructSpec next() {
                return ((StructInfo)StructRegistry.this.structs.get(this.iter.next())).spec;
            }
        };
    }

    Iterator<StructInfo> structs() {
        return this.structs.values().iterator();
    }

    static class StructInfo {
        private final StructSpec spec;
        private final Versions parentVersions;

        StructInfo(StructSpec spec, Versions parentVersions) {
            this.spec = spec;
            this.parentVersions = parentVersions;
        }

        public StructSpec spec() {
            return this.spec;
        }

        public Versions parentVersions() {
            return this.parentVersions;
        }
    }
}

