/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.List;
import java.util.Objects;
import org.apache.kafka.clients.admin.ClusterLinkTaskError;

public class ClusterLinkTaskDescription {
    private final String name;
    private final ClusterLinkTaskState state;
    private final List<ClusterLinkTaskError> errs;

    public ClusterLinkTaskDescription(String name, ClusterLinkTaskState state, List<ClusterLinkTaskError> errs) {
        this.name = name;
        this.state = state;
        this.errs = errs;
    }

    public String name() {
        return this.name;
    }

    public ClusterLinkTaskState state() {
        return this.state;
    }

    public List<ClusterLinkTaskError> errors() {
        return this.errs;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.state, this.errs});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterLinkTaskDescription that = (ClusterLinkTaskDescription)o;
        return Objects.equals(this.name, that.name) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.errs, that.errs);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ClusterTaskDescription(name=").append(this.name).append(", state=").append(this.state.name()).append(", errs=").append(this.errs).append(")");
        return str.toString();
    }

    public static enum ClusterLinkTaskState {
        UNKNOWN(-1),
        ACTIVE(0),
        IN_ERROR(1),
        NOT_CONFIGURED(2),
        LINK_FAILED(3),
        LINK_UNAVAILABLE(4),
        LINK_PAUSED(5);

        private short value;

        private ClusterLinkTaskState(int value) {
            this.value = (short)value;
        }

        public short getValue() {
            return this.value;
        }

        public static ClusterLinkTaskState fromShort(short x) {
            switch (x) {
                case -1: {
                    return UNKNOWN;
                }
                case 0: {
                    return ACTIVE;
                }
                case 1: {
                    return IN_ERROR;
                }
                case 2: {
                    return NOT_CONFIGURED;
                }
                case 3: {
                    return LINK_FAILED;
                }
                case 4: {
                    return LINK_UNAVAILABLE;
                }
                case 5: {
                    return LINK_PAUSED;
                }
            }
            return UNKNOWN;
        }
    }
}

