/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.AppendRecordsRequestData;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.record.MemoryRecords;

public class AppendRecordsRequestDataJsonConverter {
    public static AppendRecordsRequestData read(JsonNode _node, short _version) {
        AppendRecordsRequestData _object = new AppendRecordsRequestData();
        JsonNode _replicaEpochNode = _node.get("replicaEpoch");
        if (_replicaEpochNode == null) {
            throw new RuntimeException("AppendRecordsRequestData: unable to locate field 'replicaEpoch', which is mandatory in version " + _version);
        }
        _object.replicaEpoch = MessageUtil.jsonNodeToLong(_replicaEpochNode, "AppendRecordsRequestData");
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("AppendRecordsRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("AppendRecordsRequestData expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<AppendRecordsRequestData.TopicData> _collection = new ArrayList<AppendRecordsRequestData.TopicData>(_topicsNode.size());
        _object.topics = _collection;
        for (JsonNode _element : _topicsNode) {
            _collection.add(TopicDataJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(AppendRecordsRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("replicaEpoch", (JsonNode)new LongNode(_object.replicaEpoch));
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (AppendRecordsRequestData.TopicData _element : _object.topics) {
            _topicsArray.add(TopicDataJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        return _node;
    }

    public static JsonNode write(AppendRecordsRequestData _object, short _version) {
        return AppendRecordsRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class TopicDataJsonConverter {
        public static AppendRecordsRequestData.TopicData read(JsonNode _node, short _version) {
            AppendRecordsRequestData.TopicData _object = new AppendRecordsRequestData.TopicData();
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'topicId', which is mandatory in version " + _version);
            }
            if (!_topicIdNode.isTextual()) {
                throw new RuntimeException("TopicData expected a JSON string type, but got " + _node.getNodeType());
            }
            _object.topicId = Uuid.fromString(_topicIdNode.asText());
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("TopicData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<AppendRecordsRequestData.PartitionData> _collection = new ArrayList<AppendRecordsRequestData.PartitionData>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(PartitionDataJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(AppendRecordsRequestData.TopicData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (AppendRecordsRequestData.PartitionData _element : _object.partitions) {
                _partitionsArray.add(PartitionDataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public static JsonNode write(AppendRecordsRequestData.TopicData _object, short _version) {
            return TopicDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class PartitionDataJsonConverter {
        public static AppendRecordsRequestData.PartitionData read(JsonNode _node, short _version) {
            AppendRecordsRequestData.PartitionData _object = new AppendRecordsRequestData.PartitionData();
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            _object.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "PartitionData");
            JsonNode _replicationSessionIdNode = _node.get("replicationSessionId");
            if (_replicationSessionIdNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'replicationSessionId', which is mandatory in version " + _version);
            }
            _object.replicationSessionId = MessageUtil.jsonNodeToLong(_replicationSessionIdNode, "PartitionData");
            JsonNode _currentLeaderEpochNode = _node.get("currentLeaderEpoch");
            if (_currentLeaderEpochNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'currentLeaderEpoch', which is mandatory in version " + _version);
            }
            _object.currentLeaderEpoch = MessageUtil.jsonNodeToInt(_currentLeaderEpochNode, "PartitionData");
            JsonNode _appendOffsetNode = _node.get("appendOffset");
            if (_appendOffsetNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'appendOffset', which is mandatory in version " + _version);
            }
            _object.appendOffset = MessageUtil.jsonNodeToLong(_appendOffsetNode, "PartitionData");
            JsonNode _highWatermarkNode = _node.get("highWatermark");
            if (_highWatermarkNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'highWatermark', which is mandatory in version " + _version);
            }
            _object.highWatermark = MessageUtil.jsonNodeToLong(_highWatermarkNode, "PartitionData");
            JsonNode _recordsNode = _node.get("records");
            if (_recordsNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'records', which is mandatory in version " + _version);
            }
            _object.records = _recordsNode.isNull() ? null : MemoryRecords.readableRecords(ByteBuffer.wrap(MessageUtil.jsonNodeToBinary(_recordsNode, "PartitionData")));
            JsonNode _logStartOffsetNode = _node.get("logStartOffset");
            _object.logStartOffset = _logStartOffsetNode == null ? -1L : MessageUtil.jsonNodeToLong(_logStartOffsetNode, "PartitionData");
            JsonNode _endReplicationSessionNode = _node.get("endReplicationSession");
            if (_endReplicationSessionNode == null) {
                _object.endReplicationSession = false;
            } else {
                if (!_endReplicationSessionNode.isBoolean()) {
                    throw new RuntimeException("PartitionData expected Boolean type, but got " + _node.getNodeType());
                }
                _object.endReplicationSession = _endReplicationSessionNode.asBoolean();
            }
            return _object;
        }

        public static JsonNode write(AppendRecordsRequestData.PartitionData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", (JsonNode)new IntNode(_object.partitionIndex));
            _node.set("replicationSessionId", (JsonNode)new LongNode(_object.replicationSessionId));
            _node.set("currentLeaderEpoch", (JsonNode)new IntNode(_object.currentLeaderEpoch));
            _node.set("appendOffset", (JsonNode)new LongNode(_object.appendOffset));
            _node.set("highWatermark", (JsonNode)new LongNode(_object.highWatermark));
            if (_object.records == null) {
                _node.set("records", (JsonNode)NullNode.instance);
            } else if (_serializeRecords) {
                _node.set("records", (JsonNode)new BinaryNode(new byte[0]));
            } else {
                _node.set("recordsSizeInBytes", (JsonNode)new IntNode(_object.records.sizeInBytes()));
            }
            if (_object.logStartOffset != -1L) {
                _node.set("logStartOffset", (JsonNode)new LongNode(_object.logStartOffset));
            }
            if (_object.endReplicationSession) {
                _node.set("endReplicationSession", (JsonNode)BooleanNode.valueOf((boolean)_object.endReplicationSession));
            }
            return _node;
        }

        public static JsonNode write(AppendRecordsRequestData.PartitionData _object, short _version) {
            return PartitionDataJsonConverter.write(_object, _version, true);
        }
    }
}

