/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class GetTelemetrySubscriptionsResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    Uuid clientInstanceId;
    int subscriptionId;
    List<Byte> acceptedCompressionTypes;
    int pushIntervalMs;
    int telemetryMaxBytes;
    boolean deltaTemporality;
    List<String> requestedMetrics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("client_instance_id", Type.UUID, "Assigned client instance id if ClientInstanceId was 0 in the request, else 0."), new Field("subscription_id", Type.INT32, "Unique identifier for the current subscription set for this client instance."), new Field("accepted_compression_types", new CompactArrayOf(Type.INT8), "Compression types that broker accepts for the PushTelemetryRequest."), new Field("push_interval_ms", Type.INT32, "Configured push interval, which is the lowest configured interval in the current subscription set."), new Field("telemetry_max_bytes", Type.INT32, "The maximum bytes of binary data the broker accepts in PushTelemetryRequest."), new Field("delta_temporality", Type.BOOLEAN, "Flag to indicate monotonic/counter metrics are to be emitted as deltas or cumulative values"), new Field("requested_metrics", new CompactArrayOf(Type.COMPACT_STRING), "Requested metrics prefix string match. Empty array: No metrics subscribed, Array[0] empty string: All metrics subscribed."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public GetTelemetrySubscriptionsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public GetTelemetrySubscriptionsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.clientInstanceId = Uuid.ZERO_UUID;
        this.subscriptionId = 0;
        this.acceptedCompressionTypes = new ArrayList<Byte>(0);
        this.pushIntervalMs = 0;
        this.telemetryMaxBytes = 0;
        this.deltaTemporality = false;
        this.requestedMetrics = new ArrayList<String>(0);
    }

    @Override
    public short apiKey() {
        return 71;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        this.clientInstanceId = _readable.readUuid();
        this.subscriptionId = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field acceptedCompressionTypes was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<Byte> newCollection = new ArrayList<Byte>(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            newCollection.add(_readable.readByte());
        }
        this.acceptedCompressionTypes = newCollection;
        this.pushIntervalMs = _readable.readInt();
        this.telemetryMaxBytes = _readable.readInt();
        this.deltaTemporality = _readable.readByte() != 0;
        arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field requestedMetrics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        newCollection = new ArrayList(arrayLength);
        for (i = 0; i < arrayLength; ++i) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field requestedMetrics element was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field requestedMetrics element had invalid length " + length);
            }
            newCollection.add((Byte)((Object)_readable.readString(length)));
        }
        this.requestedMetrics = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        _writable.writeUuid(this.clientInstanceId);
        _writable.writeInt(this.subscriptionId);
        _writable.writeUnsignedVarint(this.acceptedCompressionTypes.size() + 1);
        for (Byte acceptedCompressionTypesElement : this.acceptedCompressionTypes) {
            _writable.writeByte(acceptedCompressionTypesElement);
        }
        _writable.writeInt(this.pushIntervalMs);
        _writable.writeInt(this.telemetryMaxBytes);
        _writable.writeByte(this.deltaTemporality ? (byte)1 : 0);
        _writable.writeUnsignedVarint(this.requestedMetrics.size() + 1);
        for (String requestedMetricsElement : this.requestedMetrics) {
            byte[] _stringBytes = _cache.getSerializedValue(requestedMetricsElement);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        _size.addBytes(16);
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.acceptedCompressionTypes.size() + 1));
        _size.addBytes(this.acceptedCompressionTypes.size() * 1);
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(1);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.requestedMetrics.size() + 1));
        for (String requestedMetricsElement : this.requestedMetrics) {
            byte[] _stringBytes = requestedMetricsElement.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'requestedMetricsElement' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(requestedMetricsElement, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GetTelemetrySubscriptionsResponseData)) {
            return false;
        }
        GetTelemetrySubscriptionsResponseData other = (GetTelemetrySubscriptionsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (!this.clientInstanceId.equals(other.clientInstanceId)) {
            return false;
        }
        if (this.subscriptionId != other.subscriptionId) {
            return false;
        }
        if (this.acceptedCompressionTypes == null ? other.acceptedCompressionTypes != null : !this.acceptedCompressionTypes.equals(other.acceptedCompressionTypes)) {
            return false;
        }
        if (this.pushIntervalMs != other.pushIntervalMs) {
            return false;
        }
        if (this.telemetryMaxBytes != other.telemetryMaxBytes) {
            return false;
        }
        if (this.deltaTemporality != other.deltaTemporality) {
            return false;
        }
        if (this.requestedMetrics == null ? other.requestedMetrics != null : !this.requestedMetrics.equals(other.requestedMetrics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + this.clientInstanceId.hashCode();
        hashCode = 31 * hashCode + this.subscriptionId;
        hashCode = 31 * hashCode + (this.acceptedCompressionTypes == null ? 0 : this.acceptedCompressionTypes.hashCode());
        hashCode = 31 * hashCode + this.pushIntervalMs;
        hashCode = 31 * hashCode + this.telemetryMaxBytes;
        hashCode = 31 * hashCode + (this.deltaTemporality ? 1231 : 1237);
        hashCode = 31 * hashCode + (this.requestedMetrics == null ? 0 : this.requestedMetrics.hashCode());
        return hashCode;
    }

    @Override
    public GetTelemetrySubscriptionsResponseData duplicate() {
        GetTelemetrySubscriptionsResponseData _duplicate = new GetTelemetrySubscriptionsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.clientInstanceId = this.clientInstanceId;
        _duplicate.subscriptionId = this.subscriptionId;
        ArrayList<Byte> newAcceptedCompressionTypes = new ArrayList<Byte>(this.acceptedCompressionTypes.size());
        for (Byte _element : this.acceptedCompressionTypes) {
            newAcceptedCompressionTypes.add(_element);
        }
        _duplicate.acceptedCompressionTypes = newAcceptedCompressionTypes;
        _duplicate.pushIntervalMs = this.pushIntervalMs;
        _duplicate.telemetryMaxBytes = this.telemetryMaxBytes;
        _duplicate.deltaTemporality = this.deltaTemporality;
        ArrayList<String> newRequestedMetrics = new ArrayList<String>(this.requestedMetrics.size());
        for (String _element : this.requestedMetrics) {
            newRequestedMetrics.add(_element);
        }
        _duplicate.requestedMetrics = newRequestedMetrics;
        return _duplicate;
    }

    public String toString() {
        return "GetTelemetrySubscriptionsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", clientInstanceId=" + this.clientInstanceId.toString() + ", subscriptionId=" + this.subscriptionId + ", acceptedCompressionTypes=" + MessageUtil.deepToString(this.acceptedCompressionTypes.iterator()) + ", pushIntervalMs=" + this.pushIntervalMs + ", telemetryMaxBytes=" + this.telemetryMaxBytes + ", deltaTemporality=" + (this.deltaTemporality ? "true" : "false") + ", requestedMetrics=" + MessageUtil.deepToString(this.requestedMetrics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public Uuid clientInstanceId() {
        return this.clientInstanceId;
    }

    public int subscriptionId() {
        return this.subscriptionId;
    }

    public List<Byte> acceptedCompressionTypes() {
        return this.acceptedCompressionTypes;
    }

    public int pushIntervalMs() {
        return this.pushIntervalMs;
    }

    public int telemetryMaxBytes() {
        return this.telemetryMaxBytes;
    }

    public boolean deltaTemporality() {
        return this.deltaTemporality;
    }

    public List<String> requestedMetrics() {
        return this.requestedMetrics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public GetTelemetrySubscriptionsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public GetTelemetrySubscriptionsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public GetTelemetrySubscriptionsResponseData setClientInstanceId(Uuid v) {
        this.clientInstanceId = v;
        return this;
    }

    public GetTelemetrySubscriptionsResponseData setSubscriptionId(int v) {
        this.subscriptionId = v;
        return this;
    }

    public GetTelemetrySubscriptionsResponseData setAcceptedCompressionTypes(List<Byte> v) {
        this.acceptedCompressionTypes = v;
        return this;
    }

    public GetTelemetrySubscriptionsResponseData setPushIntervalMs(int v) {
        this.pushIntervalMs = v;
        return this;
    }

    public GetTelemetrySubscriptionsResponseData setTelemetryMaxBytes(int v) {
        this.telemetryMaxBytes = v;
        return this;
    }

    public GetTelemetrySubscriptionsResponseData setDeltaTemporality(boolean v) {
        this.deltaTemporality = v;
        return this;
    }

    public GetTelemetrySubscriptionsResponseData setRequestedMetrics(List<String> v) {
        this.requestedMetrics = v;
        return this;
    }
}

