/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.audit;

import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Lazy;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuditEventType;
import org.apache.kafka.server.audit.AuthenticationEvent;

public class DefaultAuthenticationEvent
implements AuthenticationEvent {
    private final Instant timestamp;
    private final Lazy<UUID> lazyUUID;
    private final KafkaPrincipal principal;
    private final AuthenticationContext authenticationContext;
    private final AuditEventStatus auditEventStatus;
    private final AuthenticationException authenticationException;
    private Map<String, Object> data = Collections.emptyMap();

    public DefaultAuthenticationEvent(KafkaPrincipal principal, AuthenticationContext authenticationContext, AuditEventStatus auditEventStatus, AuthenticationException authenticationException, Instant timestamp) {
        this.principal = principal;
        this.authenticationContext = authenticationContext;
        this.auditEventStatus = auditEventStatus;
        this.timestamp = timestamp;
        this.authenticationException = authenticationException;
        this.lazyUUID = new Lazy();
    }

    public DefaultAuthenticationEvent(KafkaPrincipal principal, AuthenticationContext authenticationContext, AuditEventStatus auditEventStatus, AuthenticationException authenticationException) {
        this(principal, authenticationContext, auditEventStatus, authenticationException, Instant.now());
    }

    public DefaultAuthenticationEvent(KafkaPrincipal principal, AuthenticationContext authenticationContext, AuthenticationException authenticationException) {
        this(principal, authenticationContext, DefaultAuthenticationEvent.getAuditEventStatus(authenticationException), authenticationException, Instant.now());
    }

    public DefaultAuthenticationEvent(KafkaPrincipal principal, AuthenticationContext authenticationContext, AuditEventStatus auditEventStatus) {
        this(principal, authenticationContext, auditEventStatus, null, Instant.now());
    }

    private static AuditEventStatus getAuditEventStatus(AuthenticationException authenticationException) {
        return authenticationException.errorInfo().auditEventStatus();
    }

    @Override
    public UUID uuid() {
        return this.lazyUUID.getOrCompute(UUID::randomUUID);
    }

    @Override
    public Instant timestamp() {
        return this.timestamp;
    }

    @Override
    public AuditEventType type() {
        return AuditEventType.AUTHENTICATION;
    }

    @Override
    public AuditEventStatus status() {
        return this.auditEventStatus;
    }

    @Override
    public Map<String, Object> data() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    @Override
    public Optional<KafkaPrincipal> principal() {
        return Optional.ofNullable(this.principal);
    }

    @Override
    public AuthenticationContext authenticationContext() {
        return this.authenticationContext;
    }

    @Override
    public Optional<AuthenticationException> authenticationException() {
        return Optional.ofNullable(this.authenticationException);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultAuthenticationEvent that = (DefaultAuthenticationEvent)o;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.lazyUUID, that.lazyUUID) && Objects.equals(this.principal, that.principal) && Objects.equals(this.authenticationContext, that.authenticationContext) && this.auditEventStatus == that.auditEventStatus && Objects.equals(this.authenticationException, that.authenticationException) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.lazyUUID, this.principal, this.authenticationContext, this.auditEventStatus, this.authenticationException, this.data});
    }

    public String toString() {
        return "DefaultAuthenticationEvent{timestamp=" + this.timestamp + ", lazyUUID=" + this.lazyUUID + ", principal=" + this.principal + ", authenticationContext=" + this.authenticationContext + ", auditEventStatus=" + (Object)((Object)this.auditEventStatus) + ", authenticationException=" + this.authenticationException + ", data=" + this.data + '}';
    }
}

