/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.http.server;

import io.confluent.kafka.http.server.KafkaHttpServerInjector;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;

public final class KafkaHttpServerBinder {
    private final HashMap<BindingKey, Supplier<?>> bindings = new HashMap();

    public synchronized <T> void bindInstance(Class<T> type, T instance) {
        this.bindInstance(type, null, instance);
    }

    public synchronized <T> void bindInstance(Class<T> type, Class<? extends Annotation> annotation, T instance) {
        this.bindSupplier(type, annotation, () -> instance);
    }

    public synchronized <T> void bindSupplier(Class<T> type, Supplier<? extends T> supplier) {
        this.bindSupplier(type, null, supplier);
    }

    public synchronized <T> void bindSupplier(Class<T> type, Class<? extends Annotation> annotation, Supplier<? extends T> supplier) {
        Supplier<? extends T> existing = this.bindings.putIfAbsent(new BindingKey(type, annotation), Objects.requireNonNull(supplier));
        if (existing != null) {
            throw new IllegalArgumentException(String.format("A binding for %s annotated with %s already exists.", type, annotation));
        }
    }

    public synchronized KafkaHttpServerInjector createInjector() {
        return new KafkaHttpServerInjectorImpl(this.bindings);
    }

    private static final class KafkaHttpServerInjectorImpl
    implements KafkaHttpServerInjector {
        private final Map<BindingKey, Supplier<?>> bindings;

        private KafkaHttpServerInjectorImpl(HashMap<BindingKey, Supplier<?>> bindings) {
            this.bindings = Collections.unmodifiableMap(new HashMap(bindings));
        }

        @Override
        public <T> T getInstance(Class<T> type) {
            return this.getInstance(type, null);
        }

        @Override
        public <T> T getInstance(Class<T> type, Class<? extends Annotation> annotation) {
            Supplier<T> supplier = this.getSupplier(type, annotation);
            try {
                return supplier.get();
            }
            catch (Throwable error) {
                throw new KafkaHttpServerInjector.ProvisionException(String.format("Error while getting instance for %s annotated with %s.", type, annotation), error);
            }
        }

        @Override
        public <T> Supplier<T> getSupplier(Class<T> type) {
            return this.getSupplier(type, null);
        }

        @Override
        public <T> Supplier<T> getSupplier(Class<T> type, Class<? extends Annotation> annotation) {
            Supplier<?> supplier = this.bindings.get(new BindingKey(type, annotation));
            if (supplier == null) {
                throw new KafkaHttpServerInjector.ProvisionException(String.format("No binding found for %s annotated with %s.", type, annotation));
            }
            return supplier;
        }
    }

    private static final class BindingKey {
        private final Class<?> type;
        private final Class<? extends Annotation> annotation;

        private BindingKey(Class<?> type, Class<? extends Annotation> annotation) {
            this.type = Objects.requireNonNull(type);
            this.annotation = annotation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BindingKey that = (BindingKey)o;
            return this.type.equals(that.type) && Objects.equals(this.annotation, that.annotation);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.annotation);
        }
    }
}

