/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.ApiRequestScope;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class AllBrokersStrategy
implements AdminApiLookupStrategy<BrokerKey> {
    public static final BrokerKey ANY_BROKER = new BrokerKey(OptionalInt.empty());
    public static final Set<BrokerKey> LOOKUP_KEYS = Collections.singleton(ANY_BROKER);
    private static final ApiRequestScope SINGLE_REQUEST_SCOPE = new ApiRequestScope(){};
    private final Logger log;

    public AllBrokersStrategy(LogContext logContext) {
        this.log = logContext.logger(AllBrokersStrategy.class);
    }

    @Override
    public ApiRequestScope lookupScope(BrokerKey key) {
        return SINGLE_REQUEST_SCOPE;
    }

    public MetadataRequest.Builder buildRequest(Set<BrokerKey> keys) {
        this.validateLookupKeys(keys);
        return new MetadataRequest.Builder(new MetadataRequestData());
    }

    @Override
    public AdminApiLookupStrategy.LookupResult<BrokerKey> handleResponse(Set<BrokerKey> keys, AbstractResponse abstractResponse) {
        this.validateLookupKeys(keys);
        MetadataResponse response = (MetadataResponse)abstractResponse;
        MetadataResponseData.MetadataResponseBrokerCollection brokers = response.data().brokers();
        if (brokers.isEmpty()) {
            this.log.debug("Metadata response contained no brokers. Will backoff and retry");
            return AdminApiLookupStrategy.LookupResult.empty();
        }
        this.log.debug("Discovered all brokers {} to send requests to", (Object)brokers);
        Map<BrokerKey, Integer> brokerKeys = brokers.stream().collect(Collectors.toMap(broker -> new BrokerKey(OptionalInt.of(broker.nodeId())), MetadataResponseData.MetadataResponseBroker::nodeId));
        return new AdminApiLookupStrategy.LookupResult<BrokerKey>(Collections.singletonList(ANY_BROKER), Collections.emptyMap(), brokerKeys);
    }

    private void validateLookupKeys(Set<BrokerKey> keys) {
        if (keys.size() != 1) {
            throw new IllegalArgumentException("Unexpected key set: " + keys);
        }
        BrokerKey key = keys.iterator().next();
        if (key != ANY_BROKER) {
            throw new IllegalArgumentException("Unexpected key set: " + keys);
        }
    }

    public static class AllBrokersFuture<V>
    implements AdminApiFuture<BrokerKey, V> {
        private final KafkaFutureImpl<Map<Integer, KafkaFutureImpl<V>>> future = new KafkaFutureImpl();
        private final Map<Integer, KafkaFutureImpl<V>> brokerFutures = new HashMap<Integer, KafkaFutureImpl<V>>();

        @Override
        public Set<BrokerKey> lookupKeys() {
            return LOOKUP_KEYS;
        }

        @Override
        public void completeLookup(Map<BrokerKey, Integer> brokerMapping) {
            brokerMapping.forEach((brokerKey, brokerId) -> {
                if (brokerId.intValue() != brokerKey.brokerId.orElse(-1)) {
                    throw new IllegalArgumentException("Invalid lookup mapping " + brokerKey + " -> " + brokerId);
                }
                this.brokerFutures.put((Integer)brokerId, new KafkaFutureImpl());
            });
            this.future.complete(this.brokerFutures);
        }

        @Override
        public void completeLookupExceptionally(Map<BrokerKey, Throwable> lookupErrors) {
            if (!LOOKUP_KEYS.equals(lookupErrors.keySet())) {
                throw new IllegalArgumentException("Unexpected keys among lookup errors: " + lookupErrors);
            }
            this.future.completeExceptionally(lookupErrors.get(ANY_BROKER));
        }

        @Override
        public void complete(Map<BrokerKey, V> values) {
            values.forEach(this::complete);
        }

        private void complete(BrokerKey key, V value) {
            if (key == ANY_BROKER) {
                throw new IllegalArgumentException("Invalid attempt to complete with lookup key sentinel");
            }
            this.futureOrThrow(key).complete(value);
        }

        @Override
        public void completeExceptionally(Map<BrokerKey, Throwable> errors) {
            errors.forEach(this::completeExceptionally);
        }

        private void completeExceptionally(BrokerKey key, Throwable t2) {
            if (key == ANY_BROKER) {
                this.future.completeExceptionally(t2);
            } else {
                this.futureOrThrow(key).completeExceptionally(t2);
            }
        }

        public KafkaFutureImpl<Map<Integer, KafkaFutureImpl<V>>> all() {
            return this.future;
        }

        private KafkaFutureImpl<V> futureOrThrow(BrokerKey key) {
            if (!key.brokerId.isPresent()) {
                throw new IllegalArgumentException("Attempt to complete with invalid key: " + key);
            }
            int brokerId = key.brokerId.getAsInt();
            KafkaFutureImpl<V> future = this.brokerFutures.get(brokerId);
            if (future == null) {
                throw new IllegalArgumentException("Attempt to complete with unknown broker id: " + brokerId);
            }
            return future;
        }
    }

    public static class BrokerKey {
        public final OptionalInt brokerId;

        public BrokerKey(OptionalInt brokerId) {
            this.brokerId = brokerId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BrokerKey that = (BrokerKey)o;
            return Objects.equals(this.brokerId, that.brokerId);
        }

        public int hashCode() {
            return Objects.hash(this.brokerId);
        }

        public String toString() {
            return "BrokerKey(brokerId=" + this.brokerId + ')';
        }
    }
}

