/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AppendRecordsResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    List<TopicData> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The top level response error code."), new Field("topics", new CompactArrayOf(TopicData.SCHEMA_0), "The response topics."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public AppendRecordsResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AppendRecordsResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.topics = new ArrayList<TopicData>(0);
    }

    @Override
    public short apiKey() {
        return 10037;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<TopicData> newCollection = new ArrayList<TopicData>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new TopicData(_readable, _version, _context));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        for (TopicData topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1));
        for (TopicData topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AppendRecordsResponseData)) {
            return false;
        }
        AppendRecordsResponseData other = (AppendRecordsResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    @Override
    public AppendRecordsResponseData duplicate() {
        AppendRecordsResponseData _duplicate = new AppendRecordsResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        ArrayList<TopicData> newTopics = new ArrayList<TopicData>(this.topics.size());
        for (TopicData _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "AppendRecordsResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<TopicData> topics() {
        return this.topics;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AppendRecordsResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public AppendRecordsResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public AppendRecordsResponseData setTopics(List<TopicData> v) {
        this.topics = v;
        return this;
    }

    public static class PartitionData
    implements Message {
        int partitionIndex;
        short errorCode;
        long logEndOffset;
        long logStartOffset;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("log_end_offset", Type.INT64, "The follower replica's log end offset."), Field.TaggedFieldsSection.of(0, new Field("log_start_offset", Type.INT64, "The earliest available offset of the follower replica.")));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public PartitionData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public PartitionData() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.logEndOffset = 0L;
            this.logStartOffset = -1L;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionData");
            }
            this.partitionIndex = _readable.readInt();
            this.errorCode = _readable.readShort();
            this.logEndOffset = _readable.readLong();
            this.logStartOffset = -1L;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            block3: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 0: {
                        this.logStartOffset = _readable.readLong();
                        continue block3;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.errorCode);
            _writable.writeLong(this.logEndOffset);
            if (this.logStartOffset != -1L) {
                ++_numTaggedFields;
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            if (this.logStartOffset != -1L) {
                _writable.writeUnsignedVarint(0);
                _writable.writeUnsignedVarint(8);
                _writable.writeLong(this.logStartOffset);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionData");
            }
            _size.addBytes(4);
            _size.addBytes(2);
            _size.addBytes(8);
            if (this.logStartOffset != -1L) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _size.addBytes(1);
                _size.addBytes(8);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionData)) {
                return false;
            }
            PartitionData other = (PartitionData)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.logEndOffset != other.logEndOffset) {
                return false;
            }
            if (this.logStartOffset != other.logStartOffset) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + ((int)(this.logEndOffset >> 32) ^ (int)this.logEndOffset);
            hashCode = 31 * hashCode + ((int)(this.logStartOffset >> 32) ^ (int)this.logStartOffset);
            return hashCode;
        }

        @Override
        public PartitionData duplicate() {
            PartitionData _duplicate = new PartitionData();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.errorCode = this.errorCode;
            _duplicate.logEndOffset = this.logEndOffset;
            _duplicate.logStartOffset = this.logStartOffset;
            return _duplicate;
        }

        public String toString() {
            return "PartitionData(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ", logEndOffset=" + this.logEndOffset + ", logStartOffset=" + this.logStartOffset + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public long logEndOffset() {
            return this.logEndOffset;
        }

        public long logStartOffset() {
            return this.logStartOffset;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionData setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public PartitionData setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public PartitionData setLogEndOffset(long v) {
            this.logEndOffset = v;
            return this;
        }

        public PartitionData setLogStartOffset(long v) {
            this.logStartOffset = v;
            return this;
        }
    }

    public static class TopicData
    implements Message {
        Uuid topicId;
        List<PartitionData> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_id", Type.UUID, "The unique topic ID"), new Field("partitions", new CompactArrayOf(PartitionData.SCHEMA_0), "The topic partitions."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public TopicData() {
            this.topicId = Uuid.ZERO_UUID;
            this.partitions = new ArrayList<PartitionData>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicData");
            }
            this.topicId = _readable.readUuid();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<PartitionData> newCollection = new ArrayList<PartitionData>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new PartitionData(_readable, _version, _context));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeUuid(this.topicId);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            for (PartitionData partitionsElement : this.partitions) {
                partitionsElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicData");
            }
            _size.addBytes(16);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            for (PartitionData partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicData)) {
                return false;
            }
            TopicData other = (TopicData)obj;
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public TopicData duplicate() {
            TopicData _duplicate = new TopicData();
            _duplicate.topicId = this.topicId;
            ArrayList<PartitionData> newPartitions = new ArrayList<PartitionData>(this.partitions.size());
            for (PartitionData _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicData(topicId=" + this.topicId.toString() + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public List<PartitionData> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicData setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public TopicData setPartitions(List<PartitionData> v) {
            this.partitions = v;
            return this;
        }
    }
}

