/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.authenticator;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Principal;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.message.ConfluentBrokenPrincipalData;
import org.apache.kafka.common.message.DefaultPrincipalData;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.PlaintextAuthenticationContext;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SslAuthenticationContext;
import org.apache.kafka.common.security.kerberos.KerberosName;
import org.apache.kafka.common.security.kerberos.KerberosShortNamer;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;

public class DefaultKafkaPrincipalBuilder
implements KafkaPrincipalBuilder,
KafkaPrincipalSerde {
    private final KerberosShortNamer kerberosShortNamer;
    private final SslPrincipalMapper sslPrincipalMapper;

    public DefaultKafkaPrincipalBuilder(KerberosShortNamer kerberosShortNamer, SslPrincipalMapper sslPrincipalMapper) {
        this.kerberosShortNamer = kerberosShortNamer;
        this.sslPrincipalMapper = sslPrincipalMapper;
    }

    @Override
    public KafkaPrincipal build(AuthenticationContext context) {
        if (context instanceof PlaintextAuthenticationContext) {
            return KafkaPrincipal.ANONYMOUS;
        }
        if (context instanceof SslAuthenticationContext) {
            SSLSession sslSession = ((SslAuthenticationContext)context).session();
            try {
                return this.applySslPrincipalMapper(sslSession.getPeerPrincipal());
            }
            catch (SSLPeerUnverifiedException se) {
                return KafkaPrincipal.ANONYMOUS;
            }
        }
        if (context instanceof SaslAuthenticationContext) {
            SaslServer saslServer = ((SaslAuthenticationContext)context).server();
            if ("GSSAPI".equals(saslServer.getMechanismName())) {
                return this.applyKerberosShortNamer(saslServer.getAuthorizationID());
            }
            return new KafkaPrincipal("User", saslServer.getAuthorizationID());
        }
        throw new IllegalArgumentException("Unhandled authentication context type: " + context.getClass().getName());
    }

    private KafkaPrincipal applyKerberosShortNamer(String authorizationId) {
        KerberosName kerberosName = KerberosName.parse(authorizationId);
        try {
            String shortName = this.kerberosShortNamer.shortName(kerberosName);
            return new KafkaPrincipal("User", shortName);
        }
        catch (IOException e) {
            throw new KafkaException("Failed to set name for '" + kerberosName + "' based on Kerberos authentication rules.", e);
        }
    }

    private KafkaPrincipal applySslPrincipalMapper(Principal principal) {
        try {
            if (!(principal instanceof X500Principal) || principal == KafkaPrincipal.ANONYMOUS) {
                return new KafkaPrincipal("User", principal.getName());
            }
            return new KafkaPrincipal("User", this.sslPrincipalMapper.getName(principal.getName()));
        }
        catch (IOException e) {
            throw new KafkaException("Failed to map name for '" + principal.getName() + "' based on SSL principal mapping rules.", e);
        }
    }

    @Override
    public byte[] serialize(KafkaPrincipal principal) {
        DefaultPrincipalData data = new DefaultPrincipalData().setType(principal.getPrincipalType()).setName(principal.getName()).setTokenAuthenticated(principal.tokenAuthenticated());
        return MessageUtil.toVersionPrefixedBytes((short)0, data);
    }

    @Override
    public KafkaPrincipal deserialize(byte[] bytes) {
        DefaultPrincipalData data;
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        short version = buffer.getShort();
        if (version < 0 || version > 0) {
            throw new SerializationException("Invalid principal data version " + version);
        }
        try {
            data = new DefaultPrincipalData(new ByteBufferAccessor(buffer), version);
        }
        catch (Throwable t2) {
            throw new SerializationException("Failed to deserialize principal", t2);
        }
        if (buffer.hasRemaining() && !this.validBrokenSchemaData(bytes)) {
            throw new SerializationException("Failed to deserialize principal: " + buffer.remaining() + " bytes remaining after parsing");
        }
        return new KafkaPrincipal(data.type(), data.name(), data.tokenAuthenticated());
    }

    private boolean validBrokenSchemaData(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        short version = buffer.getShort();
        if (version < 0 || version > 0) {
            return false;
        }
        try {
            new ConfluentBrokenPrincipalData(new ByteBufferAccessor(buffer), version);
        }
        catch (Throwable t2) {
            return false;
        }
        return !buffer.hasRemaining();
    }
}

