/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.DescribeCellMigrationRequestData;
import org.apache.kafka.common.message.DescribeCellMigrationResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeCellMigrationResponse;

public class DescribeCellMigrationRequest
extends AbstractRequest {
    private final DescribeCellMigrationRequestData data;

    DescribeCellMigrationRequest(DescribeCellMigrationRequestData data, short version) {
        super(ApiKeys.DESCRIBE_CELL_MIGRATION, version);
        this.data = data;
    }

    @Override
    public DescribeCellMigrationRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable t2) {
        ApiError err = ApiError.fromThrowable(t2);
        return new DescribeCellMigrationResponse(new DescribeCellMigrationResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(err.error().code()).setErrorMessage(err.message()));
    }

    public static DescribeCellMigrationRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeCellMigrationRequest(new DescribeCellMigrationRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeCellMigrationRequest> {
        private final DescribeCellMigrationRequestData data;

        public Builder() {
            super(ApiKeys.DESCRIBE_CELL_MIGRATION);
            this.data = new DescribeCellMigrationRequestData();
        }

        public Builder(DescribeCellMigrationRequestData data) {
            super(ApiKeys.DESCRIBE_CELL_MIGRATION);
            this.data = data;
        }

        @Override
        public DescribeCellMigrationRequest build(short version) {
            return new DescribeCellMigrationRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

