/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaderAndIsrResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.apache.kafka.common.utils.FlattenedIterator;

public final class LeaderAndIsrRequest
extends AbstractControlRequest {
    private final LeaderAndIsrRequestData data;

    public LeaderAndIsrRequest(LeaderAndIsrRequestData data, short version) {
        super(ApiKeys.LEADER_AND_ISR, version);
        this.data = data;
        this.normalize();
    }

    private void normalize() {
        if (this.version() >= 2) {
            for (LeaderAndIsrRequestData.LeaderAndIsrTopicState topicState : this.data.topicStates()) {
                for (LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState : topicState.partitionStates()) {
                    partitionState.setTopicName(topicState.topicName());
                }
            }
        }
        for (LeaderAndIsrRequestData.LeaderAndIsrTopicState topicState : this.data.topicStates()) {
            if (topicState.confluentTopicId().equals(Uuid.ZERO_UUID)) continue;
            topicState.setTopicId(topicState.confluentTopicId());
        }
    }

    @Override
    public LeaderAndIsrResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        LeaderAndIsrResponseData responseData = new LeaderAndIsrResponseData();
        Errors error = Errors.forException(e);
        responseData.setErrorCode(error.code());
        if (this.version() < 5) {
            ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions = new ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError>();
            for (LeaderAndIsrRequestData.LeaderAndIsrPartitionState partition : this.partitionStates()) {
                partitions.add(new LeaderAndIsrResponseData.LeaderAndIsrPartitionError().setTopicName(partition.topicName()).setPartitionIndex(partition.partitionIndex()).setErrorCode(error.code()));
            }
            responseData.setPartitionErrors(partitions);
        } else {
            for (LeaderAndIsrRequestData.LeaderAndIsrTopicState topicState : this.data.topicStates()) {
                ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions = new ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError>(topicState.partitionStates().size());
                for (LeaderAndIsrRequestData.LeaderAndIsrPartitionState partition : topicState.partitionStates()) {
                    partitions.add(new LeaderAndIsrResponseData.LeaderAndIsrPartitionError().setPartitionIndex(partition.partitionIndex()).setErrorCode(error.code()));
                }
                responseData.topics().add(new LeaderAndIsrResponseData.LeaderAndIsrTopicError().setTopicId(topicState.topicId()).setPartitionErrors(partitions));
            }
        }
        return new LeaderAndIsrResponse(responseData, this.version());
    }

    @Override
    public int controllerId() {
        return this.data.controllerId();
    }

    @Override
    public boolean isKRaftController() {
        return this.data.isKRaftController();
    }

    @Override
    public int controllerEpoch() {
        return this.data.controllerEpoch();
    }

    @Override
    public long brokerEpoch() {
        return this.data.brokerEpoch();
    }

    public boolean containsAllReplicas() {
        return this.data.containsAllReplicas();
    }

    public Iterable<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates() {
        if (this.version() >= 2) {
            return () -> new FlattenedIterator(this.data.topicStates().iterator(), topicState -> topicState.partitionStates().iterator());
        }
        return this.data.ungroupedPartitionStates();
    }

    public Map<String, Uuid> topicIds() {
        return this.data.topicStates().stream().collect(Collectors.toMap(LeaderAndIsrRequestData.LeaderAndIsrTopicState::topicName, LeaderAndIsrRequestData.LeaderAndIsrTopicState::topicId));
    }

    public List<LeaderAndIsrRequestData.LeaderAndIsrLiveLeader> liveLeaders() {
        return Collections.unmodifiableList(this.data.liveLeaders());
    }

    public AbstractControlRequest.Type requestType() {
        return AbstractControlRequest.Type.fromByte(this.data.type());
    }

    @Override
    public LeaderAndIsrRequestData data() {
        return this.data;
    }

    public static LeaderAndIsrRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new LeaderAndIsrRequest(new LeaderAndIsrRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public long partitionSize() {
        long size = 0L;
        Iterator<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> it = this.partitionStates().iterator();
        while (it.hasNext()) {
            it.next();
            ++size;
        }
        return size;
    }

    public Iterable<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> filterTopicPartitonsByString(String topicSubString) {
        ArrayList<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> topicPartitons = new ArrayList<LeaderAndIsrRequestData.LeaderAndIsrPartitionState>();
        for (LeaderAndIsrRequestData.LeaderAndIsrPartitionState state : this.partitionStates()) {
            if (!state.topicName().contains(topicSubString)) continue;
            topicPartitons.add(state);
        }
        return topicPartitons;
    }

    public static class Builder
    extends AbstractControlRequest.Builder<LeaderAndIsrRequest> {
        private final List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates;
        private final Map<String, Uuid> topicIds;
        private final Collection<Node> liveLeaders;
        private final boolean containsAllReplicas;
        private final AbstractControlRequest.Type updateType;

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates, Map<String, Uuid> topicIds, boolean containsAllReplicas, Collection<Node> liveLeaders, boolean isKRaftController) {
            this(version, controllerId, controllerEpoch, brokerEpoch, partitionStates, topicIds, containsAllReplicas, liveLeaders, isKRaftController, AbstractControlRequest.Type.UNKNOWN, System.currentTimeMillis());
        }

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates, Map<String, Uuid> topicIds, boolean containsAllReplicas, Collection<Node> liveLeaders, boolean isKRaftController, AbstractControlRequest.Type updateType) {
            this(version, controllerId, controllerEpoch, brokerEpoch, partitionStates, topicIds, containsAllReplicas, liveLeaders, isKRaftController, updateType, System.currentTimeMillis());
        }

        public Builder(short version, int controllerId, int controllerEpoch, long brokerEpoch, List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates, Map<String, Uuid> topicIds, boolean containsAllReplicas, Collection<Node> liveLeaders, boolean isKRaftController, AbstractControlRequest.Type updateType, long timestamp) {
            super(ApiKeys.LEADER_AND_ISR, version, controllerId, controllerEpoch, brokerEpoch, isKRaftController, timestamp);
            this.partitionStates = partitionStates;
            this.topicIds = topicIds;
            this.liveLeaders = liveLeaders;
            this.containsAllReplicas = containsAllReplicas;
            this.updateType = updateType;
        }

        @Override
        public LeaderAndIsrRequest build(short version) {
            List<LeaderAndIsrRequestData.LeaderAndIsrLiveLeader> leaders = this.liveLeaders.stream().map(n -> new LeaderAndIsrRequestData.LeaderAndIsrLiveLeader().setBrokerId(n.id()).setHostName(n.host()).setPort(n.port())).collect(Collectors.toList());
            LeaderAndIsrRequestData data = new LeaderAndIsrRequestData().setControllerId(this.controllerId).setControllerEpoch(this.controllerEpoch).setBrokerEpoch(this.brokerEpoch).setLiveLeaders(leaders).setContainsAllReplicas(this.containsAllReplicas).setTimestamp(this.timestamp);
            if (version >= 7) {
                data.setIsKRaftController(this.kraftController);
            }
            if (version >= 5) {
                data.setType(this.updateType.toByte());
            }
            if (version >= 2) {
                Map<String, LeaderAndIsrRequestData.LeaderAndIsrTopicState> topicStatesMap = Builder.groupByTopic(this.partitionStates, this.topicIds, version);
                data.setTopicStates(new ArrayList<LeaderAndIsrRequestData.LeaderAndIsrTopicState>(topicStatesMap.values()));
            } else {
                data.setUngroupedPartitionStates(this.partitionStates);
            }
            return new LeaderAndIsrRequest(data, version);
        }

        private static Map<String, LeaderAndIsrRequestData.LeaderAndIsrTopicState> groupByTopic(List<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates, Map<String, Uuid> topicIds, short version) {
            HashMap<String, LeaderAndIsrRequestData.LeaderAndIsrTopicState> topicStates = new HashMap<String, LeaderAndIsrRequestData.LeaderAndIsrTopicState>();
            for (LeaderAndIsrRequestData.LeaderAndIsrPartitionState partition : partitionStates) {
                Uuid topicId = topicIds.getOrDefault(partition.topicName(), Uuid.ZERO_UUID);
                partition.setTopicId(topicId);
                if (version < 5) {
                    partition.setClusterLinkSourceTopicId(Uuid.ZERO_UUID);
                }
                LeaderAndIsrRequestData.LeaderAndIsrTopicState topicState = topicStates.computeIfAbsent(partition.topicName(), t2 -> new LeaderAndIsrRequestData.LeaderAndIsrTopicState().setTopicName(partition.topicName()).setTopicId(topicId).setConfluentTopicId(topicId).setClusterLinkId(partition.clusterLinkId()).setClusterLinkSourceTopicId(partition.clusterLinkSourceTopicId()).setClusterLinkTopicState(partition.clusterLinkTopicState()));
                topicState.partitionStates().add(partition);
            }
            return topicStates;
        }

        public String toString() {
            return "(type=LeaderAndIsRequest, controllerId=" + this.controllerId + ", controllerEpoch=" + this.controllerEpoch + ", brokerEpoch=" + this.brokerEpoch + ", containsAllReplicas=" + this.containsAllReplicas + ", partitionStates=" + this.partitionStates + ", topicIds=" + this.topicIds + ", liveLeaders=(" + this.liveLeaders.stream().map(Node::toString).collect(Collectors.joining(", ")) + "))";
        }
    }
}

