/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.auth;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class IdentityMetadata {
    private final String poolId;
    private final String providerId;
    private final String identity;
    private final String externalIdentityId;
    private final String issuer;
    private final List<String> audience;

    public IdentityMetadata(String poolId, String providerId, String identity, String externalIdentityId) {
        this(poolId, providerId, identity, externalIdentityId, null, null);
    }

    public IdentityMetadata(String poolId, String providerId, String identity, String externalIdentityId, String issuer, List<String> audience) {
        this.poolId = poolId;
        this.providerId = providerId;
        this.identity = identity;
        this.externalIdentityId = externalIdentityId;
        this.issuer = issuer;
        this.audience = audience;
    }

    public String poolId() {
        return this.poolId;
    }

    public String providerId() {
        return this.providerId;
    }

    public String identity() {
        return this.identity;
    }

    public String externalIdentityId() {
        return this.externalIdentityId;
    }

    public String issuer() {
        return this.issuer;
    }

    public List<String> audience() {
        return this.audience;
    }

    public Optional<String> maybeGetPoolId() {
        return Optional.ofNullable(this.poolId).filter(s2 -> !s2.isEmpty());
    }

    public Optional<String> maybeGetProviderId() {
        return Optional.ofNullable(this.providerId).filter(s2 -> !s2.isEmpty());
    }

    public Optional<String> maybeGetIdentity() {
        return Optional.ofNullable(this.identity).filter(s2 -> !s2.isEmpty());
    }

    public Optional<String> maybeGetIssuer() {
        return Optional.ofNullable(this.issuer).filter(s2 -> !s2.isEmpty());
    }

    public Optional<List<String>> maybeGetAudience() {
        return Optional.ofNullable(this.audience).filter(s2 -> !s2.isEmpty());
    }

    public int hashCode() {
        return Objects.hash(this.poolId, this.providerId, this.identity, this.externalIdentityId, this.issuer, this.audience);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityMetadata that = (IdentityMetadata)o;
        return Objects.equals(this.poolId, that.poolId) && Objects.equals(this.providerId, that.providerId) && Objects.equals(this.identity, that.identity) && Objects.equals(this.externalIdentityId, that.externalIdentityId) && Objects.equals(this.audience, that.audience) && Objects.equals(this.issuer, that.issuer);
    }

    public String toString() {
        return "IdentityMetadata(poolId='" + this.poolId + "',providerId='" + this.providerId + "',identity='" + this.identity + "',issuer='" + this.issuer + "',audience='" + this.audience + "')";
    }

    public static class Builder {
        private String poolId;
        private String providerId;
        private String identity;
        private String externalIdentityId;
        private String issuer;
        private List<String> audience;

        public Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public Builder providerId(String providerId) {
            this.providerId = providerId;
            return this;
        }

        public Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public Builder externalIdentityId(String externalIdentityId) {
            this.externalIdentityId = externalIdentityId;
            return this;
        }

        public Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public Builder audience(List<String> audience) {
            this.audience = audience;
            return this;
        }

        public IdentityMetadata build() {
            return new IdentityMetadata(this.poolId, this.providerId, this.identity, this.externalIdentityId, this.issuer, this.audience);
        }
    }
}

