/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.oauthbearer;

import io.confluent.kafka.security.oauthbearer.HttpRequestFormatter;
import io.confluent.kafka.security.oauthbearer.ValidationUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.utils.Utils;

public class ClientSecretHttpRequestFormatter
implements HttpRequestFormatter {
    private String clientId;
    private String clientSecret;
    private final boolean urlEncodeHeader;
    public static final String AUTHORIZATION_HEADER = "Authorization";

    public ClientSecretHttpRequestFormatter(String clientId, String clientSecret, boolean urlEncodeHeader) {
        this.clientId = Objects.requireNonNull(clientId);
        this.clientSecret = Objects.requireNonNull(clientSecret);
        this.urlEncodeHeader = urlEncodeHeader;
    }

    @Override
    public Map<String, String> getRequestHeader() throws IOException {
        return Collections.singletonMap(AUTHORIZATION_HEADER, this.getAuthHeader());
    }

    private String getAuthHeader() throws UnsupportedEncodingException {
        this.clientId = ValidationUtils.sanitizeString("the token endpoint request client ID parameter", this.clientId);
        this.clientSecret = ValidationUtils.sanitizeString("the token endpoint request client secret parameter", this.clientSecret);
        if (this.urlEncodeHeader) {
            this.clientId = URLEncoder.encode(this.clientId, StandardCharsets.UTF_8.name());
            this.clientSecret = URLEncoder.encode(this.clientSecret, StandardCharsets.UTF_8.name());
        }
        String s2 = String.format("%s:%s", this.clientId, this.clientSecret);
        String encoded = Base64.getEncoder().encodeToString(Utils.utf8(s2));
        return String.format("Basic %s", encoded);
    }

    @Override
    public String getRequestBody(String scope) throws IOException {
        try {
            StringBuilder requestParameters = new StringBuilder();
            requestParameters.append("grant_type=client_credentials");
            if (scope != null && !scope.trim().isEmpty()) {
                scope = scope.trim();
                String encodedScope = URLEncoder.encode(scope, StandardCharsets.UTF_8.name());
                requestParameters.append("&scope=").append(encodedScope);
            }
            return requestParameters.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(String.format("Encoding %s not supported", StandardCharsets.UTF_8.name()));
        }
    }
}

