/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateAclsRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class CreateAclsRequestDataJsonConverter {
    public static CreateAclsRequestData read(JsonNode _node, short _version) {
        CreateAclsRequestData _object = new CreateAclsRequestData();
        JsonNode _creationsNode = _node.get("creations");
        if (_creationsNode == null) {
            throw new RuntimeException("CreateAclsRequestData: unable to locate field 'creations', which is mandatory in version " + _version);
        }
        if (!_creationsNode.isArray()) {
            throw new RuntimeException("CreateAclsRequestData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        ArrayList<CreateAclsRequestData.AclCreation> _collection = new ArrayList<CreateAclsRequestData.AclCreation>(_creationsNode.size());
        _object.creations = _collection;
        for (JsonNode _element : _creationsNode) {
            _collection.add(AclCreationJsonConverter.read(_element, _version));
        }
        JsonNode _clusterIdNode = _node.get("clusterId");
        if (_clusterIdNode == null) {
            _object.clusterId = "";
        } else {
            if (!_clusterIdNode.isTextual()) {
                throw new RuntimeException("CreateAclsRequestData expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.clusterId = _clusterIdNode.asText();
        }
        return _object;
    }

    public static JsonNode write(CreateAclsRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode _creationsArray = new ArrayNode(JsonNodeFactory.instance);
        for (CreateAclsRequestData.AclCreation _element : _object.creations) {
            _creationsArray.add(AclCreationJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("creations", (JsonNode)_creationsArray);
        if (_version >= 2) {
            if (!_object.clusterId.equals("")) {
                _node.set("clusterId", (JsonNode)new TextNode(_object.clusterId));
            }
        } else if (!_object.clusterId.equals("")) {
            throw new UnsupportedVersionException("Attempted to write a non-default clusterId at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(CreateAclsRequestData _object, short _version) {
        return CreateAclsRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class AclCreationJsonConverter {
        public static CreateAclsRequestData.AclCreation read(JsonNode _node, short _version) {
            CreateAclsRequestData.AclCreation _object = new CreateAclsRequestData.AclCreation();
            JsonNode _resourceTypeNode = _node.get("resourceType");
            if (_resourceTypeNode == null) {
                throw new RuntimeException("AclCreation: unable to locate field 'resourceType', which is mandatory in version " + _version);
            }
            _object.resourceType = MessageUtil.jsonNodeToByte(_resourceTypeNode, "AclCreation");
            JsonNode _resourceNameNode = _node.get("resourceName");
            if (_resourceNameNode == null) {
                throw new RuntimeException("AclCreation: unable to locate field 'resourceName', which is mandatory in version " + _version);
            }
            if (!_resourceNameNode.isTextual()) {
                throw new RuntimeException("AclCreation expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.resourceName = _resourceNameNode.asText();
            JsonNode _resourcePatternTypeNode = _node.get("resourcePatternType");
            if (_resourcePatternTypeNode == null) {
                throw new RuntimeException("AclCreation: unable to locate field 'resourcePatternType', which is mandatory in version " + _version);
            }
            _object.resourcePatternType = MessageUtil.jsonNodeToByte(_resourcePatternTypeNode, "AclCreation");
            JsonNode _principalNode = _node.get("principal");
            if (_principalNode == null) {
                throw new RuntimeException("AclCreation: unable to locate field 'principal', which is mandatory in version " + _version);
            }
            if (!_principalNode.isTextual()) {
                throw new RuntimeException("AclCreation expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.principal = _principalNode.asText();
            JsonNode _hostNode = _node.get("host");
            if (_hostNode == null) {
                throw new RuntimeException("AclCreation: unable to locate field 'host', which is mandatory in version " + _version);
            }
            if (!_hostNode.isTextual()) {
                throw new RuntimeException("AclCreation expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.host = _hostNode.asText();
            JsonNode _operationNode = _node.get("operation");
            if (_operationNode == null) {
                throw new RuntimeException("AclCreation: unable to locate field 'operation', which is mandatory in version " + _version);
            }
            _object.operation = MessageUtil.jsonNodeToByte(_operationNode, "AclCreation");
            JsonNode _permissionTypeNode = _node.get("permissionType");
            if (_permissionTypeNode == null) {
                throw new RuntimeException("AclCreation: unable to locate field 'permissionType', which is mandatory in version " + _version);
            }
            _object.permissionType = MessageUtil.jsonNodeToByte(_permissionTypeNode, "AclCreation");
            JsonNode _clusterLinkIdsNode = _node.get("clusterLinkIds");
            if (_clusterLinkIdsNode == null) {
                _object.clusterLinkIds = new ArrayList<Uuid>(0);
            } else {
                if (!_clusterLinkIdsNode.isArray()) {
                    throw new RuntimeException("AclCreation expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
                }
                ArrayList<Uuid> _collection = new ArrayList<Uuid>(_clusterLinkIdsNode.size());
                _object.clusterLinkIds = _collection;
                for (JsonNode _element : _clusterLinkIdsNode) {
                    if (!_element.isTextual()) {
                        throw new RuntimeException("AclCreation element expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
                    }
                    _collection.add(Uuid.fromString(_element.asText()));
                }
            }
            return _object;
        }

        public static JsonNode write(CreateAclsRequestData.AclCreation _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("resourceType", (JsonNode)new ShortNode((short)_object.resourceType));
            _node.set("resourceName", (JsonNode)new TextNode(_object.resourceName));
            _node.set("resourcePatternType", (JsonNode)new ShortNode((short)_object.resourcePatternType));
            _node.set("principal", (JsonNode)new TextNode(_object.principal));
            _node.set("host", (JsonNode)new TextNode(_object.host));
            _node.set("operation", (JsonNode)new ShortNode((short)_object.operation));
            _node.set("permissionType", (JsonNode)new ShortNode((short)_object.permissionType));
            if (_version >= 2 && !_object.clusterLinkIds.isEmpty()) {
                ArrayNode _clusterLinkIdsArray = new ArrayNode(JsonNodeFactory.instance);
                for (Uuid _element : _object.clusterLinkIds) {
                    _clusterLinkIdsArray.add((JsonNode)new TextNode(_element.toString()));
                }
                _node.set("clusterLinkIds", (JsonNode)_clusterLinkIdsArray);
            }
            return _node;
        }

        public static JsonNode write(CreateAclsRequestData.AclCreation _object, short _version) {
            return AclCreationJsonConverter.write(_object, _version, true);
        }
    }
}

