/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.protocol.MessageUtil;

public class CreateTopicsRequestDataJsonConverter {
    public static CreateTopicsRequestData read(JsonNode _node, short _version) {
        CreateTopicsRequestData.CreatableTopicCollection _collection;
        CreateTopicsRequestData _object = new CreateTopicsRequestData();
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("CreateTopicsRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("CreateTopicsRequestData expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.topics = _collection = new CreateTopicsRequestData.CreatableTopicCollection(_topicsNode.size());
        for (JsonNode _element : _topicsNode) {
            _collection.add(CreatableTopicJsonConverter.read(_element, _version));
        }
        JsonNode _timeoutMsNode = _node.get("timeoutMs");
        if (_timeoutMsNode == null) {
            throw new RuntimeException("CreateTopicsRequestData: unable to locate field 'timeoutMs', which is mandatory in version " + _version);
        }
        _object.timeoutMs = MessageUtil.jsonNodeToInt(_timeoutMsNode, "CreateTopicsRequestData");
        JsonNode _validateOnlyNode = _node.get("validateOnly");
        if (_validateOnlyNode == null) {
            throw new RuntimeException("CreateTopicsRequestData: unable to locate field 'validateOnly', which is mandatory in version " + _version);
        }
        if (!_validateOnlyNode.isBoolean()) {
            throw new RuntimeException("CreateTopicsRequestData expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
        }
        _object.validateOnly = _validateOnlyNode.asBoolean();
        JsonNode _isClusterLinkingValidatedByBrokerNode = _node.get("isClusterLinkingValidatedByBroker");
        if (_isClusterLinkingValidatedByBrokerNode == null) {
            _object.isClusterLinkingValidatedByBroker = false;
        } else {
            if (!_isClusterLinkingValidatedByBrokerNode.isBoolean()) {
                throw new RuntimeException("CreateTopicsRequestData expected Boolean type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.isClusterLinkingValidatedByBroker = _isClusterLinkingValidatedByBrokerNode.asBoolean();
        }
        return _object;
    }

    public static JsonNode write(CreateTopicsRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (CreateTopicsRequestData.CreatableTopic _element : _object.topics) {
            _topicsArray.add(CreatableTopicJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        _node.set("timeoutMs", (JsonNode)new IntNode(_object.timeoutMs));
        _node.set("validateOnly", (JsonNode)BooleanNode.valueOf((boolean)_object.validateOnly));
        if (_version >= 5) {
            if (_object.isClusterLinkingValidatedByBroker) {
                _node.set("isClusterLinkingValidatedByBroker", (JsonNode)BooleanNode.valueOf((boolean)_object.isClusterLinkingValidatedByBroker));
            }
        } else if (_object.isClusterLinkingValidatedByBroker) {
            throw new UnsupportedVersionException("Attempted to write a non-default isClusterLinkingValidatedByBroker at version " + _version);
        }
        return _node;
    }

    public static JsonNode write(CreateTopicsRequestData _object, short _version) {
        return CreateTopicsRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class CreatableTopicJsonConverter {
        public static CreateTopicsRequestData.CreatableTopic read(JsonNode _node, short _version) {
            CreateTopicsRequestData.CreatableTopicConfigCollection _collection;
            CreateTopicsRequestData.CreatableReplicaAssignmentCollection _collection2;
            CreateTopicsRequestData.CreatableTopic _object = new CreateTopicsRequestData.CreatableTopic();
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("CreatableTopic: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("CreatableTopic expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.name = _nameNode.asText();
            JsonNode _numPartitionsNode = _node.get("numPartitions");
            if (_numPartitionsNode == null) {
                throw new RuntimeException("CreatableTopic: unable to locate field 'numPartitions', which is mandatory in version " + _version);
            }
            _object.numPartitions = MessageUtil.jsonNodeToInt(_numPartitionsNode, "CreatableTopic");
            JsonNode _replicationFactorNode = _node.get("replicationFactor");
            if (_replicationFactorNode == null) {
                throw new RuntimeException("CreatableTopic: unable to locate field 'replicationFactor', which is mandatory in version " + _version);
            }
            _object.replicationFactor = MessageUtil.jsonNodeToShort(_replicationFactorNode, "CreatableTopic");
            JsonNode _assignmentsNode = _node.get("assignments");
            if (_assignmentsNode == null) {
                throw new RuntimeException("CreatableTopic: unable to locate field 'assignments', which is mandatory in version " + _version);
            }
            if (!_assignmentsNode.isArray()) {
                throw new RuntimeException("CreatableTopic expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.assignments = _collection2 = new CreateTopicsRequestData.CreatableReplicaAssignmentCollection(_assignmentsNode.size());
            for (Object _element : _assignmentsNode) {
                _collection2.add(CreatableReplicaAssignmentJsonConverter.read((JsonNode)_element, _version));
            }
            JsonNode _configsNode = _node.get("configs");
            if (_configsNode == null) {
                throw new RuntimeException("CreatableTopic: unable to locate field 'configs', which is mandatory in version " + _version);
            }
            if (!_configsNode.isArray()) {
                throw new RuntimeException("CreatableTopic expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.configs = _collection = new CreateTopicsRequestData.CreatableTopicConfigCollection(_configsNode.size());
            for (JsonNode _element : _configsNode) {
                _collection.add(CreatableTopicConfigJsonConverter.read(_element, _version));
            }
            JsonNode _linkNameNode = _node.get("linkName");
            if (_linkNameNode == null) {
                _object.linkName = null;
            } else if (_linkNameNode.isNull()) {
                _object.linkName = null;
            } else {
                if (!_linkNameNode.isTextual()) {
                    throw new RuntimeException("CreatableTopic expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.linkName = _linkNameNode.asText();
            }
            JsonNode _mirrorTopicNode = _node.get("mirrorTopic");
            if (_mirrorTopicNode == null) {
                _object.mirrorTopic = null;
            } else if (_mirrorTopicNode.isNull()) {
                _object.mirrorTopic = null;
            } else {
                if (!_mirrorTopicNode.isTextual()) {
                    throw new RuntimeException("CreatableTopic expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.mirrorTopic = _mirrorTopicNode.asText();
            }
            JsonNode _sourceTopicIdNode = _node.get("sourceTopicId");
            if (_sourceTopicIdNode == null) {
                _object.sourceTopicId = Uuid.ZERO_UUID;
            } else {
                if (!_sourceTopicIdNode.isTextual()) {
                    throw new RuntimeException("CreatableTopic expected a JSON string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.sourceTopicId = Uuid.fromString(_sourceTopicIdNode.asText());
            }
            JsonNode _mirrorStartOffsetSpecNode = _node.get("mirrorStartOffsetSpec");
            _object.mirrorStartOffsetSpec = _mirrorStartOffsetSpecNode == null ? Long.MIN_VALUE : MessageUtil.jsonNodeToLong(_mirrorStartOffsetSpecNode, "CreatableTopic");
            JsonNode _mirrorStartOffsetsNode = _node.get("mirrorStartOffsets");
            if (_mirrorStartOffsetsNode == null) {
                _object.mirrorStartOffsets = new ArrayList<Long>(0);
            } else if (_mirrorStartOffsetsNode.isNull()) {
                _object.mirrorStartOffsets = null;
            } else {
                if (!_mirrorStartOffsetsNode.isArray()) {
                    throw new RuntimeException("CreatableTopic expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
                }
                ArrayList<Long> _collection3 = new ArrayList<Long>(_mirrorStartOffsetsNode.size());
                _object.mirrorStartOffsets = _collection3;
                for (JsonNode _element : _mirrorStartOffsetsNode) {
                    _collection3.add(MessageUtil.jsonNodeToLong(_element, "CreatableTopic element"));
                }
            }
            JsonNode _stoppedSequenceNumberNode = _node.get("stoppedSequenceNumber");
            _object.stoppedSequenceNumber = _stoppedSequenceNumberNode == null ? 0L : MessageUtil.jsonNodeToLong(_stoppedSequenceNumberNode, "CreatableTopic");
            return _object;
        }

        public static JsonNode write(CreateTopicsRequestData.CreatableTopic _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(_object.name));
            _node.set("numPartitions", (JsonNode)new IntNode(_object.numPartitions));
            _node.set("replicationFactor", (JsonNode)new ShortNode(_object.replicationFactor));
            ArrayNode _assignmentsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Object _element : _object.assignments) {
                _assignmentsArray.add(CreatableReplicaAssignmentJsonConverter.write((CreateTopicsRequestData.CreatableReplicaAssignment)_element, _version, _serializeRecords));
            }
            _node.set("assignments", (JsonNode)_assignmentsArray);
            ArrayNode _configsArray = new ArrayNode(JsonNodeFactory.instance);
            for (CreateTopicsRequestData.CreatableTopicConfig _element : _object.configs) {
                _configsArray.add(CreatableTopicConfigJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("configs", (JsonNode)_configsArray);
            if (_version >= 5) {
                if (_object.linkName != null) {
                    _node.set("linkName", (JsonNode)new TextNode(_object.linkName));
                }
            } else if (_object.linkName != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default linkName at version " + _version);
            }
            if (_version >= 5) {
                if (_object.mirrorTopic != null) {
                    _node.set("mirrorTopic", (JsonNode)new TextNode(_object.mirrorTopic));
                }
            } else if (_object.mirrorTopic != null) {
                throw new UnsupportedVersionException("Attempted to write a non-default mirrorTopic at version " + _version);
            }
            if (_version >= 7) {
                if (!_object.sourceTopicId.equals(Uuid.ZERO_UUID)) {
                    _node.set("sourceTopicId", (JsonNode)new TextNode(_object.sourceTopicId.toString()));
                }
            } else if (!_object.sourceTopicId.equals(Uuid.ZERO_UUID)) {
                throw new UnsupportedVersionException("Attempted to write a non-default sourceTopicId at version " + _version);
            }
            if (_version >= 7 && _object.mirrorStartOffsetSpec != Long.MIN_VALUE) {
                _node.set("mirrorStartOffsetSpec", (JsonNode)new LongNode(_object.mirrorStartOffsetSpec));
            }
            if (_version >= 7) {
                if (_object.mirrorStartOffsets == null || !_object.mirrorStartOffsets.isEmpty()) {
                    if (_object.mirrorStartOffsets == null) {
                        _node.set("mirrorStartOffsets", (JsonNode)NullNode.instance);
                    } else {
                        ArrayNode _mirrorStartOffsetsArray = new ArrayNode(JsonNodeFactory.instance);
                        for (Long _element : _object.mirrorStartOffsets) {
                            _mirrorStartOffsetsArray.add((JsonNode)new LongNode(_element.longValue()));
                        }
                        _node.set("mirrorStartOffsets", (JsonNode)_mirrorStartOffsetsArray);
                    }
                }
            } else if (_object.mirrorStartOffsets == null || !_object.mirrorStartOffsets.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default mirrorStartOffsets at version " + _version);
            }
            if (_version >= 7) {
                if (_object.stoppedSequenceNumber != 0L) {
                    _node.set("stoppedSequenceNumber", (JsonNode)new LongNode(_object.stoppedSequenceNumber));
                }
            } else if (_object.stoppedSequenceNumber != 0L) {
                throw new UnsupportedVersionException("Attempted to write a non-default stoppedSequenceNumber at version " + _version);
            }
            return _node;
        }

        public static JsonNode write(CreateTopicsRequestData.CreatableTopic _object, short _version) {
            return CreatableTopicJsonConverter.write(_object, _version, true);
        }
    }

    public static class CreatableTopicConfigJsonConverter {
        public static CreateTopicsRequestData.CreatableTopicConfig read(JsonNode _node, short _version) {
            CreateTopicsRequestData.CreatableTopicConfig _object = new CreateTopicsRequestData.CreatableTopicConfig();
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("CreatableTopicConfig: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("CreatableTopicConfig expected a string type, but got " + String.valueOf(_node.getNodeType()));
            }
            _object.name = _nameNode.asText();
            JsonNode _valueNode = _node.get("value");
            if (_valueNode == null) {
                throw new RuntimeException("CreatableTopicConfig: unable to locate field 'value', which is mandatory in version " + _version);
            }
            if (_valueNode.isNull()) {
                _object.value = null;
            } else {
                if (!_valueNode.isTextual()) {
                    throw new RuntimeException("CreatableTopicConfig expected a string type, but got " + String.valueOf(_node.getNodeType()));
                }
                _object.value = _valueNode.asText();
            }
            return _object;
        }

        public static JsonNode write(CreateTopicsRequestData.CreatableTopicConfig _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(_object.name));
            if (_object.value == null) {
                _node.set("value", (JsonNode)NullNode.instance);
            } else {
                _node.set("value", (JsonNode)new TextNode(_object.value));
            }
            return _node;
        }

        public static JsonNode write(CreateTopicsRequestData.CreatableTopicConfig _object, short _version) {
            return CreatableTopicConfigJsonConverter.write(_object, _version, true);
        }
    }

    public static class CreatableReplicaAssignmentJsonConverter {
        public static CreateTopicsRequestData.CreatableReplicaAssignment read(JsonNode _node, short _version) {
            CreateTopicsRequestData.CreatableReplicaAssignment _object = new CreateTopicsRequestData.CreatableReplicaAssignment();
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("CreatableReplicaAssignment: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            _object.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "CreatableReplicaAssignment");
            JsonNode _brokerIdsNode = _node.get("brokerIds");
            if (_brokerIdsNode == null) {
                throw new RuntimeException("CreatableReplicaAssignment: unable to locate field 'brokerIds', which is mandatory in version " + _version);
            }
            if (!_brokerIdsNode.isArray()) {
                throw new RuntimeException("CreatableReplicaAssignment expected a JSON array, but got " + String.valueOf(_node.getNodeType()));
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_brokerIdsNode.size());
            _object.brokerIds = _collection;
            for (JsonNode _element : _brokerIdsNode) {
                _collection.add(MessageUtil.jsonNodeToInt(_element, "CreatableReplicaAssignment element"));
            }
            return _object;
        }

        public static JsonNode write(CreateTopicsRequestData.CreatableReplicaAssignment _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", (JsonNode)new IntNode(_object.partitionIndex));
            ArrayNode _brokerIdsArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.brokerIds) {
                _brokerIdsArray.add((JsonNode)new IntNode(_element.intValue()));
            }
            _node.set("brokerIds", (JsonNode)_brokerIdsArray);
            return _node;
        }

        public static JsonNode write(CreateTopicsRequestData.CreatableReplicaAssignment _object, short _version) {
            return CreatableReplicaAssignmentJsonConverter.write(_object, _version, true);
        }
    }
}

