/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.security.oauthbearer;

import io.confluent.kafka.security.PemUtils;
import io.confluent.kafka.security.PrivateKeyUtils;
import io.confluent.kafka.security.oauthbearer.ClientAssertionHttpRequestFormatter;
import io.confluent.kafka.security.oauthbearer.ClientSecretHttpRequestFormatter;
import io.confluent.kafka.security.oauthbearer.HttpRequestFormatter;
import io.confluent.kafka.security.oauthbearer.HttpRequestFormatterFactory;
import io.confluent.kafka.security.oauthbearer.PrivateKeyClientAssertion;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.oauthbearer.internals.secured.ConfigurationUtils;
import org.apache.kafka.common.security.oauthbearer.internals.secured.JaasOptionsUtils;
import org.apache.kafka.common.utils.FileWatchService;
import org.apache.kafka.test.TestUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpRequestFormatterFactoryTest {
    static MockedStatic<LoggerFactory> loggerFactory;
    static Logger mockLog;
    private ConfigurationUtils cu;
    private JaasOptionsUtils jou;

    HttpRequestFormatterFactoryTest() {
    }

    @BeforeAll
    public static void beforeAll() {
        loggerFactory = Mockito.mockStatic(LoggerFactory.class);
        mockLog = (Logger)Mockito.mock(Logger.class);
        loggerFactory.when(() -> LoggerFactory.getLogger(HttpRequestFormatterFactory.class)).thenReturn((Object)mockLog);
        loggerFactory.when(() -> LoggerFactory.getLogger(PrivateKeyClientAssertion.class)).thenReturn((Object)mockLog);
        loggerFactory.when(() -> LoggerFactory.getLogger(FileWatchService.class)).thenReturn((Object)mockLog);
        loggerFactory.when(() -> LoggerFactory.getLogger(PemUtils.class)).thenReturn((Object)mockLog);
    }

    @BeforeEach
    public void before() {
        Mockito.reset((Object[])new Logger[]{mockLog});
    }

    public void initUtils(Map<String, ?> configs, Map<String, Object> jaasOptions) {
        this.cu = new ConfigurationUtils(configs);
        this.jou = new JaasOptionsUtils(jaasOptions);
    }

    private static String getFilePath(String pvtKeyFileName) throws IOException {
        String pvtKeyContents = new BufferedReader(new InputStreamReader(Objects.requireNonNull(ClassLoader.getSystemResourceAsStream(pvtKeyFileName)))).lines().collect(Collectors.joining("\n"));
        File pvtKeyFile = TestUtils.tempFile(pvtKeyContents);
        return pvtKeyFile.getPath();
    }

    @AfterAll
    public static void afterAll() {
        loggerFactory.close();
    }

    private static Map<String, Object> getSaslConfigs(String filepath) {
        HashMap<String, Object> mp = new HashMap<String, Object>();
        mp.put("sasl.oauthbearer.assertion.claim.iss", "issuer");
        mp.put("sasl.oauthbearer.assertion.file", null);
        mp.put("sasl.oauthbearer.assertion.claim.aud", "audience");
        mp.put("sasl.oauthbearer.assertion.claim.sub", "subject");
        mp.put("sasl.oauthbearer.assertion.claim.exp.minutes", 10);
        mp.put("sasl.oauthbearer.assertion.claim.nbf.include", true);
        mp.put("sasl.oauthbearer.assertion.claim.jti.include", true);
        mp.put("sasl.oauthbearer.assertion.private.key.file", filepath);
        mp.put("sasl.oauthbearer.assertion.private.key.passphrase", null);
        return mp;
    }

    private static Map<String, Object> getJaasOptions() {
        HashMap<String, Object> mp = new HashMap<String, Object>();
        mp.put("clientId", "clientId");
        mp.put("clientSecret", "clientSecret");
        return mp;
    }

    @Test
    void testCreateWithLocalClientAssertionwithPKCS1() throws Exception {
        KeyPair keyPair = PrivateKeyUtils.getRsaKeyPair();
        String contents = PrivateKeyUtils.getPkcs1PemKey(keyPair);
        String filepath = TestUtils.tempFile(contents).getAbsolutePath();
        Map<String, Object> configs = HttpRequestFormatterFactoryTest.getSaslConfigs(filepath);
        Map<String, Object> jaasOptions = HttpRequestFormatterFactoryTest.getJaasOptions();
        this.initUtils(configs, jaasOptions);
        HttpRequestFormatter formatter = HttpRequestFormatterFactory.create((ConfigurationUtils)this.cu, (JaasOptionsUtils)this.jou);
        Assertions.assertTrue((boolean)(formatter instanceof ClientAssertionHttpRequestFormatter));
        ((Logger)Mockito.verify((Object)mockLog, (VerificationMode)Mockito.times((int)1))).info("Configuring local client assertion creation");
        ((Logger)Mockito.verify((Object)mockLog, (VerificationMode)Mockito.times((int)1))).info("Client assertion config path is not provided, not configuring additional header and payload values");
    }

    @Test
    void testCreateWithLocalClientAssertionwithUnEncryptedPKCS8() throws Exception {
        String pvtKeyFilePath = HttpRequestFormatterFactoryTest.getFilePath("pkcs8KeypairUnencrypted.pem");
        Map<String, Object> configs = HttpRequestFormatterFactoryTest.getSaslConfigs(pvtKeyFilePath);
        Map<String, Object> jaasOptions = HttpRequestFormatterFactoryTest.getJaasOptions();
        this.initUtils(configs, jaasOptions);
        HttpRequestFormatter formatter = HttpRequestFormatterFactory.create((ConfigurationUtils)this.cu, (JaasOptionsUtils)this.jou);
        Assertions.assertTrue((boolean)(formatter instanceof ClientAssertionHttpRequestFormatter));
        ((Logger)Mockito.verify((Object)mockLog, (VerificationMode)Mockito.times((int)1))).info("Configuring local client assertion creation");
        ((Logger)Mockito.verify((Object)mockLog, (VerificationMode)Mockito.times((int)1))).info("Client assertion config path is not provided, not configuring additional header and payload values");
    }

    @Test
    void testCreateWithLocalClientAssertionwithEncryptedPKCS8() throws Exception {
        String pvtKeyFilePath = HttpRequestFormatterFactoryTest.getFilePath("pkcs8KeypairEncrypted_PBE-SHA1-3DES.pem");
        Map<String, Object> configs = HttpRequestFormatterFactoryTest.getSaslConfigs(pvtKeyFilePath);
        Map<String, Object> jaasOptions = HttpRequestFormatterFactoryTest.getJaasOptions();
        configs.put("sasl.oauthbearer.assertion.private.key.passphrase", new Password("secretpass"));
        this.initUtils(configs, jaasOptions);
        HttpRequestFormatter formatter = HttpRequestFormatterFactory.create((ConfigurationUtils)this.cu, (JaasOptionsUtils)this.jou);
        Assertions.assertTrue((boolean)(formatter instanceof ClientAssertionHttpRequestFormatter));
        ((Logger)Mockito.verify((Object)mockLog, (VerificationMode)Mockito.times((int)1))).info("Configuring local client assertion creation");
        ((Logger)Mockito.verify((Object)mockLog, (VerificationMode)Mockito.times((int)1))).info("Client assertion config path is not provided, not configuring additional header and payload values");
    }

    @Test
    void testCreateWithLocalClientAssertionwithEncryptedPKCS8withBCProvider() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        String pvtKeyFilePath = HttpRequestFormatterFactoryTest.getFilePath("pkcs8KeypairEncrypted.pem");
        Map<String, Object> configs = HttpRequestFormatterFactoryTest.getSaslConfigs(pvtKeyFilePath);
        Map<String, Object> jaasOptions = HttpRequestFormatterFactoryTest.getJaasOptions();
        configs.put("sasl.oauthbearer.assertion.private.key.passphrase", new Password("secretpass"));
        this.initUtils(configs, jaasOptions);
        HttpRequestFormatter formatter = HttpRequestFormatterFactory.create((ConfigurationUtils)this.cu, (JaasOptionsUtils)this.jou);
        Assertions.assertTrue((boolean)(formatter instanceof ClientAssertionHttpRequestFormatter));
        ((Logger)Mockito.verify((Object)mockLog, (VerificationMode)Mockito.times((int)1))).info("Configuring local client assertion creation");
        ((Logger)Mockito.verify((Object)mockLog, (VerificationMode)Mockito.times((int)1))).info("Client assertion config path is not provided, not configuring additional header and payload values");
    }

    @Test
    void testCreateWithFileClientAssertion() {
        Map<String, Object> configs = HttpRequestFormatterFactoryTest.getSaslConfigs("testing");
        Map<String, Object> jaasOptions = HttpRequestFormatterFactoryTest.getJaasOptions();
        this.initUtils(configs, jaasOptions);
        configs.put("sasl.oauthbearer.assertion.file", "file path");
        HttpRequestFormatter formatter = HttpRequestFormatterFactory.create((ConfigurationUtils)this.cu, (JaasOptionsUtils)this.jou);
        Assertions.assertTrue((boolean)(formatter instanceof ClientAssertionHttpRequestFormatter));
        ((Logger)Mockito.verify((Object)mockLog, (VerificationMode)Mockito.times((int)1))).info("Configuring File based client assertion using file: {}", (Object)"file path");
    }

    @Test
    void testCreateWithClientAssertionThrowsException() {
        Map<String, Object> configs = HttpRequestFormatterFactoryTest.getSaslConfigs("privateKeyPath");
        Map<String, Object> jaasOptions = HttpRequestFormatterFactoryTest.getJaasOptions();
        this.initUtils(configs, jaasOptions);
        Assertions.assertThrows(KafkaException.class, () -> HttpRequestFormatterFactory.create((ConfigurationUtils)this.cu, (JaasOptionsUtils)this.jou));
    }

    @Test
    void testCreateWithClientSecret() {
        HashMap configs = new HashMap();
        Map<String, Object> jaasOptions = HttpRequestFormatterFactoryTest.getJaasOptions();
        this.initUtils(configs, jaasOptions);
        HttpRequestFormatter formatter = HttpRequestFormatterFactory.create((ConfigurationUtils)this.cu, (JaasOptionsUtils)this.jou);
        Assertions.assertTrue((boolean)(formatter instanceof ClientSecretHttpRequestFormatter));
    }

    @ParameterizedTest
    @MethodSource(value={"urlEncodeHeaderSupplier"})
    public void testUrlEncodeHeader(Map<String, Object> configs, boolean expectedValue) {
        ConfigurationUtils cu = new ConfigurationUtils(configs);
        boolean actualValue = HttpRequestFormatterFactory.validateUrlEncodeHeader((ConfigurationUtils)cu);
        Assertions.assertEquals((Object)expectedValue, (Object)actualValue);
    }

    private static Stream<Arguments> urlEncodeHeaderSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{Collections.emptyMap(), false}), Arguments.of((Object[])new Object[]{Collections.singletonMap("sasl.oauthbearer.header.urlencode", null), false}), Arguments.of((Object[])new Object[]{Collections.singletonMap("sasl.oauthbearer.header.urlencode", true), true}), Arguments.of((Object[])new Object[]{Collections.singletonMap("sasl.oauthbearer.header.urlencode", false), false}));
    }
}

